/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IOsiConstants;
import cerent.cms.model.TarpRequestInited;
import cerent.cms.ui.helper.OsiHelper;
import cerent.cms.ui.shelf.NsapPanel;
import cerent.cms.ui.shelf.OsiTarpDataCachePane;
import cerent.util.SDebug;
import cerent.util.gui.GridPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TdcCreationPane
extends JPanel
implements DocumentListener,
IOsiConstants {
    private final int NSAP_ADDR_LEN = 40;
    private final int TID_ADDR_LEN = 20;
    protected OsiTarpDataCachePane tdcpane;
    private JTextField tidTF;
    private NsapPanel nsapP;
    private static final SDebug db = new SDebug("TdcCreationPane");

    protected TdcCreationPane(OsiTarpDataCachePane osiTarpDataCachePane) {
        if (db.on()) {
            db.println("<init>: start");
        }
        this.tdcpane = osiTarpDataCachePane;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createAttributesPanel(), "Center");
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    protected JPanel createAttributesPanel() {
        this.tidTF = new JTextField(20);
        this.nsapP = new NsapPanel(1);
        GridPanel gridPanel = new GridPanel();
        gridPanel.addRow("TID", (JComponent)this.tidTF);
        if (this.tdcpane.isProvision) {
            gridPanel.addRow("NSAP", (JComponent)this.nsapP);
        }
        this.tidTF.getDocument().addDocumentListener(this);
        return gridPanel;
    }

    public void onValidate() throws Exception {
        if (this.tidTF.getText().length() == 0) {
            throw new Exception("The TID field cannot be empty.");
        }
        if (this.tdcpane.isProvision) {
            OsiHelper.getNsapBytes((String)this.nsapP.getText());
        }
    }

    protected void documentModified(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.tidTF.getDocument() && this.tidTF.getText().length() > 20) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Toolkit.getDefaultToolkit().beep();
                    TdcCreationPane.this.tidTF.setText(TdcCreationPane.this.tidTF.getText().substring(0, 20));
                }
            });
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public void applyChangesToModel() throws Exception {
        if (!this.tdcpane.isProvision) {
            if (this.tdcpane.tarpModel.resolveTid(this.tidTF.getText().trim())) {
                throw new TarpRequestInited("TarpRequestInited");
            }
        } else {
            this.tdcpane.tarpModel.addTdcEntry(this.tidTF.getText().trim(), OsiHelper.getNsapBytes((String)this.nsapP.getText()));
        }
        this.tdcpane.repopulateTable();
    }
}

