/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Synchronization.eTimingSystem;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.ui.shelf.AbstractSppTimingPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TimingStandardDialog
extends UDialog
implements ActionListener {
    protected JButton okButton;
    protected JButton cancelButton;
    JRadioButton sonetRB;
    JRadioButton sdhRB;
    private SynchronizationModel syncModel;
    private static final String TITLE = "Change Timing Standard";
    protected static final SDebug db = new SDebug("TimingStandardDialog");

    public static TimingStandardDialog instance(AbstractSppTimingPane abstractSppTimingPane, Object object) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)abstractSppTimingPane));
        return new TimingStandardDialog(frame, TITLE, object);
    }

    protected TimingStandardDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        if (object != null) {
            this.syncModel = (SynchronizationModel)object;
        }
        JPanel jPanel2 = TimingStandardDialog.createVerticalPanel("Timing Standard");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.sonetRB = new JRadioButton("SONET");
        this.sonetRB.addActionListener(this);
        this.sdhRB = new JRadioButton("SDH");
        this.sdhRB.addActionListener(this);
        buttonGroup.add(this.sonetRB);
        buttonGroup.add(this.sdhRB);
        jPanel2.add(this.sonetRB);
        jPanel2.add(this.sdhRB);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        if (this.syncModel.getTimingStandard() == eTimingSystem.SONET_TIMING) {
            this.sonetRB.setSelected(true);
        } else {
            this.sdhRB.setSelected(true);
        }
        this.setSize(new Dimension(600, 600));
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel2.add(this.okButton);
        this.okButton.setEnabled(false);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel2.add(this.cancelButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        db.fine("actionPerformed from " + object);
        if (object == this.sonetRB || object == this.sdhRB) {
            this.okButton.setEnabled(true);
        } else if (object == this.okButton) {
            if (ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)EMC.WID_CHG_TIMING_STD, TITLE)) {
                this.ok();
            }
            this.dispose();
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected void ok() {
        eTimingSystem eTimingSystem2 = eTimingSystem.SONET_TIMING;
        if (this.sdhRB.isSelected()) {
            eTimingSystem2 = eTimingSystem.SDH_TIMING;
        }
        if (db.on()) {
            db.println("setTimingStandard: " + eTimingSystem2);
        }
        try {
            this.syncModel.setTimingStandard(eTimingSystem2);
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            CerentDialog.errorDialog((Component)((Object)this), (String)exception.getMessage(), (String)"Error");
        }
    }

    public static JPanel createVerticalPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jPanel;
    }
}

