/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp;

import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.LmpConstants;
import cerent.cms.model.LmpException;
import cerent.cms.model.LmpTeLinkModels;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.lmp.RemoteNodeIdWrapper;
import cerent.cms.ui.shelf.lmp.TeLinkDataSource;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.Preferences;
import cerent.util.gui.TextAreaDialog;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TeLinkCreationDialog
extends UDialog
implements ActionListener,
LmpConstants {
    public static final String TITLE = "Create LMP TE Link";
    protected boolean isCrs;
    private JButton okButton;
    private JButton cancelButton;
    private Pane parent;
    protected TeLinkDataSource dsc;
    protected TeLinkDataSource.Info value;
    protected JComboBox adminState;
    protected JLabel localTeLinkIdLabel;
    protected JTextField localTeLinkId;
    protected JComboBox remoteNodeId;
    protected JTextField remoteTeLinkId;
    protected JComboBox muxCap;
    private boolean ok = false;
    private LmpTeLinkModels models;
    private ComboBoxModel dwdmMuxCapModel;
    private ComboBoxModel crsMuxCapModel;

    public static TeLinkCreationDialog getCreationDialog(Pane pane, TeLinkDataSource teLinkDataSource, LmpTeLinkModels lmpTeLinkModels) {
        return new TeLinkCreationDialog(JOptionPane.getFrameForComponent((Component)pane), TITLE, new Object[]{pane, teLinkDataSource, lmpTeLinkModels});
    }

    protected TeLinkCreationDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        boolean bl;
        this.ok = false;
        Object[] objectArray = (Object[])object;
        this.parent = (Pane)objectArray[0];
        this.dsc = (TeLinkDataSource)objectArray[1];
        this.models = (LmpTeLinkModels)objectArray[2];
        boolean bl2 = bl = this.value != null;
        if (this.value == null) {
            this.value = new TeLinkDataSource.Info(this.dsc);
        } else {
            TeLinkDataSource teLinkDataSource = this.dsc;
            teLinkDataSource.getClass();
            this.value = new TeLinkDataSource.Info(teLinkDataSource, this.value);
        }
        jPanel.add((Component)this.getCenterPanel(bl), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        this.parent = null;
        this.dsc = null;
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.valuesOk()) {
                this.ok = true;
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.ok = false;
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    public boolean ok() {
        return this.ok;
    }

    public TeLinkDataSource.Info getValues() {
        return this.value;
    }

    private void displayStatusMessage(final String string, final String string2) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TextAreaDialog(JOptionPane.getFrameForComponent((Component)((Object)TeLinkCreationDialog.this)), string, string2, 650, 200);
            }
        });
    }

    private String toString(Exception exception) {
        int n;
        if (exception instanceof NumberFormatException) {
            return "invalid number format: " + exception.getMessage();
        }
        String string = exception.getMessage();
        if ((string == null || string.length() == 0) && (n = (string = exception.toString()).lastIndexOf(46)) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private boolean valuesOk() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TeLinkDataSource.Column column = this.dsc.getColumn("Admin State");
        try {
            column.setColumnValue(this.value, this.adminState.getSelectedItem());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Remote Node Id");
        try {
            column.setColumnValue(this.value, this.remoteNodeId.getSelectedItem());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Remote TE Link Id");
        try {
            boolean bl = Preferences.instance().getInt("ctc.router", "skipLmp", 0) != 0;
            column.setColumnValue(this.value, this.isCrs && !bl && this.remoteTeLinkId.getText().length() == 0 ? Integer.toString(this.models.getTempIdForCrsTe()) : this.remoteTeLinkId.getText());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("MUX Capability");
        try {
            column.setColumnValue(this.value, this.muxCap.getSelectedItem());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        if (arrayList.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Failed to validate LMP TE Link parameters:\n\n");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Exception exception = (Exception)iterator.next();
                stringBuffer.append(string);
                stringBuffer.append(": ");
                stringBuffer.append(this.toString(exception));
                stringBuffer.append("\n");
            }
            this.displayStatusMessage("LMP TE Link Validation Errors", stringBuffer.toString());
        }
        return arrayList.size() <= 0;
    }

    private void helpPutDefaultAdminState(String string, JComboBox jComboBox) {
        jComboBox.setSelectedItem(this.dsc.getAdminStateChoice(this.dsc.getDefaultValue(string)));
    }

    private void helpPutDefaultMuxCap(String string, JComboBox jComboBox) {
        jComboBox.setSelectedItem(this.dsc.getMuxCapChoice(this.dsc.getDefaultValue(string)));
    }

    private void putDefaults() {
        this.helpPutDefaultAdminState("Admin State", this.adminState);
        this.helpPutDefaultMuxCap("MUX Capability", this.muxCap);
    }

    private JPanel getCenterPanel(boolean bl) {
        RemoteNodeIdWrapper[] remoteNodeIdWrapperArray;
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 5, 5));
        try {
            remoteNodeIdWrapperArray = bl ? this.dsc.getFilteredRemoteNodeIdChoices(this.value) : this.dsc.getRemoteNodeIdChoices();
        }
        catch (LmpException lmpException) {
            ErrorMsg.displayError((Component)((Object)this), (EID)lmpException.getEid());
            remoteNodeIdWrapperArray = new RemoteNodeIdWrapper[]{};
        }
        this.dwdmMuxCapModel = new DefaultComboBoxModel<Attribute>(this.dsc.getMuxCapChoices());
        this.crsMuxCapModel = new DefaultComboBoxModel<Attribute>(this.dsc.getCrsMuxCapChoices());
        jPanel.add(new JLabel("Admin State:", 4));
        this.adminState = new JComboBox<AdminState>(this.dsc.getAdminStateChoices());
        jPanel.add(this.adminState);
        this.localTeLinkIdLabel = new JLabel("Local TE Link Id", 4);
        jPanel.add(this.localTeLinkIdLabel);
        this.localTeLinkId = new JTextField(20);
        jPanel.add(this.localTeLinkId);
        jPanel.add(new JLabel("Remote Node Id:", 4));
        this.remoteNodeId = new JComboBox<RemoteNodeIdWrapper>(remoteNodeIdWrapperArray);
        jPanel.add(this.remoteNodeId);
        jPanel.add(new JLabel("Remote TE Link Id:", 4));
        this.remoteTeLinkId = new JTextField(20);
        jPanel.add(this.remoteTeLinkId);
        jPanel.add(new JLabel("MUX Capability:", 4));
        this.muxCap = new JComboBox(this.dwdmMuxCapModel);
        jPanel.add(this.muxCap);
        this.remoteNodeId.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TeLinkCreationDialog.this.checkRemoteNode();
            }
        });
        this.putDefaults();
        this.localTeLinkIdLabel.setVisible(false);
        this.localTeLinkId.setVisible(false);
        this.localTeLinkId.setEnabled(false);
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(this.getCsHelpId()));
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected void checkRemoteNode() {
        RemoteNodeIdWrapper remoteNodeIdWrapper = (RemoteNodeIdWrapper)this.remoteNodeId.getSelectedItem();
        try {
            this.isCrs = remoteNodeIdWrapper.getControlChannel().isRemoteCrs();
        }
        catch (LmpException lmpException) {
            ErrorMsg.displayError((Component)((Object)this), (EID)lmpException.getEid());
            this.isCrs = false;
        }
        this.remoteTeLinkId.setEnabled(!this.isCrs || Preferences.instance().getInt("ctc.router", "skipLmp", 0) != 0);
        this.muxCap.setModel(this.isCrs ? this.crsMuxCapModel : this.dwdmMuxCapModel);
        this.muxCap.setEnabled(!this.isCrs);
    }

    protected CSHelpID getCsHelpId() {
        return CSHelpConst.LmpTeLinkCreationDialog;
    }
}

