/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp.crs;

import cerent.cms.idl.Lmp.sControlChannelAttrsEx;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.LmpException;
import cerent.cms.ui.shelf.lmp.crs.CcCommand;
import cerent.cms.ui.shelf.lmp.crs.CrsControlChannelManager;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.tty.CLIAction;
import cerent.util.tty.CLIControlChannelAction;
import cerent.util.tty.CLIShowArpAction;
import java.awt.Component;
import java.util.List;

class CcDeleteCmd
extends CcCommand {
    private boolean setLocal;
    private int ccId;
    private String crsIpAddr;
    private UndoState undoState;
    private sControlChannelAttrsEx attrs;
    private boolean setRemote;

    public CcDeleteCmd(CrsControlChannelManager crsControlChannelManager, int n, sControlChannelAttrsEx sControlChannelAttrsEx2, boolean bl, boolean bl2) {
        super(crsControlChannelManager);
        this.ccId = n;
        this.attrs = sControlChannelAttrsEx2;
        this.crsIpAddr = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sControlChannelAttrsEx2.remote_ip));
        this.setLocal = bl;
        this.setRemote = bl2;
    }

    @Override
    public boolean execute() {
        this.undoState = UndoState.NO_CHANGE;
        if (this.setRemote) {
            CLIControlChannelAction cLIControlChannelAction = new CLIControlChannelAction(this.crsIpAddr, (KDebug)this.mgr.db);
            if (cLIControlChannelAction.delete(this.mgr.localIp)) {
                this.showCliError((CLIAction)cLIControlChannelAction);
                return false;
            }
            this.undoState = UndoState.SET_REMOTE;
        }
        if (this.setLocal) {
            try {
                this.mgr.node.getLmpCtrlChannelModels().deleteCtrlChannel(this.ccId);
            }
            catch (LmpException lmpException) {
                ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)lmpException.getEid());
                return false;
            }
            this.undoState = UndoState.SET_LOCAL;
        }
        return true;
    }

    @Override
    public boolean undo() {
        CLIShowArpAction cLIShowArpAction;
        String string = null;
        if (this.setRemote && this.undoState != UndoState.NO_CHANGE) {
            cLIShowArpAction = new CLIShowArpAction(this.crsIpAddr, (KDebug)this.mgr.db);
            List list = cLIShowArpAction.get();
            if (list == null) {
                ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_CRS_IO_ERROR);
                return false;
            }
            for (CLIShowArpAction.ArpInfo arpInfo : list) {
                if (!arpInfo.getIp().equals(this.crsIpAddr)) continue;
                string = arpInfo.getMgmtInterface();
                break;
            }
            if (string == null) {
                ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_CRS_BAD_ARP_PARAM_1, (Object)this.crsIpAddr);
                return false;
            }
        }
        switch (this.undoState) {
            case SET_LOCAL: {
                try {
                    this.mgr.node.getLmpCtrlChannelModels().createCtrlChannel(this.attrs);
                }
                catch (LmpException lmpException) {
                    ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)lmpException.getEid());
                    return false;
                }
                if (!this.setRemote) break;
            }
            case SET_REMOTE: {
                cLIShowArpAction = new CLIControlChannelAction(this.crsIpAddr, (KDebug)this.mgr.db);
                if (!cLIShowArpAction.create(this.mgr.localIp, this.crsIpAddr, string)) break;
                this.showCliError((CLIAction)cLIShowArpAction);
                return false;
            }
        }
        return true;
    }

    private static enum UndoState {
        NO_CHANGE,
        SET_REMOTE,
        SET_LOCAL;

    }
}

