/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp.crs;

import cerent.cms.idl.Lmp.sControlChannelAttrsEx;
import cerent.cms.idl.Node.eProductId;
import cerent.cms.model.INodeHelper;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.LmpCtrlChannelModel;
import cerent.cms.model.LmpException;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.shelf.lmp.CtrlChannelPane;
import cerent.cms.ui.shelf.lmp.crs.CcCommand;
import cerent.cms.ui.shelf.lmp.crs.CcCommandGroup;
import cerent.cms.ui.shelf.lmp.crs.CcCreateCmd;
import cerent.cms.ui.shelf.lmp.crs.CcDeleteCmd;
import cerent.cms.ui.shelf.lmp.crs.CcEditCmd;
import cerent.cms.ui.shelf.lmp.crs.CcVersionCheckCmd;
import cerent.cms.ui.shelf.lmp.crs.ICrsLmpCallback;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.Pair;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class CrsControlChannelManager {
    CtrlChannelPane pane;
    INodeHelper nodeHelper;
    NodeModelDelegate node;
    SDebug db;
    String localIp;
    private ICrsLmpCallback cb;

    public CrsControlChannelManager(CtrlChannelPane ctrlChannelPane, NodeModelDelegate nodeModelDelegate, INodeHelper iNodeHelper, ICrsLmpCallback iCrsLmpCallback, SDebug sDebug) {
        this.pane = ctrlChannelPane;
        this.node = nodeModelDelegate;
        this.nodeHelper = iNodeHelper;
        this.cb = iCrsLmpCallback;
        this.db = sDebug;
        this.localIp = InetUtil.makeDottedString(nodeModelDelegate.getIpConfig().getIpAddress());
    }

    public void create(sControlChannelAttrsEx sControlChannelAttrsEx2) {
        ArrayList<CcCommand> arrayList = new ArrayList<CcCommand>();
        String string = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sControlChannelAttrsEx2.remote_ip));
        if (Preferences.instance().getInt("ctc.router", "skipLmp", 0) == 0) {
            arrayList.add(new CcVersionCheckCmd(this, string));
            arrayList.add(new CcCreateCmd(this, string, sControlChannelAttrsEx2, true, true));
        } else {
            arrayList.add(new CcCreateCmd(this, string, sControlChannelAttrsEx2, true, false));
        }
        ArrayList<CcCommand> arrayList2 = new ArrayList<CcCommand>(1);
        arrayList2.add(new CcCommandGroup(this, arrayList));
        new Thread(new Invoker(arrayList2, "Creating control channel...")).start();
    }

    public void edit(LmpCtrlChannelModel lmpCtrlChannelModel, sControlChannelAttrsEx sControlChannelAttrsEx2) {
        Object object;
        ArrayList<CcCommand> arrayList = new ArrayList<CcCommand>();
        String string = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sControlChannelAttrsEx2.remote_ip));
        try {
            object = new sControlChannelAttrsEx(lmpCtrlChannelModel.getAdminState(), lmpCtrlChannelModel.getIndex(), lmpCtrlChannelModel.getRemoteNodeId(), lmpCtrlChannelModel.getRemoteNodeIpAddress(), (short)lmpCtrlChannelModel.getHello(), (short)lmpCtrlChannelModel.getHelloMin(), (short)lmpCtrlChannelModel.getHelloMax(), (short)lmpCtrlChannelModel.getHelloDead(), (short)lmpCtrlChannelModel.getHelloDeadMin(), (short)lmpCtrlChannelModel.getHelloDeadMax(), eProductId.from_int(lmpCtrlChannelModel.getRemoteNodeType().getId()));
            String string2 = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(lmpCtrlChannelModel.getRemoteNodeIpAddress()));
            if (!string.equals(string2) && Preferences.instance().getInt("crs.router", "skipLmp", 0) == 0) {
                arrayList.add(new CcVersionCheckCmd(this, string));
                arrayList.add(new CcDeleteCmd(this, lmpCtrlChannelModel.getLocalCtrlChannelId(), (sControlChannelAttrsEx)object, false, true));
                arrayList.add(new CcCreateCmd(this, string, sControlChannelAttrsEx2, false, true));
            }
            arrayList.add(new CcEditCmd(this, lmpCtrlChannelModel, sControlChannelAttrsEx2));
        }
        catch (LmpException lmpException) {
            ErrorMsg.displayError((Component)((Object)this.pane), (EID)lmpException.getEid());
            return;
        }
        object = new ArrayList(1);
        object.add(new CcCommandGroup(this, arrayList));
        new Thread(new Invoker((List<CcCommand>)object, "Editing control channel...")).start();
    }

    public void delete(List<Pair<Integer, sControlChannelAttrsEx>> list) {
        ArrayList<CcCommand> arrayList = new ArrayList<CcCommand>();
        boolean bl = Preferences.instance().getInt("ctc.router", "skipLmp", 0) == 0;
        for (Pair<Integer, sControlChannelAttrsEx> pair : list) {
            arrayList.add(new CcDeleteCmd(this, (Integer)pair.getFirst(), (sControlChannelAttrsEx)pair.getSecond(), true, bl));
        }
        new Thread(new Invoker(arrayList, "Deleting control channels...")).start();
    }

    private class Invoker
    implements Runnable {
        private List<CcCommand> commands;
        private String message;

        public Invoker(List<CcCommand> list, String string) {
            this.commands = list;
            this.message = string;
        }

        @Override
        public void run() {
            CrsControlChannelManager.this.cb.operationStarted(this.message);
            for (CcCommand ccCommand : this.commands) {
                if (ccCommand.execute()) continue;
                CrsControlChannelManager.this.cb.operationStarted("Rolling back...");
                if (!ccCommand.undo()) {
                    ErrorMsg.displayError((Component)((Object)CrsControlChannelManager.this.pane), (EID)EMC.EID_ROLLBACK_FAILED);
                }
                CrsControlChannelManager.this.cb.operationStarted(this.message);
            }
            CrsControlChannelManager.this.cb.operationStopped();
        }
    }
}

