/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.sdh;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eQualityLevel;
import cerent.cms.idl.Ds123Media.eLineCoding;
import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.idl.Ds123Media.eSaBit;
import cerent.cms.idl.Synchronization.eBits;
import cerent.cms.idl.Synchronization.eBitsLBO;
import cerent.cms.idl.Synchronization.eCableType;
import cerent.cms.idl.Synchronization.sBitsConfig;
import cerent.cms.model.Attribute;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractBitsProvPane;
import cerent.cms.ui.shelf.AbstractSppTimingBitsPane;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;

public abstract class AbstractSdhBitsProvPane
extends AbstractBitsProvPane {
    protected static final String DS1 = "DS1";
    protected static final String[] codingChoices = new String[]{"HDB3", "AMI", "N/A"};
    protected static final eLineCoding[] codingValue = new eLineCoding[]{eLineCoding.HDB3, eLineCoding.AMI, eLineCoding.LINECODING_NOT_APPLICABLE};
    protected static final String[] framingChoices = new String[]{"Unframed", "FAS", "FAS+CAS", "FAS+CRC", "FAS+CAS+CRC", "N/A"};
    protected static final eLineType[] framingValue = new eLineType[]{eLineType.E1_UNFRAME, eLineType.E1_FRAME, eLineType.E1_MF, eLineType.E1_CRC, eLineType.E1_CRCMF, eLineType.LINETYPE_NOT_APPLICABLE};
    protected static final String[] sabitChoices = new String[]{"4", "5", "6", "7", "8", "N/A"};
    protected static final eCableType[] cableTypeValue = new eCableType[]{eCableType.PAUSE_75_OHM, eCableType.PAUSE_120_OHM, eCableType.PAUSE_100_OHM};
    private SynchronizationModel syncModel;

    public AbstractSdhBitsProvPane(String string, TabbedView tabbedView, AbstractSppTimingBitsPane abstractSppTimingBitsPane, eBits eBits2, SynchronizationModel synchronizationModel) {
        super(string, tabbedView, abstractSppTimingBitsPane, eBits2);
        this.syncModel = synchronizationModel;
    }

    protected abstract eLineCoding getCodingFromSelection(int var1);

    protected abstract eLineType getFramingFromSelection(int var1);

    protected abstract int getFramingIndex(eLineType var1);

    @Override
    protected String[] getCodingChoices() {
        return codingChoices;
    }

    @Override
    protected String[] getFramingChoices() {
        return framingChoices;
    }

    @Override
    public Attribute[] getQualityChoices() {
        return attrMap.getAttributeArray("timingSdhSsmQuality");
    }

    public Attribute getQualityAttribute(int n) {
        return attrMap.getAttributeForVal("timingSdhSsmQuality", n);
    }

    @Override
    public Attribute[] getCableTypeChoices() {
        return attrMap.getAttributeArray("e1BitsCableType");
    }

    public Attribute getCableTypeAttribute(int n) {
        return attrMap.getAttributeForVal("fullSetBitsCableType", n);
    }

    protected eCableType getCableTypeSelection(Attribute attribute) {
        return eCableType.from_int(attribute.getIntValue());
    }

    public JComboBox createBitsInSabit() {
        this.sabitBitsInCB = new JComboBox<String>(sabitChoices);
        this.sabitBitsInCB.setName("Sa Bit");
        this.sabitBitsInCB.addActionListener(this);
        this.enableComponent(this.sabitBitsInCB);
        return this.sabitBitsInCB;
    }

    public JComboBox createBitsOutSabit() {
        this.sabitBitsOutCB = new JComboBox<String>(sabitChoices);
        this.sabitBitsOutCB.setName("Sa Bit");
        this.sabitBitsOutCB.addActionListener(this);
        this.enableComponent(this.sabitBitsOutCB);
        return this.sabitBitsOutCB;
    }

    public JComboBox createBitsInCableType() {
        this.cableTypeBitsInCB = new JComboBox<Attribute>(this.getCableTypeChoices());
        this.cableTypeBitsInCB.setName("Cable Type:");
        this.cableTypeBitsInCB.addActionListener(this);
        this.enableComponent(this.cableTypeBitsInCB);
        return this.cableTypeBitsInCB;
    }

    public JComboBox createBitsOutCableType() {
        this.cableTypeBitsOutCB = new JComboBox<Attribute>(this.getCableTypeChoices());
        this.cableTypeBitsOutCB.setName("Cable Type:");
        this.cableTypeBitsOutCB.addActionListener(this);
        this.enableComponent(this.cableTypeBitsOutCB);
        return this.cableTypeBitsOutCB;
    }

    @Override
    public void updateBitsInValues() {
        int n = this.codingBitsInCB.getItemCount();
        if (this.parent.isBits2M(0)) {
            if (n < codingChoices.length) {
                this.codingBitsInCB.addItem("N/A");
            }
            this.codingBitsInCB.setSelectedItem("N/A");
        } else {
            if (n == codingChoices.length) {
                this.codingBitsInCB.removeItemAt(n - 1);
            }
            this.codingBitsInCB.setSelectedIndex(1);
        }
        int n2 = this.sabitBitsInCB.getItemCount();
        if (this.parent.isBits64K(0) || this.parent.isBits2M(0) || this.parent.isBitsT1(0)) {
            if (n2 < sabitChoices.length) {
                this.sabitBitsInCB.addItem("N/A");
            }
            this.sabitBitsInCB.setSelectedItem("N/A");
        } else if (n2 == sabitChoices.length) {
            this.sabitBitsInCB.removeItemAt(n2 - 1);
            this.sabitBitsInCB.setSelectedIndex(0);
        }
        if (this.cableTypeBitsInCB != null) {
            if (this.parent.isBits64K(0)) {
                this.cableTypeBitsInCB.setSelectedIndex(1);
            } else {
                this.cableTypeBitsInCB.setSelectedIndex(0);
            }
        }
        super.updateBitsInValues();
    }

    @Override
    public void updateBitsOutValues() {
        int n = this.codingBitsOutCB.getItemCount();
        this.codingBitsOutCB.setSelectedIndex(1);
        if (this.parent.isBits2M(1) || this.parent.isBitsT1(1)) {
            if (n < codingChoices.length) {
                this.codingBitsOutCB.addItem("N/A");
            }
            this.codingBitsOutCB.setSelectedItem("N/A");
        } else if ((this.parent.isBits64K(1) || this.parent.isBitsE1(1)) && n == codingChoices.length) {
            this.codingBitsOutCB.removeItemAt(n - 1);
        }
        int n2 = this.sabitBitsOutCB.getItemCount();
        if (this.parent.isBits64K(1) || this.parent.isBits2M(1) || this.parent.isBitsT1(0)) {
            if (n2 < sabitChoices.length) {
                this.sabitBitsOutCB.addItem("N/A");
            }
            this.sabitBitsOutCB.setSelectedItem("N/A");
        } else {
            if (n2 == sabitChoices.length) {
                this.sabitBitsOutCB.removeItemAt(n2 - 1);
            }
            this.sabitBitsOutCB.setSelectedIndex(0);
        }
        if (this.cableTypeBitsOutCB != null) {
            if (this.parent.isBits64K(1)) {
                this.cableTypeBitsOutCB.setSelectedIndex(1);
            } else {
                this.cableTypeBitsOutCB.setSelectedIndex(0);
            }
        }
        super.updateBitsOutValues();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.framingBitsInCB) {
            if (this.isSyncMsgFraming(0)) {
                this.enableComponent(this.sabitBitsInCB);
            } else {
                this.sabitBitsInCB.setEnabled(false);
            }
        }
    }

    @Override
    public void applyChangesToModel() throws Exception {
        sBitsConfig sBitsConfig2 = new sBitsConfig();
        if (db.on()) {
            db.println("eneter ASBPP applyChangesToModel");
        }
        sBitsConfig2.facilityType = this.parent.getFacilityTypeSelection(this.parent.getBitsInFacilityType());
        sBitsConfig2.adminState = eAdminState.from_int(this.stateBitsInCB.getSelectedIndex());
        sBitsConfig2.coding = this.getCodingFromSelection(this.codingBitsInCB.getSelectedIndex());
        sBitsConfig2.framing = this.getFramingFromSelection(this.framingBitsInCB.getSelectedIndex());
        sBitsConfig2.syncMessageIn = this.ssmEnabledBitsInCB.isSelected();
        sBitsConfig2.assumedQuality = this.pci.showAdminSSM() ? this.getQualitySelection((Attribute)this.adminSsmBitsInCB.getSelectedItem()) : eQualityLevel.STU_SDH;
        sBitsConfig2.saBit = this.parent.isBitsT1(0) ? eSaBit.SA_NONE : (!this.parent.isLineMode() ? eSaBit.from_int(this.sabitBitsInCB.getSelectedIndex()) : eSaBit.from_int(this.sabitBitsOutCB.getSelectedIndex()));
        sBitsConfig2.facilityTypeBitsOut = this.parent.getFacilityTypeSelection(this.parent.getBitsOutFacilityType());
        if (this.pci.isBitsOutStateProvisionable()) {
            sBitsConfig2.adminStateBitsOut = eAdminState.from_int(this.stateBitsOutCB.getSelectedIndex());
        }
        if (this.parent.isBitsT1(0)) {
            sBitsConfig2.codingBitsOut = this.getCodingFromSelection(this.codingBitsInCB.getSelectedIndex());
            sBitsConfig2.framingBitsOut = this.getFramingFromSelection(this.framingBitsInCB.getSelectedIndex());
        } else {
            sBitsConfig2.codingBitsOut = this.getCodingFromSelection(this.codingBitsOutCB.getSelectedIndex());
            sBitsConfig2.framingBitsOut = this.getFramingFromSelection(this.framingBitsOutCB.getSelectedIndex());
        }
        sBitsConfig2.aisThreshold = this.pci.isAISThresholdProvisionable() && !this.parent.isBitsT1(0) ? this.getQualitySelection((Attribute)this.qualityCB.getSelectedItem()) : eQualityLevel.STU_SDH;
        if (sBitsConfig2.framing.equals(eLineType.E1_CRC) || sBitsConfig2.framing.equals(eLineType.E1_CRCMF) || sBitsConfig2.framing.equals(eLineType.E2_FRAMED)) {
            sBitsConfig2.aisThreshold = eQualityLevel.DUS_SDH;
        }
        sBitsConfig2.cableSelection = this.parent.isBitsT1(0) ? eCableType.PAUSE_100_OHM : (this.cableTypeBitsOutCB != null ? this.getCableTypeSelection((Attribute)this.cableTypeBitsOutCB.getSelectedItem()) : eCableType.PAUSE_75_OHM);
        sBitsConfig2.bitsLBO = eBitsLBO.BITS_LBO_0_133_FEET;
        this.dumpData(sBitsConfig2);
        this.syncModel.setBitsConfig(this.bitsPort, sBitsConfig2);
        if (db.on()) {
            db.println("leave ASBPP applyChangesToModel");
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("enter ASBPP refreshFromModel (bitsPort=" + this.bitsPort.value() + ")");
        }
        sBitsConfig sBitsConfig2 = null;
        sBitsConfig2 = this.syncModel.getBitsConfig(this.bitsPort);
        this.dumpData(sBitsConfig2);
        this.stateBitsInCB.setSelectedIndex(sBitsConfig2.adminState.value());
        this.codingBitsInCB.setSelectedIndex(this.getCodingIndex(sBitsConfig2.coding));
        this.framingBitsInCB.setSelectedIndex(this.getFramingIndex(sBitsConfig2.framing));
        this.ssmEnabledBitsInCB.setSelected(sBitsConfig2.syncMessageIn);
        if (this.pci.showAdminSSM()) {
            this.adminSsmBitsInCB.setSelectedItem(this.getQualityAttribute(sBitsConfig2.assumedQuality.value()));
        }
        this.sabitBitsInCB.setSelectedIndex(sBitsConfig2.saBit.value());
        if (this.cableTypeBitsInCB != null) {
            if (this.parent.isBitsT1(0)) {
                this.cableTypeBitsInCB.setSelectedItem(this.getCableTypeAttribute(eCableType.PAUSE_100_OHM.value()));
            } else {
                this.cableTypeBitsInCB.removeItem(this.getCableTypeAttribute(eCableType.PAUSE_100_OHM.value()));
                this.cableTypeBitsInCB.setSelectedItem(this.getCableTypeAttribute(sBitsConfig2.cableSelection.value()));
            }
        }
        if (this.pci.isBitsOutStateProvisionable() && !this.parent.isBitsT1(0)) {
            this.stateBitsOutCB.setSelectedIndex(sBitsConfig2.adminStateBitsOut.value());
        } else {
            this.stateBitsOutCB.setSelectedIndex(1);
        }
        if (this.parent.isBitsT1(0)) {
            this.codingBitsOutCB.setSelectedItem("N/A");
            this.framingBitsOutCB.setSelectedItem("N/A");
            this.qualityCB.setSelectedItem("N/A");
        } else {
            this.qualityCB.removeItem("N/A");
            this.codingBitsOutCB.setSelectedIndex(this.getCodingIndex(sBitsConfig2.codingBitsOut));
            this.framingBitsOutCB.setSelectedIndex(this.getFramingIndex(sBitsConfig2.framingBitsOut));
            if (this.pci.isAISThresholdProvisionable()) {
                this.qualityCB.setSelectedItem(this.getQualityAttribute(sBitsConfig2.aisThreshold.value()));
            }
        }
        this.sabitBitsOutCB.setSelectedIndex(sBitsConfig2.saBit.value());
        if (this.cableTypeBitsInCB != null) {
            if (this.parent.isBitsT1(0)) {
                this.cableTypeBitsOutCB.setSelectedItem(this.getCableTypeAttribute(eCableType.PAUSE_100_OHM.value()));
            } else {
                this.cableTypeBitsOutCB.setSelectedItem(this.getCableTypeAttribute(sBitsConfig2.cableSelection.value()));
            }
        }
        this.enableBitsInComponents();
        this.enableBitsOutComponents();
        if (db.on()) {
            db.println("leave ASBPP refreshFromModel");
        }
    }

    @Override
    public void enableBitsInComponents() {
        super.enableBitsInComponents();
        if (this.parent.isLineMode() || this.parent.isBits64K(0) || this.parent.isBits2M(0) || this.parent.isBitsT1(0)) {
            this.sabitBitsInCB.setEnabled(false);
        } else if (this.isSyncMsgFraming(0)) {
            this.enableComponent(this.sabitBitsInCB);
        } else {
            this.sabitBitsInCB.setEnabled(false);
        }
        if (this.cableTypeBitsInCB != null && this.cableTypeBitsInCB.getSelectedIndex() == 0) {
            if (this.isSyncCableTypeSelection(0)) {
                this.enableComponent(this.cableTypeBitsInCB);
            } else {
                this.cableTypeBitsInCB.setEnabled(false);
            }
        }
        this.disableBitsInComponents();
    }

    protected void disableBitsInComponents() {
        if (this.parent.isLineMode()) {
            this.disableBitsInValues();
        }
    }

    protected void disableBitsInValues() {
        if (this.parent.isLineMode() && this.cableTypeBitsInCB != null) {
            this.cableTypeBitsInCB.setEnabled(false);
        }
    }

    protected void enableCableType() {
        if (this.parent.isLineMode() && this.cableTypeBitsOutCB != null) {
            this.cableTypeBitsOutCB.setEnabled(true);
        }
    }

    @Override
    public void enableBitsOutComponents() {
        super.enableBitsOutComponents();
        if (!this.parent.isLineMode() || this.parent.isBits64K(1) || this.parent.isBits2M(1)) {
            this.sabitBitsOutCB.setEnabled(false);
        } else if (this.isSyncMsgFraming(1)) {
            this.enableComponent(this.sabitBitsOutCB);
        } else {
            this.sabitBitsOutCB.setEnabled(false);
        }
        this.enableCableType();
    }

    @Override
    protected boolean isSyncMsgFraming(int n) {
        int n2 = 0;
        n2 = n == 0 ? this.framingBitsInCB.getSelectedIndex() : this.framingBitsOutCB.getSelectedIndex();
        return n2 >= 3 || n2 == framingChoices.length - 1;
    }

    @Override
    protected boolean isSyncCableTypeSelection(int n) {
        return this.parent.isBitsE1(n) || this.parent.isBits2M(n);
    }
}

