/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.SnmpV3SecurityLevel;
import cerent.cms.idl.Node.sSnmpV3Access;
import cerent.cms.model.InvalidData;
import cerent.cms.model.SnmpModel;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.snmp.AccessCreatePane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AccessCreateDialog
extends UDialog
implements ActionListener {
    protected JButton okButton;
    protected JButton cancelButton;
    protected AccessCreatePane aPane;
    protected SnmpModel snmpModel;
    protected boolean createFlag = true;
    private static final String TITLE_CREATE = "Create Group Access";
    private static final String TITLE_EDIT = "Edit Group Access";
    protected static final SDebug db = new SDebug("AccessCreateDialog");

    public static AccessCreateDialog instance(Pane pane, Object object) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        return new AccessCreateDialog(frame, TITLE_CREATE, object);
    }

    protected AccessCreateDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.snmpModel = (SnmpModel)object;
        this.aPane = new AccessCreatePane(this);
        jPanel.add((Component)this.aPane, "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.setSize(new Dimension(800, 800));
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel2.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel2.add(this.cancelButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected void setSelectedTrap(sSnmpV3Access sSnmpV3Access2) {
        this.setTitle(TITLE_EDIT);
        this.createFlag = false;
        AccessCreatePane accessCreatePane = this.aPane;
        accessCreatePane.setSelectedItem(sSnmpV3Access2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (db.on()) {
            db.fine("actionPerformed from " + object);
        }
        if (object == this.okButton) {
            try {
                if (this.apply()) {
                    this.ok();
                    this.dispose();
                }
            }
            catch (InvalidData invalidData) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_SNMP_VIEW_PARAM, (Object)invalidData.getMessage());
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    protected boolean apply() throws InvalidData {
        return this.validateFields();
    }

    private boolean validateFields() throws InvalidData {
        boolean bl = true;
        String string = this.getGroupName();
        int n = this.getSecurityLevel();
        if (string.equalsIgnoreCase("")) {
            bl = false;
            this.createFlag = true;
            throw new InvalidData("The Group name must be provided.");
        }
        sSnmpV3Access[] sSnmpV3AccessArray = this.snmpModel.getSnmpV3Access();
        for (int i = 0; i < sSnmpV3AccessArray.length; ++i) {
            if (!sSnmpV3AccessArray[i].groupName.equals(string) || sSnmpV3AccessArray[i].securityLevel.value() != n || !this.createFlag) continue;
            bl = false;
            this.createFlag = true;
            throw new InvalidData("Access control already exists for the group selected.");
        }
        return bl;
    }

    public void dispose() {
        super.dispose();
    }

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected void ok() {
        sSnmpV3Access sSnmpV3Access2 = new sSnmpV3Access();
        sSnmpV3Access2.groupName = this.getGroupName();
        sSnmpV3Access2.securityLevel = SnmpV3SecurityLevel.from_int(this.getSecurityLevel());
        sSnmpV3Access2.notifyView = this.aPane.getNotifyView();
        sSnmpV3Access2.readView = this.aPane.getReadView();
        sSnmpV3Access2.writeView = this.aPane.getWriteView();
        this.snmpModel.setSnmpV3Access(sSnmpV3Access2);
    }

    protected String getGroupName() {
        return this.aPane.getGroupName();
    }

    protected int getSecurityLevel() {
        return this.aPane.getSecurityLevel();
    }

    public SnmpModel getSnmpModel() {
        return this.snmpModel;
    }
}

