/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.sSnmpV3Access;
import cerent.cms.model.Attribute;
import cerent.cms.ui.shelf.snmp.AccessCreateDialog;
import cerent.util.gui.SnmpV3RowComboBox;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AccessCreatePane
extends JPanel {
    static final int MARGIN = 5;
    protected JComboBox snmpGroupCB;
    protected JComboBox securityLevelCB;
    protected JComboBox readViewCB;
    protected JCheckBox writeViewCB;
    protected JComboBox notifyViewCB;
    private String exceptionMessage = null;
    protected AccessCreateDialog aDialog;
    public Attribute[] securityLevel = new Attribute[]{new Attribute("noAuthNoPriv", 1), new Attribute("authNoPriv", 2), new Attribute("authPriv", 3)};

    public AccessCreatePane(AccessCreateDialog accessCreateDialog) {
        this.aDialog = accessCreateDialog;
        this.add((Component)this.createAttrsPanel(), "Center");
    }

    private JPanel createAttrsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel2.add(this.createLabel("Group Name:", 70, 20));
        this.snmpGroupCB = new SnmpV3RowComboBox(this.aDialog.getSnmpModel().getSnmpV3GroupList());
        jPanel2.add(this.snmpGroupCB);
        this.snmpGroupCB.setEditable(true);
        this.snmpGroupCB.setSelectedItem(null);
        Dimension dimension = this.snmpGroupCB.getPreferredSize();
        this.snmpGroupCB.setPreferredSize(new Dimension(250, dimension.height));
        jPanel.add(jPanel2);
        jPanel2.add(this.createLabel("Security Level:", 70, 20));
        this.securityLevelCB = new UComboBox((Object[])this.securityLevel, 50);
        jPanel2.add(this.securityLevelCB);
        this.securityLevelCB.setSelectedIndex(0);
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel3.add(this.createLabel("Read View Name:", 70, 20));
        this.readViewCB = new SnmpV3RowComboBox(this.aDialog.getSnmpModel().getSnmpV3ViewTreeList());
        jPanel3.add(this.readViewCB);
        this.readViewCB.setEditable(true);
        this.readViewCB.setSelectedItem(null);
        jPanel3.add(this.createLabel("Notify View Name:", 70, 20));
        this.notifyViewCB = new SnmpV3RowComboBox(this.aDialog.getSnmpModel().getSnmpV3ViewTreeList());
        jPanel3.add(this.notifyViewCB);
        this.notifyViewCB.setEditable(true);
        this.notifyViewCB.setSelectedItem(null);
        jPanel3.add(new JLabel("Allow SNMP Sets:"));
        this.writeViewCB = new JCheckBox();
        jPanel3.add(this.writeViewCB);
        jPanel3.setBorder(BorderFactory.createTitledBorder("Views:"));
        jPanel.add(jPanel3);
        return jPanel;
    }

    public void setSelectedItem(sSnmpV3Access sSnmpV3Access2) {
        this.snmpGroupCB.setSelectedItem(sSnmpV3Access2.groupName);
        this.snmpGroupCB.setEnabled(false);
        this.securityLevelCB.setSelectedItem(this.getSecurityLevel(sSnmpV3Access2.securityLevel.value()));
        this.securityLevelCB.setEnabled(false);
        this.readViewCB.setSelectedItem(sSnmpV3Access2.readView);
        String string = sSnmpV3Access2.writeView;
        if (string.equalsIgnoreCase("def_v3setview")) {
            this.writeViewCB.setSelected(true);
        } else {
            this.writeViewCB.setSelected(false);
        }
        this.notifyViewCB.setSelectedItem(sSnmpV3Access2.notifyView);
    }

    protected Attribute getSecurityLevel(int n) {
        switch (n) {
            case 1: {
                return new Attribute("noAuthNoPriv", 1);
            }
            case 2: {
                return new Attribute("authNoPriv", 2);
            }
            case 3: {
                return new Attribute("authPriv", 3);
            }
        }
        return new Attribute("", -1);
    }

    public String getGroupName() {
        if (null != this.snmpGroupCB.getSelectedItem()) {
            return (String)this.snmpGroupCB.getSelectedItem();
        }
        return "";
    }

    public int getSecurityLevel() {
        return ((Attribute)this.securityLevelCB.getSelectedItem()).getValue();
    }

    public String getReadView() {
        return this.readViewCB.getSelectedItem() == null ? "" : this.readViewCB.getSelectedItem();
    }

    public String getWriteView() {
        return this.writeViewCB.isSelected() ? "def_v3setview" : "";
    }

    public String getNotifyView() {
        return this.notifyViewCB.getSelectedItem() == null ? "" : this.notifyViewCB.getSelectedItem();
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }
}

