/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.sSnmpOID;
import cerent.cms.idl.Node.sSnmpV3NotifyFilter;
import cerent.cms.model.InvalidData;
import cerent.cms.model.SnmpModel;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.snmp.NotifyFilterCreatePane;
import cerent.cms.ui.shelf.snmp.SnmpV3Util;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class NotifyFilterCreateDialog
extends UDialog
implements ActionListener {
    protected JButton okButton;
    protected JButton cancelButton;
    protected SnmpModel snmpModel;
    protected JPanel panel;
    private static final String TITLE_CREATE = "Create Notify";
    private static final String TITLE_EDIT = "Edit Notify";
    protected boolean createFlag = true;
    protected static final SDebug db = new SDebug("NotifyFilterCreatePane");

    public static NotifyFilterCreateDialog instance(Pane pane, Object object) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        return new NotifyFilterCreateDialog(frame, TITLE_CREATE, object);
    }

    protected NotifyFilterCreateDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.snmpModel = (SnmpModel)object;
        this.panel = new NotifyFilterCreatePane();
        jPanel.add((Component)this.panel, "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.setSize(new Dimension(600, 600));
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel2.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel2.add(this.cancelButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (db.on()) {
            db.fine("actionPerformed from " + object);
        }
        if (object == this.okButton) {
            try {
                if (this.apply()) {
                    this.ok();
                    this.dispose();
                }
            }
            catch (InvalidData invalidData) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_CREATING_VIEW, (Object)invalidData.getMessage());
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_CREATING_VIEW);
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    protected boolean apply() throws Exception, InvalidData {
        return this.validateFields();
    }

    private boolean validateFields() throws Exception, InvalidData {
        boolean bl = true;
        String string = this.getProfileName();
        sSnmpOID sSnmpOID2 = this.getOID();
        if (string.equalsIgnoreCase("")) {
            bl = false;
            this.createFlag = true;
            throw new InvalidData("The Profile name must be provided.");
        }
        if (sSnmpOID2.oidlen <= 1) {
            bl = false;
            this.createFlag = true;
            throw new InvalidData("Minimum Sub Tree OID length is two.");
        }
        sSnmpV3NotifyFilter[] sSnmpV3NotifyFilterArray = this.snmpModel.getSnmpV3NotifyFilter();
        for (int i = 0; i < sSnmpV3NotifyFilterArray.length; ++i) {
            if (!sSnmpV3NotifyFilterArray[i].profileName.equals(string) || !SnmpV3Util.compareOID(sSnmpV3NotifyFilterArray[i].filterSubtree, sSnmpOID2) || !this.createFlag) continue;
            bl = false;
            this.createFlag = true;
            throw new InvalidData("The View already exists.");
        }
        return bl;
    }

    public void dispose() {
        super.dispose();
    }

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected void ok() throws Exception, InvalidData {
        sSnmpV3NotifyFilter sSnmpV3NotifyFilter2 = new sSnmpV3NotifyFilter();
        sSnmpV3NotifyFilter2.profileName = this.getProfileName();
        sSnmpV3NotifyFilter2.filterSubtree = this.getOID();
        sSnmpV3NotifyFilter2.mask = this.getMask();
        sSnmpV3NotifyFilter2.filterType = SnmpV3Util.getFilterTypeObj(((NotifyFilterCreatePane)this.panel).getFilterType());
        this.snmpModel.setSnmpV3NotifyFilter(sSnmpV3NotifyFilter2);
    }

    public String getMask() {
        return ((NotifyFilterCreatePane)this.panel).getMask();
    }

    public String getProfileName() {
        return ((NotifyFilterCreatePane)this.panel).getProfileName();
    }

    public sSnmpOID getOID() throws Exception {
        sSnmpOID sSnmpOID2 = new sSnmpOID();
        String string = ((NotifyFilterCreatePane)this.panel).getTreeOID();
        int[] nArray = new int[32];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.indexOf(46, n2);
            try {
                nArray[n] = Integer.parseInt(string.substring(n2, n3));
            }
            catch (Exception exception) {
                sSnmpOID2.oidlen = 0;
                return sSnmpOID2;
            }
            n2 += n3 - n2;
            ++n2;
            ++n;
        }
        sSnmpOID2.oidarray = nArray;
        sSnmpOID2.oidlen = n;
        return sSnmpOID2;
    }

    public static JPanel createVerticalPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jPanel;
    }

    protected void setSelectedTrap(sSnmpV3NotifyFilter sSnmpV3NotifyFilter2) {
        this.setTitle(TITLE_EDIT);
        this.createFlag = false;
        NotifyFilterCreatePane notifyFilterCreatePane = (NotifyFilterCreatePane)this.panel;
        notifyFilterCreatePane.setSelectedItem(sSnmpV3NotifyFilter2);
    }
}

