/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.model.Attribute;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.InvalidData;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.SnmpV3TrapDestination;
import cerent.cms.ui.shelf.snmp.SnmpV3TargetCreateDialog;
import cerent.cms.ui.shelf.snmp.SnmpV3Util;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.DigitTextField;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SnmpV3RowComboBox;
import cerent.util.gui.SnmpV3RowTextField;
import cerent.util.gui.SnmpV3TagField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SnmpV3TargetCreatePane
extends JPanel
implements ActionListener {
    static final int MARGIN = 5;
    static final String validUserNameChars = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTURVWXYZ0123456789";
    protected FixedLengthField ipAddrTF;
    protected DigitTextField udpPortTF;
    protected JComboBox securityLavelCB;
    protected JComboBox securityNameCB;
    protected JTextField profileNameTF;
    protected JCheckBox profileCKB;
    protected SnmpV3TagField tagNameTF;
    protected JCheckBox tagCB;
    protected SnmpV3TargetCreateDialog targetDialog;
    private String exceptionMessage = null;
    Attribute[] mpmModel = new Attribute[]{new Attribute("V3", 3), new Attribute("V2", 2), new Attribute("V1", 1)};
    protected Attribute[] securityLevel = new Attribute[]{new Attribute("noAuthNoPriv", 1), new Attribute("authNoPriv", 2), new Attribute("authPriv", 3)};
    private static final SDebug db = new SDebug("SnmpV3TargetCreatePane");

    public SnmpV3TargetCreatePane(SnmpV3TargetCreateDialog snmpV3TargetCreateDialog) {
        this.targetDialog = snmpV3TargetCreateDialog;
        this.add((Component)this.createAttrsPanel(), "Center");
    }

    private JPanel createAttrsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel2.add(this.createLabel("Target Address:", 70, 20));
        this.ipAddrTF = new FixedLengthField(40);
        jPanel2.add(this.ipAddrTF);
        jPanel2.add(this.createLabel("UDP Port:", 70, 20));
        this.udpPortTF = new DigitTextField(20);
        jPanel2.add(this.udpPortTF);
        this.udpPortTF.setText("162");
        jPanel2.add(this.createLabel("User Name:", 70, 20));
        this.securityNameCB = new SnmpV3RowComboBox(this.targetDialog.getSnmpModel().getSnmpV3UserList());
        jPanel2.add(this.securityNameCB);
        this.securityNameCB.setSelectedItem(null);
        this.securityNameCB.setEditable(true);
        jPanel2.add(this.createLabel("Security Level:", 70, 20));
        this.securityLavelCB = new JComboBox<Attribute>(this.securityLevel);
        jPanel2.add(this.securityLavelCB);
        this.securityLavelCB.setSelectedIndex(0);
        this.profileCKB = new JCheckBox("Filter Profile:", true);
        this.profileCKB.addActionListener(this);
        this.profileCKB.setSelected(false);
        jPanel2.add(this.profileCKB);
        this.profileNameTF = new SnmpV3RowTextField(20);
        jPanel2.add(this.profileNameTF);
        this.profileNameTF.setEnabled(false);
        jPanel2.add(new JLabel("Proxy Traps Only:"));
        this.tagCB = new JCheckBox();
        this.tagCB.addActionListener(this);
        this.tagCB.setSelected(false);
        jPanel2.add(this.tagCB);
        jPanel2.add(this.createLabel("Proxy Tags:", 70, 20));
        this.tagNameTF = new SnmpV3TagField(20);
        jPanel2.add(this.tagNameTF);
        this.tagNameTF.setMaxLength(52);
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void setSelectedItem(SnmpV3TrapDestination snmpV3TrapDestination) {
        IIpAddr iIpAddr = IpAddrFactory.getIIpAddr(snmpV3TrapDestination.targetAddress);
        this.ipAddrTF.setText(InetUtil.makeDottedString(iIpAddr));
        this.ipAddrTF.setEnabled(false);
        int n = snmpV3TrapDestination.udpPort & 0xFFFF;
        this.udpPortTF.setText(Integer.toString(n));
        this.securityNameCB.setSelectedItem(snmpV3TrapDestination.userName);
        this.securityNameCB.setEnabled(false);
        this.securityLavelCB.setSelectedItem(new Attribute(SnmpV3Util.getSecurityLevel(snmpV3TrapDestination.securityLevel.value()), snmpV3TrapDestination.securityLevel.value()));
        this.securityLavelCB.setEnabled(false);
        String string = snmpV3TrapDestination.filterProfile;
        if (!string.equalsIgnoreCase("") && string.length() >= 1) {
            this.profileCKB.setSelected(true);
            this.profileNameTF.setText(string);
            this.profileNameTF.setEnabled(true);
        }
        this.tagNameTF.setText(snmpV3TrapDestination.proxyTags);
        if (snmpV3TrapDestination.proxyTrapsOnly.booleanValue()) {
            this.tagCB.setSelected(true);
        } else {
            this.tagCB.setSelected(false);
        }
    }

    protected String getMPMModel(int n) {
        switch (n) {
            case 1: {
                return "V1";
            }
            case 2: {
                return "V2";
            }
            case 3: {
                return "V3";
            }
        }
        return "??";
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }

    public String getSecurityName() throws InvalidData {
        Object object = this.securityNameCB.getSelectedItem();
        boolean bl = true;
        if (object == null) {
            bl = false;
        }
        String string = (String)object;
        if (bl) {
            if (0 == string.compareTo("")) {
                bl = false;
            }
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (-1 != validUserNameChars.indexOf(c)) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            return string;
        }
        throw new InvalidData("Specify a valid user name.");
    }

    public String getTargetAddress() throws InvalidData {
        return IpAddrFactory.ipToString(IpAddrFactory.getIIpAddr(this.getIpAddress()));
    }

    public sIpAddr getIpAddress() throws InvalidData {
        try {
            sIpAddr sIpAddr2 = null;
            if (this.ipAddrTF != null) {
                String string = this.ipAddrTF.getText();
                if (!string.equals("")) {
                    sIpAddr2 = IpAddrFactory.getIpAddr(InetUtil.makeIpAddr(this.ipAddrTF.getText()));
                } else {
                    throw new InvalidData("Target address must be provided.");
                }
            }
            return sIpAddr2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidData("The IP address contains invalid characters.");
        }
    }

    public int getUDPPort() {
        return Integer.parseInt(this.udpPortTF.getText());
    }

    public String getFilterProfile() {
        if (this.profileCKB.isSelected()) {
            return this.profileNameTF.getText().trim();
        }
        return "";
    }

    public String getTagList() {
        String string = this.tagNameTF.getText();
        string = string.trim();
        return string;
    }

    public boolean isProxyTrapsOnly() {
        return this.tagCB.isSelected();
    }

    public int getSecurityLevel() {
        return ((Attribute)this.securityLavelCB.getSelectedItem()).getValue();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.profileCKB) {
            if (this.profileCKB.isSelected()) {
                this.profileNameTF.setEnabled(true);
            } else {
                this.profileNameTF.setEnabled(false);
                this.profileNameTF.setText("");
            }
        }
    }
}

