/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.SnmpV3ViewTreeFamilyType;
import cerent.cms.idl.Node.sSnmpOID;
import cerent.cms.idl.Node.sSnmpV3ViewTreeFamily;
import cerent.cms.model.InvalidData;
import cerent.cms.model.SnmpModel;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.snmp.SnmpV3Util;
import cerent.cms.ui.shelf.snmp.ViewTreeCreatePane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ViewTreeCreateDialog
extends UDialog
implements ActionListener {
    protected JButton okButton;
    protected JButton cancelButton;
    protected ViewTreeCreatePane panel;
    protected SnmpModel snmpModel;
    protected boolean createFlag = true;
    private static final String ADD_TITLE = "Create Views";
    private static final String EDIT_TITLE = "Edit Views";
    protected static final SDebug db = new SDebug("ViewTreeCreateDialog");

    public static ViewTreeCreateDialog instance(Pane pane, Object object) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        return new ViewTreeCreateDialog(frame, ADD_TITLE, object);
    }

    protected ViewTreeCreateDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.snmpModel = (SnmpModel)object;
        this.panel = new ViewTreeCreatePane();
        jPanel.add((Component)this.panel, "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.setSize(new Dimension(600, 600));
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel2.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel2.add(this.cancelButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        db.fine("actionPerformed from " + object);
        if (object == this.okButton) {
            try {
                if (this.apply()) {
                    this.ok();
                    this.dispose();
                }
            }
            catch (InvalidData invalidData) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_CREATING_VIEW, (Object)invalidData.getMessage());
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_CREATING_VIEW);
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    protected boolean apply() throws Exception, InvalidData {
        return this.validateFields();
    }

    private boolean validateFields() throws Exception, InvalidData {
        boolean bl = true;
        String string = this.getViewName();
        sSnmpOID sSnmpOID2 = this.getOID();
        if (string.equalsIgnoreCase("")) {
            bl = false;
            this.createFlag = true;
            throw new InvalidData("The View name must be provided.");
        }
        if (sSnmpOID2.oidlen <= 0) {
            bl = false;
            this.createFlag = true;
            throw new InvalidData("The Tree OID must be provided.");
        }
        sSnmpV3ViewTreeFamily[] sSnmpV3ViewTreeFamilyArray = this.snmpModel.getSnmpV3ViewTreeFamily();
        for (int i = 0; i < sSnmpV3ViewTreeFamilyArray.length; ++i) {
            if (!sSnmpV3ViewTreeFamilyArray[i].viewName.equals(string) || !SnmpV3Util.compareOID(sSnmpV3ViewTreeFamilyArray[i].subtree, sSnmpOID2) || !this.createFlag) continue;
            bl = false;
            this.createFlag = true;
            throw new InvalidData("The View already exists.");
        }
        if (this.getMask().length() > sSnmpOID2.oidlen) {
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_SNMPV3_MASK_PARAM, (Object)sSnmpOID2.oidlen);
            bl = false;
        }
        return bl;
    }

    public void dispose() {
        super.dispose();
    }

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected void ok() throws Exception {
        sSnmpV3ViewTreeFamily sSnmpV3ViewTreeFamily2 = new sSnmpV3ViewTreeFamily();
        sSnmpV3ViewTreeFamily2.viewName = this.getViewName();
        sSnmpV3ViewTreeFamily2.mask = this.getMask();
        sSnmpV3ViewTreeFamily2.subtree = this.getOID();
        sSnmpV3ViewTreeFamily2.type = this.getViewTreeFamilyType();
        this.snmpModel.setSnmpV3ViewTreeFamily(sSnmpV3ViewTreeFamily2);
    }

    public String getViewName() {
        return this.panel.getViewName();
    }

    public String getMask() {
        return this.panel.getMask();
    }

    public sSnmpOID getOID() throws Exception {
        sSnmpOID sSnmpOID2 = new sSnmpOID();
        String string = this.panel.getOID();
        int[] nArray = new int[32];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.indexOf(46, n2);
            try {
                nArray[n] = Integer.parseInt(string.substring(n2, n3));
            }
            catch (Exception exception) {
                sSnmpOID2.oidlen = 0;
                return sSnmpOID2;
            }
            n2 += n3 - n2;
            ++n2;
            ++n;
        }
        sSnmpOID2.oidarray = nArray;
        sSnmpOID2.oidlen = n;
        return sSnmpOID2;
    }

    public SnmpV3ViewTreeFamilyType getViewTreeFamilyType() {
        switch (this.panel.getViewTreeFamilyType()) {
            case 2: {
                return SnmpV3ViewTreeFamilyType.SnmpV3ViewTreeFamilyType_excluded;
            }
            case 1: {
                return SnmpV3ViewTreeFamilyType.SnmpV3ViewTreeFamilyType_included;
            }
            case 0: {
                return SnmpV3ViewTreeFamilyType.SnmpV3ViewTreeFamilyType_undefined;
            }
        }
        return null;
    }

    public static JPanel createVerticalPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jPanel;
    }

    protected void setSelectedTrap(sSnmpV3ViewTreeFamily sSnmpV3ViewTreeFamily2) {
        this.setTitle(EDIT_TITLE);
        this.createFlag = false;
        ViewTreeCreatePane viewTreeCreatePane = this.panel;
        viewTreeCreatePane.setSelectedItem(sSnmpV3ViewTreeFamily2);
    }
}

