/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.sSnmpOID;
import cerent.cms.idl.Node.sSnmpV3ViewTreeFamily;
import cerent.cms.model.ConfigError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SnmpModel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.snmp.SnmpV3Util;
import cerent.cms.ui.shelf.snmp.ViewTreeCreateDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;

public class ViewTreePane
extends AbstractShelfEditTablePane {
    public static final int VIEW_NAME_IDX = 0;
    public static final int SUB_TREE_OID_IDX = 1;
    public static final int MASK_IDX = 2;
    public static final int TYPE_IDX = 3;
    SnmpModel nodeModel = this.getSnmpModel();

    public ViewTreePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    @Override
    protected void localInit() {
        super.localInit();
        ListSelectionModel listSelectionModel = this.getTable().getSelectionModel();
        listSelectionModel.setSelectionMode(2);
    }

    @Override
    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new ViewNameColumnRenderer(), new SubTreeOIDColumnRenderer(), new MaskColumnRenderer(), new TypeColumnRenderer()};
        UserTableRowSource userTableRowSource = new UserTableRowSource();
        this.model = new SortableRowTableModel((RowDataSource)userTableRowSource, columnRendererArray);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        super.actionPerformed(actionEvent);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (this.getTable().getSelectedRowCount() > 1) {
            WindowHelper.setEnabled((JComponent)this.editButton, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateTableData() {
        List list = this.tableData;
        synchronized (list) {
            this.tableData = new ArrayList();
            try {
                sSnmpV3ViewTreeFamily[] sSnmpV3ViewTreeFamilyArray = this.nodeModel.getSnmpV3ViewTreeFamily();
                for (int i = 0; i < sSnmpV3ViewTreeFamilyArray.length; ++i) {
                    this.tableData.add(sSnmpV3ViewTreeFamilyArray[i]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                db.println("Error in getting GRE Table: " + exception);
            }
        }
    }

    public SnmpModel getSnmpModel() {
        return (SnmpModel)this.getUiModel().getNodeModel().getSnmpModel();
    }

    @Override
    public void destroy() {
        if (this.table != null) {
            this.table.removeMouseListener(this);
        }
        super.destroy();
    }

    @Override
    protected void createTableEntry() {
        ViewTreeCreateDialog viewTreeCreateDialog = ViewTreeCreateDialog.instance(this, this.getSnmpModel());
        viewTreeCreateDialog.show();
        viewTreeCreateDialog.dispose();
    }

    @Override
    protected void editSelectedTableEntry(int n) {
        sSnmpV3ViewTreeFamily sSnmpV3ViewTreeFamily2 = (sSnmpV3ViewTreeFamily)this.model.getValueAt(n, 0);
        ViewTreeCreateDialog viewTreeCreateDialog = ViewTreeCreateDialog.instance(this, this.getSnmpModel());
        if (sSnmpV3ViewTreeFamily2 != null) {
            viewTreeCreateDialog.setSelectedTrap(sSnmpV3ViewTreeFamily2);
        }
        viewTreeCreateDialog.show();
        viewTreeCreateDialog.dispose();
    }

    @Override
    protected void deleteSelectedTableEntry(int n) {
        int n2;
        int[] nArray = this.getTable().getSelectedRows();
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Do you really want to delete the selected View Tree" + (nArray.length > 1 ? "s?" : "?")), (String)"Delete View Tree")) {
            return;
        }
        this.setEditDeleteEnabled(false);
        sSnmpV3ViewTreeFamily[] sSnmpV3ViewTreeFamilyArray = new sSnmpV3ViewTreeFamily[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] >= 0 && nArray[n2] < this.model.getRowCount()) {
                sSnmpV3ViewTreeFamilyArray[n2] = (sSnmpV3ViewTreeFamily)this.model.getValueAt(nArray[n2], 0);
                continue;
            }
            db.severe("Selected entry does not exist, index: " + nArray[n2]);
            sSnmpV3ViewTreeFamilyArray[n2] = null;
        }
        for (n2 = 0; n2 < sSnmpV3ViewTreeFamilyArray.length; ++n2) {
            if (sSnmpV3ViewTreeFamilyArray[n2] == null) continue;
            try {
                this.getSnmpModel().deleteSnmpV3ViewTreeFamily(sSnmpV3ViewTreeFamilyArray[n2].viewName, sSnmpV3ViewTreeFamilyArray[n2].subtree);
                continue;
            }
            catch (ConfigError configError) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_SNMP_VIEW, "");
                continue;
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_SNMP_MAX_DESTINATIONS);
            }
        }
    }

    @Override
    protected void registerWithModels() {
        if (this.nodeModel != null) {
            this.getObservableManager().addObservable((Observable)((Object)this.nodeModel));
        }
    }

    @Override
    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.ViewConfigurationPane;
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        BaseColumnRenderer() {
        }

        public int getWidth() {
            return 160;
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        protected String getStringValue(sSnmpV3ViewTreeFamily sSnmpV3ViewTreeFamily2, int n) {
            String string = "???";
            switch (n) {
                case 0: {
                    string = sSnmpV3ViewTreeFamily2.viewName;
                    break;
                }
                case 1: {
                    string = this.getOID(sSnmpV3ViewTreeFamily2.subtree);
                    break;
                }
                case 2: {
                    string = this.getMask(sSnmpV3ViewTreeFamily2.subtree, sSnmpV3ViewTreeFamily2.mask);
                    break;
                }
                case 3: {
                    string = SnmpV3Util.getViewTreeType(sSnmpV3ViewTreeFamily2.type.value());
                }
            }
            return " " + string;
        }

        public String getMask(sSnmpOID sSnmpOID2, String string) {
            return string.substring(0, sSnmpOID2.oidlen);
        }

        public String getOID(sSnmpOID sSnmpOID2) {
            int n;
            String string = "";
            for (n = 0; n < sSnmpOID2.oidlen - 1; ++n) {
                string = string + sSnmpOID2.oidarray[n] + ".";
            }
            string = string + sSnmpOID2.oidarray[n];
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            sSnmpV3ViewTreeFamily sSnmpV3ViewTreeFamily2 = (sSnmpV3ViewTreeFamily)jTable.getValueAt(n, 0);
            String string = this.getStringValue(sSnmpV3ViewTreeFamily2, n2);
            JLabel jLabel = new JLabel(string);
            jLabel.setOpaque(true);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(jTable.getForeground());
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((sSnmpV3ViewTreeFamily)object, n);
            String string2 = this.getStringValue((sSnmpV3ViewTreeFamily)object2, n);
            return string.compareTo(string2);
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            ViewTreePane.this.resetObservableManager();
            ViewTreePane.this.registerWithModels();
            ViewTreePane.this.setObservableManagerActive();
            this.initedOM = true;
            if (db.on()) {
                db.println("initObservabledManager() done");
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            if (!this.initedOM) {
                this.initObservableManager();
            } else if (db.on()) {
                db.println("did not call initObservableManager()");
            }
            ViewTreePane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)ViewTreePane.this), true);
            }
            return this.dscObservableManager;
        }
    }

    class MaskColumnRenderer
    extends BaseColumnRenderer {
        MaskColumnRenderer() {
        }

        public String getName() {
            return "Mask";
        }
    }

    class SubTreeOIDColumnRenderer
    extends BaseColumnRenderer {
        SubTreeOIDColumnRenderer() {
        }

        public String getName() {
            return "Sub Tree OID";
        }
    }

    class TypeColumnRenderer
    extends BaseColumnRenderer {
        TypeColumnRenderer() {
        }

        public String getName() {
            return "Type";
        }
    }

    class UserTableRowSource
    extends AbstractRowDataSource {
        UserTableRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = ViewTreePane.this.tableData;
            synchronized (list) {
                var2_2 = ViewTreePane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = ViewTreePane.this.tableData;
            synchronized (list) {
                n = ViewTreePane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            List list = ViewTreePane.this.tableData;
            synchronized (list) {
                return ViewTreePane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return sSnmpV3ViewTreeFamily.class;
        }
    }

    class ViewNameColumnRenderer
    extends BaseColumnRenderer {
        ViewNameColumnRenderer() {
        }

        public String getName() {
            return "View Name";
        }
    }
}

