/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.sStsInfo;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.SonetMedia.sPathThresholds;
import cerent.cms.idl.SonetMedia.sPathThresholds600;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.LinePathHolder;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractValidatingTableModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.MuxIndex;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Set;

public abstract class CxcHoPathPmThresholdsTableModel
extends AbstractValidatingTableModel
implements ResettablePmThresholdsTableModel {
    private Frame _frame;
    protected TDMTerminology terms;
    protected TdmHoModel[] model = null;
    protected boolean[] rowDirty;
    protected sPathThresholds600[] statsVal;
    protected sInterface[] info = null;
    protected eIntervalType intervalType;
    protected int numLines;
    protected boolean nearEnd = false;
    protected EntityCellRenderer myPortRenderer;
    private int protocolType;
    private int framingTypeToDisplay;
    public String[] columnNames;
    private InterfaceModel[] lineModels;
    private ArrayList switchedLinePathList;
    private Object[] combinedModels;
    private static final SDebug db = new SDebug("CxcHoPathPmThresholdsTableModel");

    public CxcHoPathPmThresholdsTableModel(INodeModel iNodeModel, InterfaceModel[] interfaceModelArray, TdmHoModel[] tdmHoModelArray, eIntervalType eIntervalType2, boolean bl, int n) {
        super((NodeModelDelegate)iNodeModel, new SDebug("CxcHoPathPmThresholdsTableModel"));
        this._frame = iNodeModel.getUiToolkit().getApplicationFrame();
        this.protocolType = iNodeModel.getTdmProtocolType();
        this.terms = iNodeModel.getTDMTerminology();
        this.model = tdmHoModelArray;
        this.nearEnd = bl;
        this.intervalType = eIntervalType2;
        this.framingTypeToDisplay = n;
        this.initColumnNames();
        this.lineModels = interfaceModelArray;
        this.getBlsrProtLinesList();
        if (this.model == null) {
            if (db.on()) {
                db.println("Model null");
            }
            this.numLines = 0;
            return;
        }
        this.numLines = this.model.length + this.switchedLinePathList.size();
        this.combinedModels = new Object[this.numLines];
        System.arraycopy(this.model, 0, this.combinedModels, 0, this.model.length);
        int n2 = 0;
        for (int i = this.model.length; i < this.numLines; ++i) {
            this.combinedModels[i] = this.switchedLinePathList.get(n2++);
        }
        this.init();
    }

    protected void getBlsrProtLinesList() {
        this.switchedLinePathList = new ArrayList();
        ElementModelsDelegate elementModelsDelegate = this.node.getElementModelsDelegate();
        Set set = elementModelsDelegate.getBlsrElements();
        BlsrModel[] blsrModelArray = set.toArray(new BlsrModel[set.size()]);
        for (int i = 0; i < blsrModelArray.length; ++i) {
            LinePathHolder linePathHolder;
            int n;
            IPathInfo[] iPathInfoArray;
            int n2;
            TdmLineModel tdmLineModel;
            IEntityModel iEntityModel;
            try {
                iEntityModel = blsrModelArray[i].getEastProtectEntityModel();
                if (iEntityModel != null && iEntityModel instanceof TdmPortModel) {
                    tdmLineModel = ((TdmPortModel)iEntityModel).getTdmLineModel();
                    for (n2 = 0; n2 < this.lineModels.length; ++n2) {
                        if (tdmLineModel != this.lineModels[n2]) continue;
                        if (db.on()) {
                            db.println("This linemodel matches a BLSR's east protect: " + this.lineModels[n2]);
                        }
                        iPathInfoArray = blsrModelArray[i].getEastProtectHoPaths();
                        for (n = 0; n < iPathInfoArray.length; ++n) {
                            linePathHolder = new LinePathHolder(tdmLineModel, iPathInfoArray[n]);
                            this.switchedLinePathList.add(linePathHolder);
                        }
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
            try {
                iEntityModel = blsrModelArray[i].getWestProtectEntityModel();
                if (iEntityModel == null || !(iEntityModel instanceof TdmPortModel)) continue;
                tdmLineModel = ((TdmPortModel)iEntityModel).getTdmLineModel();
                for (n2 = 0; n2 < this.lineModels.length; ++n2) {
                    if (tdmLineModel != this.lineModels[n2]) continue;
                    if (db.on()) {
                        db.println("This linemodel matches a BLSR's west protect: " + this.lineModels[n2]);
                    }
                    iPathInfoArray = blsrModelArray[i].getWestProtectHoPaths();
                    for (n = 0; n < iPathInfoArray.length; ++n) {
                        linePathHolder = new LinePathHolder(tdmLineModel, iPathInfoArray[n]);
                        this.switchedLinePathList.add(linePathHolder);
                    }
                }
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
        }
    }

    protected String getLineNumber(int n) throws NoSuchInterface, AbstractCmsNoSuchEntityException {
        StringBuffer stringBuffer = new StringBuffer();
        this.getInfo(n);
        if (this.info[n] != null && this.combinedModels[n] instanceof TdmHoModel) {
            MuxIndex muxIndex = new MuxIndex(this.model[n], this.info[n].muxIndex + 1);
            stringBuffer.append("Port ");
            if (this.info[n].portNumber == 0) {
                stringBuffer.append("all");
            } else {
                stringBuffer.append(this.getPortDescriptionFor(n));
            }
            stringBuffer.append(", " + this.terms.getTdmHoTerm(this.framingTypeToDisplay) + " ");
            stringBuffer.append(muxIndex);
        } else if (this.combinedModels[n] instanceof LinePathHolder) {
            LinePathHolder linePathHolder = (LinePathHolder)this.combinedModels[n];
            stringBuffer.append("Port ");
            stringBuffer.append(this.getPortDescriptionFor(n));
            stringBuffer.append(", " + this.terms.getTdmHoTerm(this.framingTypeToDisplay) + " ");
            stringBuffer.append(linePathHolder.getHoNum());
            stringBuffer.append(" (switched)");
        }
        return stringBuffer.toString();
    }

    @Override
    public void markRowDirty(int n) {
        this.rowDirty[n] = true;
    }

    @Override
    public int getNumberOfLines() {
        return this.model.length;
    }

    protected sInterface getInfo(int n) throws NoSuchInterface {
        if (this.info[n] == null && this.combinedModels[n] instanceof TdmHoModel) {
            this.info[n] = ((TdmHoModel)this.combinedModels[n]).getInfo();
        }
        return this.info[n];
    }

    private void init() {
        this.myPortRenderer = new EntityCellRenderer();
        this.rowDirty = new boolean[this.numLines];
        this.statsVal = new sPathThresholds600[this.numLines];
        this.info = new sInterface[this.numLines];
    }

    protected void refreshPmStats(int n) {
        if (this.statsVal[n] == null) {
            if (this.combinedModels[n] instanceof TdmHoModel) {
                try {
                    this.statsVal[n] = new sPathThresholds600();
                    this.model[n].getStsPathThresholds(this.nearEnd, this.intervalType, this.statsVal[n]);
                    if (db.on()) {
                        db.println("Stats val got for line " + n);
                    }
                    this.printStats(this.statsVal[n]);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            } else if (this.combinedModels[n] instanceof LinePathHolder) {
                LinePathHolder linePathHolder = (LinePathHolder)this.combinedModels[n];
                try {
                    TdmLineModel tdmLineModel = linePathHolder.getLineModel();
                    IPortModel iPortModel = tdmLineModel.getPortModel();
                    sStsInfo sStsInfo2 = new sStsInfo();
                    sStsInfo2.index = iPortModel.getIndex();
                    sStsInfo2.sts = linePathHolder.getHoNum();
                    sPathThresholds sPathThresholds2 = tdmLineModel.getBlsrProtectStsTermPmThresholds(sStsInfo2, this.nearEnd, this.intervalType);
                    this.statsVal[n] = new sPathThresholds600();
                    this.statsVal[n].es = sPathThresholds2.es;
                    this.statsVal[n].ses = sPathThresholds2.ses;
                    this.statsVal[n].cv = sPathThresholds2.cv;
                    this.statsVal[n].uas = sPathThresholds2.uas;
                    this.statsVal[n].fc = sPathThresholds2.fc;
                    this.statsVal[n].pjpIn = sPathThresholds2.pjpIn;
                    this.statsVal[n].pjpOut = sPathThresholds2.pjpOut;
                    this.statsVal[n].pjnIn = sPathThresholds2.pjnIn;
                    this.statsVal[n].pjnOut = sPathThresholds2.pjnOut;
                    this.statsVal[n].bbe = sPathThresholds2.bbe;
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            } else {
                db.println("refreshPmStats class error?, the combinedModel[] at " + n + " is " + this.combinedModels[n]);
            }
        }
    }

    @Override
    protected Frame getFrame() {
        return this._frame;
    }

    public Class getColumnClass(int n) {
        if (n != 0) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public sPathThresholds600 getStatsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.statsVal[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.model.length > 0) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 0 && this.shouldLineBeEditable(n);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
        }
        return false;
    }

    private boolean shouldLineBeEditable(int n) {
        boolean bl = true;
        try {
            IPortModel iPortModel = null;
            if (this.combinedModels[n] instanceof TdmHoModel) {
                iPortModel = ((TdmHoModel)this.combinedModels[n]).getPortModel();
            } else if (this.combinedModels[n] instanceof LinePathHolder) {
                return false;
            }
            InterfaceModel interfaceModel = (InterfaceModel)iPortModel.getInterfaceModel();
            bl = interfaceModel instanceof TdmLineModel ? !((TdmLineModel)interfaceModel).isProtectLine() : true;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.println("AbstractCmsNoSuchEntityException caught: " + (Object)((Object)abstractCmsNoSuchEntityException));
            db.println("Thresholds will NOT be editable.");
            bl = false;
        }
        catch (Exception exception) {
            db.println("Unexpected Exception caught: " + exception);
            db.println("Thresholds will NOT be editable.");
            SDebug.printStackTrace((Throwable)exception);
            bl = false;
        }
        return bl;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = null;
        if (this.combinedModels[n] instanceof TdmHoModel) {
            iPortModel = ((TdmHoModel)this.combinedModels[n]).getPortModel();
        } else if (this.combinedModels[n] instanceof LinePathHolder) {
            LinePathHolder linePathHolder = (LinePathHolder)this.combinedModels[n];
            iPortModel = linePathHolder.getLineModel().getPortModel();
        }
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    @Override
    public Object getThresholdNeDefault(NeDefaultsModel neDefaultsModel, int n) throws Exception {
        HoPathDefModel hoPathDefModel;
        eEqType eEqType2 = this.model[n].getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.model[n].getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        short s = 1;
        if (this.combinedModels[n] instanceof TdmHoModel && (hoPathDefModel = ((TdmHoModel)this.combinedModels[n]).getHoPathDefModel()) != null) {
            s = hoPathDefModel.getPathWidth();
        }
        return neDefaultsModel.getDefPathThrCmn(eEqType2, eEqType3, s, this.nearEnd, this.intervalType);
    }

    @Override
    public void setThresholdValue(int n, Object object) {
        if (object instanceof sPathThresholds) {
            sPathThresholds sPathThresholds2 = (sPathThresholds)object;
            this.statsVal[n] = new sPathThresholds600();
            this.statsVal[n].es = sPathThresholds2.es;
            this.statsVal[n].ses = sPathThresholds2.ses;
            this.statsVal[n].cv = sPathThresholds2.cv;
            this.statsVal[n].uas = sPathThresholds2.uas;
            this.statsVal[n].fc = sPathThresholds2.fc;
            this.statsVal[n].pjpIn = sPathThresholds2.pjpIn;
            this.statsVal[n].pjpOut = sPathThresholds2.pjpOut;
            this.statsVal[n].pjnIn = sPathThresholds2.pjnIn;
            this.statsVal[n].pjnOut = sPathThresholds2.pjnOut;
        }
    }

    @Override
    public boolean resetToDefaultByLine() {
        return false;
    }

    public void refreshLineFromModel(int n) {
        this.statsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStsModel(TdmHoModel[] tdmHoModelArray) {
        CxcHoPathPmThresholdsTableModel cxcHoPathPmThresholdsTableModel = this;
        synchronized (cxcHoPathPmThresholdsTableModel) {
            int n;
            this.model = tdmHoModelArray;
            this.getBlsrProtLinesList();
            this.numLines = this.model.length + this.switchedLinePathList.size();
            this.combinedModels = new Object[this.numLines];
            System.arraycopy(this.model, 0, this.combinedModels, 0, this.model.length);
            int n2 = 0;
            for (n = this.model.length; n < this.numLines; ++n) {
                this.combinedModels[n] = this.switchedLinePathList.get(n2++);
            }
            this.statsVal = new sPathThresholds600[this.numLines];
            this.rowDirty = new boolean[this.numLines];
            this.info = new sInterface[this.numLines];
            for (n = 0; n < this.numLines; ++n) {
                this.statsVal[n] = null;
                this.rowDirty[n] = false;
            }
        }
        this.fireTableDataChanged();
    }

    public void refreshFromModel() {
        int n;
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (n = 0; n < this.numLines; ++n) {
            this.statsVal[n] = null;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.rowDirty[n] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }

    protected void printStats(sPathThresholds600 sPathThresholds6002) {
        if (db.on()) {
            db.println("Near End = " + this.nearEnd + " Interval Type = " + EnumStrings.getString((Object)this.intervalType, (int)this.intervalType.value()));
            db.println("===============================================");
            db.println("CV " + sPathThresholds6002.cv);
            db.println("ES " + sPathThresholds6002.es);
            db.println("FC " + sPathThresholds6002.fc);
            db.println("SES " + sPathThresholds6002.ses);
            db.println("UAS " + sPathThresholds6002.uas);
            db.println("PPJC-Pdet " + sPathThresholds6002.pjpIn);
            db.println("NPJC-Pdet " + sPathThresholds6002.pjnIn);
            db.println("PPJC-Pgen" + sPathThresholds6002.pjpOut);
            db.println("NPJC-Pgen" + sPathThresholds6002.pjnOut);
            db.println("===============================================");
        }
    }

    protected abstract void initColumnNames();
}

