/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.model.MfgEntityModel;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class TdmInfoMaintTableModel
extends AbstractTableModel {
    private final MfgEntityModel _module;
    private String[] _keys;
    private String[] _vals;
    private static final String[] _columnNames = new String[]{"Attribute", "Value", "Units"};
    private static final TreeMap _names = new TreeMap();
    private static final TreeMap _units;

    public TdmInfoMaintTableModel(MfgEntityModel mfgEntityModel) {
        this._module = mfgEntityModel;
        this.fetchValues();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this._keys.length;
    }

    @Override
    public int getColumnCount() {
        return _columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return _columnNames[n];
    }

    private String getKey(int n) {
        String string = (String)_names.get(this._keys[n]);
        if (string == null) {
            string = this._keys[n];
        }
        return string;
    }

    private String getUnits(int n) {
        return (String)_units.get(this._keys[n]);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.getKey(n);
            }
            case 1: {
                return this._vals[n];
            }
            case 2: {
                return this.getUnits(n);
            }
        }
        return null;
    }

    private void fetchValues() {
        TreeMap treeMap = new TreeMap();
        treeMap.putAll(this._module.getExtraInfoMap());
        this._keys = new String[treeMap.size()];
        this._vals = new String[treeMap.size()];
        Iterator iterator = treeMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this._keys[n] = (String)iterator.next();
            this._vals[n] = (String)treeMap.get(this._keys[n]);
            ++n;
        }
    }

    public void refreshFromModel() {
        int n = this.getRowCount();
        this.fetchValues();
        int n2 = this.getRowCount();
        if (n < n2) {
            this.fireTableRowsInserted(n, n2 - 1);
        } else if (n > n2) {
            this.fireTableRowsDeleted(n2, n - 1);
        }
        this.fireTableRowsUpdated(0, this._keys.length - 1);
    }

    public void removeKey(String string) {
        int n;
        String[] stringArray = this._keys;
        String[] stringArray2 = this._vals;
        int n2 = this._keys.length;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals(string)) continue;
            stringArray[n] = null;
            stringArray2[n] = null;
            --n2;
        }
        this._keys = new String[n2];
        this._vals = new String[n2];
        for (n = 0; n < n2; ++n) {
            if (stringArray[n] == null) continue;
            this._keys[n] = stringArray[n];
            this._vals[n] = stringArray2[n];
        }
    }

    static {
        _names.put("WL", "Lambda");
        _names.put("DSRm", "DSRmax");
        _names.put("RPm", "RPWRmin");
        _names.put("TP", "TPWRmax/min");
        _names.put("Amp", "Amplification");
        _names.put("Vb", "Rx Bias Voltage");
        _units = new TreeMap();
        _units.put("WL", "nm");
        _units.put("DSRm", "ps/nm");
        _units.put("RPm", "dBm");
        _units.put("TP", "dBm");
        _units.put("Amp", "dB");
        _units.put("Vb", "Volts");
    }
}

