/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.TdmPhysicalAlarmThresholdsPane;
import cerent.cms.ui.sonet.TdmThresholdProvPane;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TdmPhysicalAlarmThresholdProvPane
extends TdmThresholdProvPane {
    protected static final String PHYS_TCA_15MIN_PANEL = "PHYS_TCA_15MIN";
    protected static final String PHYS_TCA_1DAY_PANEL = "PHYS_TCA_1DAY";
    protected static final String PHYS_ALARM_PANEL = "PHYS_ALARM";
    protected static final int PHYS_TCA_15MIN = 1;
    protected static final int PHYS_TCA_1DAY = 2;
    protected static final int PHYS_ALARM = 3;
    protected static final SDebug db = new SDebug("TdmPhysicalAlarmThresholdProvPane");

    public TdmPhysicalAlarmThresholdProvPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray) {
        super(string, tabbedView, tdmLineModelArray);
    }

    @Override
    protected TdmThresholdProvPane.TdmThresholdButtonPanel getButtonPanel() {
        if (null == this.buttonPanel) {
            this.buttonPanel = new TdmPhysicalAlarmThresholdButtonPanel();
        }
        return this.buttonPanel;
    }

    @Override
    protected JPanel getTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.setPreferredSize(new Dimension(800, 300));
        this.currentPane = this.getSonetPhysicalPmThresholdsPane(PHYS_TCA_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true);
        this.tablePanel.add((Component)((Object)this.currentPane));
        this.tableLabelString = " Near End, 15 Min, Physical TCA";
        this.tableLabel.setText(this.tableLabelString);
        jPanel.add((Component)this.tableLabel, "North");
        jPanel.add((Component)this.tablePanel, "Center");
        return jPanel;
    }

    protected AbstractPane getSonetPhysicalAlarmThresholdsPane(String string) {
        return new TdmPhysicalAlarmThresholdsPane(string, this.getParentView(), this.models);
    }

    protected void resetSonetPhysicalAlarmThresholdsToDefault(String string) {
        block2: {
            TdmPhysicalAlarmThresholdsPane tdmPhysicalAlarmThresholdsPane = (TdmPhysicalAlarmThresholdsPane)this.getSonetPhysicalAlarmThresholdsPane(string);
            try {
                tdmPhysicalAlarmThresholdsPane.refreshFromNeDefaults();
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("Error applying changes");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected class TdmPhysicalAlarmThresholdButtonPanel
    extends TdmThresholdProvPane.TdmThresholdButtonPanel {
        public JRadioButton buttonPhysTca;
        public JRadioButton buttonPhysAlarm;
        public ButtonGroup typeButtonGroup;

        public TdmPhysicalAlarmThresholdButtonPanel() {
            super(TdmPhysicalAlarmThresholdProvPane.this);
        }

        @Override
        protected void initButtonListeners() {
            this.buttonPhysTca.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((JRadioButton)itemEvent.getSource()).isSelected()) {
                        TdmPhysicalAlarmThresholdButtonPanel.this.button15Min.setEnabled(true);
                        TdmPhysicalAlarmThresholdButtonPanel.this.button1Day.setEnabled(true);
                        TdmPhysicalAlarmThresholdButtonPanel.this.buttonPhysTca.setEnabled(true);
                    }
                }
            });
            this.buttonPhysAlarm.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((JRadioButton)itemEvent.getSource()).isSelected()) {
                        TdmPhysicalAlarmThresholdButtonPanel.this.button15Min.setEnabled(false);
                        TdmPhysicalAlarmThresholdButtonPanel.this.button1Day.setEnabled(false);
                        TdmPhysicalAlarmThresholdButtonPanel.this.buttonPhysAlarm.setEnabled(true);
                    }
                }
            });
        }

        @Override
        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.buttonPhysTca = new JRadioButton("TCA", true);
            this.buttonPhysAlarm = new JRadioButton("Alarm");
            this.buttonPhysAlarm.setEnabled(this.getEntityModel().supportsPhysicalAlarm());
            this.typeButtonGroup = new ButtonGroup();
            this.typeButtonGroup.add(this.buttonPhysTca);
            this.typeButtonGroup.add(this.buttonPhysAlarm);
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.showButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdmPhysicalAlarmThresholdButtonPanel.this.refreshAction();
                }
            });
            this.resetToDefaultButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdmPhysicalAlarmThresholdButtonPanel.this.resetToDefaultAction();
                }
            });
            this.resetToDefaultButton.setEnabled(AbstractPane.isUserAuthorized(this.getEntityModel(), SecurityLevel.PROVISIONING));
            this.initButtonListeners();
            Dimension dimension = new Dimension(80, 70);
            JPanel jPanel = new JPanel(new GridLayout(2, 0, 0, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(" Types "));
            jPanel.setPreferredSize(dimension);
            jPanel.add(this.buttonPhysTca);
            jPanel.add(this.buttonPhysAlarm);
            JPanel jPanel2 = new JPanel(new GridLayout(2, 0, 0, 0));
            jPanel2.setBorder(BorderFactory.createTitledBorder(" Intervals "));
            jPanel2.setPreferredSize(dimension);
            jPanel2.add(this.button15Min);
            jPanel2.add(this.button1Day);
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(this.showButton);
            this.add(this.resetToDefaultButton);
            this.setPreferredSize(new Dimension(800, 75));
        }

        @Override
        public void refreshAction() {
            TdmPhysicalAlarmThresholdProvPane.this.tableLabelString = " Near End";
            int n = 0;
            if (this.typeButtonGroup.getSelection() == this.buttonPhysTca.getModel()) {
                if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                    if (db.on()) {
                        db.println("TCA - 1 Day");
                    }
                    n = 2;
                    TdmPhysicalAlarmThresholdProvPane.this.tableLabelString = TdmPhysicalAlarmThresholdProvPane.this.tableLabelString + ", 1 Day";
                } else {
                    if (db.on()) {
                        db.println("TCA - 15 Min");
                    }
                    n = 1;
                    TdmPhysicalAlarmThresholdProvPane.this.tableLabelString = TdmPhysicalAlarmThresholdProvPane.this.tableLabelString + ", 15 Min";
                }
                TdmPhysicalAlarmThresholdProvPane.this.tableLabelString = TdmPhysicalAlarmThresholdProvPane.this.tableLabelString + ", Physical TCA";
            } else if (this.typeButtonGroup.getSelection() == this.buttonPhysAlarm.getModel()) {
                if (db.on()) {
                    db.println("Alarm pressed");
                }
                n = 3;
                TdmPhysicalAlarmThresholdProvPane.this.tableLabelString = " Physical Alarm";
            }
            switch (n) {
                case 1: {
                    if (db.on()) {
                        db.println("PHYS 15-MIN");
                    }
                    TdmPhysicalAlarmThresholdProvPane.this.showPanel(TdmPhysicalAlarmThresholdProvPane.this.getSonetPhysicalPmThresholdsPane(TdmPhysicalAlarmThresholdProvPane.PHYS_TCA_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true));
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("PHYS 1-DAY");
                    }
                    TdmPhysicalAlarmThresholdProvPane.this.showPanel(TdmPhysicalAlarmThresholdProvPane.this.getSonetPhysicalPmThresholdsPane(TdmPhysicalAlarmThresholdProvPane.PHYS_TCA_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true));
                    break;
                }
                case 3: {
                    if (db.on()) {
                        db.println("PHYS ALARM");
                    }
                    TdmPhysicalAlarmThresholdProvPane.this.showPanel(TdmPhysicalAlarmThresholdProvPane.this.getSonetPhysicalAlarmThresholdsPane(TdmPhysicalAlarmThresholdProvPane.PHYS_ALARM_PANEL));
                    break;
                }
            }
            TdmPhysicalAlarmThresholdProvPane.this.tableLabel.setText(TdmPhysicalAlarmThresholdProvPane.this.tableLabelString);
        }

        @Override
        public void resetWithDefaultPmThresholds() {
            TdmPhysicalAlarmThresholdProvPane.this.tableLabelString = " Near End";
            int n = 0;
            if (this.typeButtonGroup.getSelection() == this.buttonPhysTca.getModel()) {
                if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                    if (db.on()) {
                        db.println("TCA - 1 Day");
                    }
                    n = 2;
                    TdmPhysicalAlarmThresholdProvPane.this.tableLabelString = TdmPhysicalAlarmThresholdProvPane.this.tableLabelString + ", 1 Day";
                } else {
                    if (db.on()) {
                        db.println("TCA - 15 Min");
                    }
                    n = 1;
                    TdmPhysicalAlarmThresholdProvPane.this.tableLabelString = TdmPhysicalAlarmThresholdProvPane.this.tableLabelString + ", 15 Min";
                }
                TdmPhysicalAlarmThresholdProvPane.this.tableLabelString = TdmPhysicalAlarmThresholdProvPane.this.tableLabelString + ", Physical TCA";
            } else if (this.typeButtonGroup.getSelection() == this.buttonPhysAlarm.getModel()) {
                if (db.on()) {
                    db.println("Alarm pressed");
                }
                n = 3;
                TdmPhysicalAlarmThresholdProvPane.this.tableLabelString = " Physical Alarm";
            }
            switch (n) {
                case 1: {
                    if (db.on()) {
                        db.println("PHYS 15-MIN");
                    }
                    TdmPhysicalAlarmThresholdProvPane.this.resetSonetPhysicalPmThresholdsToDefault(TdmPhysicalAlarmThresholdProvPane.PHYS_TCA_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true);
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("PHYS 1-DAY");
                    }
                    TdmPhysicalAlarmThresholdProvPane.this.resetSonetPhysicalPmThresholdsToDefault(TdmPhysicalAlarmThresholdProvPane.PHYS_TCA_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true);
                    break;
                }
                case 3: {
                    if (db.on()) {
                        db.println("PHYS ALARM");
                    }
                    TdmPhysicalAlarmThresholdProvPane.this.resetSonetPhysicalAlarmThresholdsToDefault(TdmPhysicalAlarmThresholdProvPane.PHYS_ALARM_PANEL);
                    break;
                }
            }
            TdmPhysicalAlarmThresholdProvPane.this.tableLabel.setText(TdmPhysicalAlarmThresholdProvPane.this.tableLabelString);
        }
    }
}

