/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.PmPane;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.TdmPmTableModel;
import cerent.util.SDebug;
import java.util.ArrayList;

public class TdmPmPane
extends PmPane {
    protected TdmLineModel[] lineModels;
    protected static final SDebug db = new SDebug("TdmPmPane");

    public TdmPmPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray) {
        super(string, tabbedView);
        this.lineModels = tdmLineModelArray;
        this.init();
        this.registerWithModel();
    }

    @Override
    protected PmTableModel createDataModel() {
        TdmPmTableModel tdmPmTableModel = new TdmPmTableModel(this.lineModels, (NodeModelDelegate)this.getUiModel().getNodeModel());
        tdmPmTableModel.addTableModelListener(this);
        return tdmPmTableModel;
    }

    @Override
    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            this.lineModels = (TdmLineModel[])((OcnLineUpdate)object).getModels();
            ((PmTableModel)this.model).refreshMyLines(this.lineModels);
            this.setupControlBar(0, 0);
        } else if (object instanceof DwdmLineUpdate) {
            DwdmModuleModel dwdmModuleModel;
            this.lineModels = ((DwdmLineUpdate)object).getTdmLineModels();
            if (this.getParentView().getUiModel() instanceof DwdmModuleModel && (dwdmModuleModel = (DwdmModuleModel)this.getParentView().getUiModel()).isPolluceCard()) {
                TdmPortModel[] tdmPortModelArray = dwdmModuleModel.getWisPorts();
                ArrayList<TdmLineModel> arrayList = new ArrayList<TdmLineModel>();
                for (TdmPortModel tdmPortModel : tdmPortModelArray) {
                    arrayList.add(tdmPortModel.getTdmLineModel());
                }
                Model[] modelArray = new TdmLineModel[arrayList.size() + this.lineModels.length];
                System.arraycopy(this.lineModels, 0, modelArray, 0, this.lineModels.length);
                System.arraycopy(arrayList.toArray(new TdmLineModel[0]), 0, modelArray, this.lineModels.length, arrayList.size());
                this.lineModels = modelArray;
            }
            ((PmTableModel)this.model).refreshMyLines(this.lineModels);
            this.setupControlBar(0, 0);
        }
    }

    @Override
    protected String getAllPortsClearStatsTitle() {
        return this.helpGetAllPortsClearStatsTitle(this.lineModels, "All statistics for all optical ports on card");
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.TdmPmPane;
    }
}

