/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.ElementModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractValidatingTableModel;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

public abstract class TdmTableModel
extends AbstractValidatingTableModel {
    protected INodeModel node;
    private TDMTerminology _terms;
    protected Boolean isEc1 = null;
    protected Boolean isDwdm = null;
    protected TdmLineModel[] model = null;
    protected int numLines = 0;
    private static final SDebug db = new SDebug("TdmTableModel");

    public TdmTableModel(INodeModel iNodeModel) {
        this(iNodeModel, iNodeModel.getTDMTerminology());
    }

    public TdmTableModel(INodeModel iNodeModel, TDMTerminology tDMTerminology) {
        super((NodeModelDelegate)iNodeModel, db);
        this.node = iNodeModel;
        this._terms = tDMTerminology;
    }

    protected TDMTerminology getTerms() {
        return this._terms;
    }

    protected int getTdmProtocolType() {
        return this.node.getTdmProtocolType();
    }

    protected ITdmProtocolType getTdmProtocolTypeObj() {
        return this.node.getTdmProtocolTypeObj();
    }

    public int getNumberOfLines() {
        return this.model.length;
    }

    public boolean resetToDefaultByLine() {
        try {
            ModuleModel moduleModel;
            if (this.model.length > 0 && ((moduleModel = this.model[0].getModuleModel()).getEqType() == 301 || moduleModel.getEqType() == 356)) {
                return true;
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return false;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        block9: {
            if (this.model != null && this.numLines > 0) {
                boolean bl = AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.MAINTENANCE);
                if (this.isEc1(n)) {
                    try {
                        if (bl && !this.model[0].getModuleModel().isProtectModule()) {
                            return n2 > 0;
                        }
                        break block9;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        return false;
                    }
                }
                if (this.isDwdm(n)) {
                    if (bl && !this.isDwdmProtect(n)) {
                        return n2 > 0;
                    }
                } else if (bl) {
                    return n2 > 0 && !this.model[n].isProtectLine();
                }
            }
        }
        return false;
    }

    protected boolean isEc1(int n) {
        IPortModel iPortModel = null;
        if (this.isEc1 == null) {
            try {
                iPortModel = this.model[n].getPortModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                iPortModel = null;
            }
            this.isEc1 = iPortModel != null ? new Boolean(iPortModel.getEqType() == 31) : new Boolean(false);
        }
        return this.isEc1;
    }

    protected boolean isDwdm(int n) {
        if (this.isDwdm == null) {
            try {
                ModuleModel moduleModel = this.model[n].getModuleModel();
                this.isDwdm = new Boolean(moduleModel instanceof DwdmModuleModel);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.isDwdm = new Boolean(false);
            }
        }
        return this.isDwdm;
    }

    protected boolean isDwdmProtect(int n) {
        boolean bl = false;
        if (this.isDwdm(n)) {
            InterfaceModel interfaceModel = this.model[n];
            InterfaceModel[] interfaceModelArray = interfaceModel.getLowerLayerModels();
            while (interfaceModelArray.length != 0) {
                interfaceModel = interfaceModelArray[0];
                interfaceModelArray = interfaceModel.getLowerLayerModels();
            }
            try {
                ElementModel elementModel = interfaceModel.getElementModel();
                if (elementModel != null) {
                    bl = elementModel.getProtectEntityIndex() == interfaceModel.getIndex();
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                bl = false;
            }
        }
        return bl;
    }
}

