/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.IPlatform;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.sonet.CxcHoPathPmThresholdsPane;
import cerent.cms.ui.sonet.CxcTdmLinePmThresholdsPane;
import cerent.cms.ui.sonet.CxcTdmSectionPmThresholdsPane;
import cerent.cms.ui.sonet.HoPathPmThresholdsPane;
import cerent.cms.ui.sonet.LoPathPmThresholdsPane;
import cerent.cms.ui.sonet.SonetFEPmThresholdsPane;
import cerent.cms.ui.sonet.TdmLinePmThresholdsPane;
import cerent.cms.ui.sonet.TdmPhysicalPmThresholdsPane;
import cerent.cms.ui.sonet.TdmSectionPmThresholdsPane;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class TdmThresholdProvPane
extends AbstractPane {
    protected TdmLineModel[] models;
    protected TdmThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected AbstractPane currentPane = null;
    protected static final String FE_SEC_1DAY_PANEL = "FE_SEC_1DAY";
    protected static final String FE_SEC_15MIN_PANEL = "FE_SEC_15MIN";
    protected static final String NE_SEC_1DAY_PANEL = "NE_SEC_1DAY";
    protected static final String NE_SEC_15MIN_PANEL = "NE_SEC_15MIN";
    protected static final String FE_LIN_1DAY_PANEL = "FE_LIN_1DAY";
    protected static final String FE_LIN_15MIN_PANEL = "FE_LIN_15MIN";
    protected static final String NE_LIN_1DAY_PANEL = "NE_LIN_1DAY";
    protected static final String NE_LIN_15MIN_PANEL = "NE_LIN_15MIN";
    protected static final String FE_PATH_1DAY_PANEL = "FE_PATH_1DAY";
    protected static final String FE_PATH_15MIN_PANEL = "FE_PATH_15MIN";
    protected static final String NE_PATH_1DAY_PANEL = "NE_PATH_1DAY";
    protected static final String NE_PATH_15MIN_PANEL = "NE_PATH_15MIN";
    protected static final String FE_VT_1DAY_PANEL = "FE_VT_1DAY";
    protected static final String FE_VT_15MIN_PANEL = "FE_VT_15MIN";
    protected static final String NE_VT_1DAY_PANEL = "NE_VT_1DAY";
    protected static final String NE_VT_15MIN_PANEL = "NE_VT_15MIN";
    protected static final int VT = 16;
    protected static final int PATH = 8;
    protected static final int FE = 4;
    protected static final int SEC = 2;
    protected static final int ONE_DAY = 1;
    protected static final int FE_VT_1DAY = 21;
    protected static final int FE_VT_15MIN = 20;
    protected static final int NE_VT_1DAY = 17;
    protected static final int NE_VT_15MIN = 16;
    protected static final int FE_PATH_1DAY = 13;
    protected static final int FE_PATH_15MIN = 12;
    protected static final int NE_PATH_1DAY = 9;
    protected static final int NE_PATH_15MIN = 8;
    protected static final int FE_SEC_1DAY = 7;
    protected static final int FE_SEC_15MIN = 6;
    protected static final int NE_SEC_1DAY = 3;
    protected static final int NE_SEC_15MIN = 2;
    protected static final int FE_LIN_1DAY = 5;
    protected static final int FE_LIN_15MIN = 4;
    protected static final int NE_LIN_1DAY = 1;
    protected static final int NE_LIN_15MIN = 0;
    protected JLabel tableLabel = new JLabel();
    protected String tableLabelString = new String();
    private ITdmProtocolType pType = null;
    private boolean is600 = false;
    protected IPlatform pci;
    private TDMTerminology terms;
    protected static final SDebug db = new SDebug("TdmThresholdProvPane");

    public TdmThresholdProvPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray) {
        super(string, tabbedView);
        this.models = tdmLineModelArray;
        this.pci = ((NodeModelDelegate)this.uiModel.getNodeModel()).getPlatform();
        this.pType = this.uiModel.getNodeModel().getTdmProtocolTypeObj();
        this.terms = this.getUiModel().getNodeModel().getTDMTerminology();
        this.is600 = ((NodeModelDelegate)this.uiModel.getNodeModel()).getPlatform().is600();
        this.initializeLayout();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
        this.registerWithModel();
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "South");
        this.add(this.getTablePanel(), "Center");
    }

    protected TdmThresholdButtonPanel getButtonPanel() {
        if (null == this.buttonPanel) {
            this.buttonPanel = new TdmThresholdButtonPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.setPreferredSize(new Dimension(800, 300));
        this.currentPane = this.getSonetLinePmThresholdsPane(NE_LIN_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true);
        this.tablePanel.add((Component)((Object)this.currentPane));
        this.tableLabelString = " Near End, 15 Min, " + this.terms.getGeneralTerms(2);
        this.tableLabel.setText(this.tableLabelString);
        jPanel.add((Component)this.tableLabel, "North");
        jPanel.add((Component)this.tablePanel, "Center");
        return jPanel;
    }

    protected AbstractPane getSonetLinePmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        if (this.is15600()) {
            return new CxcTdmLinePmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
        }
        return new TdmLinePmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
    }

    protected AbstractPane resetSonetLinePmThresholdsToDefault(String string, eIntervalType eIntervalType2, boolean bl) {
        TdmLinePmThresholdsPane tdmLinePmThresholdsPane;
        block6: {
            if (this.is15600()) {
                CxcTdmLinePmThresholdsPane cxcTdmLinePmThresholdsPane;
                block5: {
                    cxcTdmLinePmThresholdsPane = (CxcTdmLinePmThresholdsPane)this.getSonetLinePmThresholdsPane(string, eIntervalType2, bl);
                    try {
                        cxcTdmLinePmThresholdsPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block5;
                        db.println("Error applying changes");
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                return cxcTdmLinePmThresholdsPane;
            }
            tdmLinePmThresholdsPane = (TdmLinePmThresholdsPane)this.getSonetLinePmThresholdsPane(string, eIntervalType2, bl);
            try {
                tdmLinePmThresholdsPane.refreshFromNeDefaults();
            }
            catch (Exception exception) {
                if (!db.on()) break block6;
                db.println("Error applying changes");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return tdmLinePmThresholdsPane;
    }

    protected boolean is15600() {
        return this.is600;
    }

    protected AbstractPane getSonetSectionPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        if (this.is15600()) {
            return new CxcTdmSectionPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
        }
        return new TdmSectionPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
    }

    protected AbstractPane resetSonetSectionPmThresholdsToDefault(String string, eIntervalType eIntervalType2, boolean bl) {
        TdmSectionPmThresholdsPane tdmSectionPmThresholdsPane;
        block6: {
            if (this.is15600()) {
                CxcTdmSectionPmThresholdsPane cxcTdmSectionPmThresholdsPane;
                block5: {
                    cxcTdmSectionPmThresholdsPane = (CxcTdmSectionPmThresholdsPane)this.getSonetSectionPmThresholdsPane(string, eIntervalType2, bl);
                    try {
                        cxcTdmSectionPmThresholdsPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block5;
                        db.println("Error applying changes");
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                return cxcTdmSectionPmThresholdsPane;
            }
            tdmSectionPmThresholdsPane = (TdmSectionPmThresholdsPane)this.getSonetSectionPmThresholdsPane(string, eIntervalType2, bl);
            try {
                tdmSectionPmThresholdsPane.refreshFromNeDefaults();
            }
            catch (Exception exception) {
                if (!db.on()) break block6;
                db.println("Error applying changes");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return tdmSectionPmThresholdsPane;
    }

    protected AbstractPane getSonetPathPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl, int n) {
        if (this.is15600()) {
            return new CxcHoPathPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl, 1, n);
        }
        return new HoPathPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl, 1);
    }

    protected AbstractPane resetSonetPathPmThresholdsToDefault(String string, eIntervalType eIntervalType2, boolean bl, int n) {
        HoPathPmThresholdsPane hoPathPmThresholdsPane;
        block6: {
            if (this.is15600()) {
                CxcHoPathPmThresholdsPane cxcHoPathPmThresholdsPane;
                block5: {
                    cxcHoPathPmThresholdsPane = (CxcHoPathPmThresholdsPane)this.getSonetPathPmThresholdsPane(string, eIntervalType2, bl, n);
                    try {
                        cxcHoPathPmThresholdsPane.refreshFromNeDefaults();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block5;
                        db.println("Error applying changes");
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                return cxcHoPathPmThresholdsPane;
            }
            hoPathPmThresholdsPane = (HoPathPmThresholdsPane)this.getSonetPathPmThresholdsPane(string, eIntervalType2, bl, n);
            try {
                hoPathPmThresholdsPane.refreshFromNeDefaults();
            }
            catch (Exception exception) {
                if (!db.on()) break block6;
                db.println("Error applying changes");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return hoPathPmThresholdsPane;
    }

    protected AbstractPane getSonetPhysicalPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new TdmPhysicalPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
    }

    protected AbstractPane resetSonetPhysicalPmThresholdsToDefault(String string, eIntervalType eIntervalType2, boolean bl) {
        TdmPhysicalPmThresholdsPane tdmPhysicalPmThresholdsPane;
        block2: {
            tdmPhysicalPmThresholdsPane = (TdmPhysicalPmThresholdsPane)this.getSonetPhysicalPmThresholdsPane(string, eIntervalType2, bl);
            try {
                tdmPhysicalPmThresholdsPane.refreshFromNeDefaults();
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("Error applying changes");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return tdmPhysicalPmThresholdsPane;
    }

    protected LoPathPmThresholdsPane getLoPathPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new LoPathPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl, 2);
    }

    protected AbstractPane resetLoPathPmThresholdsToDefault(String string, eIntervalType eIntervalType2, boolean bl) {
        LoPathPmThresholdsPane loPathPmThresholdsPane;
        block2: {
            loPathPmThresholdsPane = this.getLoPathPmThresholdsPane(string, eIntervalType2, bl);
            try {
                loPathPmThresholdsPane.refreshFromNeDefaults();
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("Error applying changes");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return loPathPmThresholdsPane;
    }

    protected AbstractPane getSonetFELinePmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        if (this.is15600()) {
            return new CxcTdmLinePmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
        }
        return new SonetFEPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
    }

    protected void showPanel(AbstractPane abstractPane) {
        block4: {
            try {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
                this.currentPane.leavingPage();
                this.currentPane.destroy();
                this.tablePanel.remove((Component)((Object)this.currentPane));
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            abstractPane.enteringPage();
            TablePropertyMgr.getColumnPrefs(abstractPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + abstractPane.getName());
        }
        catch (Exception exception) {
            db.finer("Exception in showPanel() " + exception);
        }
        this.currentPane = abstractPane;
        this.tablePanel.add((Component)((Object)this.currentPane));
        this.validate();
    }

    @Override
    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    @Override
    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            this.models = (TdmLineModel[])((OcnLineUpdate)object).getModels();
        } else if (object instanceof DwdmLineUpdate) {
            DwdmModuleModel dwdmModuleModel;
            this.models = ((DwdmLineUpdate)object).getTdmLineModels();
            if (this.uiModel instanceof DwdmModuleModel && (dwdmModuleModel = (DwdmModuleModel)this.uiModel).isPolluceCard()) {
                TdmLineModel[] tdmLineModelArray = ((DwdmLineUpdate)object).getWisLineModels();
                TdmLineModel[] tdmLineModelArray2 = new TdmLineModel[tdmLineModelArray.length + this.models.length];
                System.arraycopy(this.models, 0, tdmLineModelArray2, 0, this.models.length);
                System.arraycopy(tdmLineModelArray, 0, tdmLineModelArray2, this.models.length, tdmLineModelArray.length);
                this.models = tdmLineModelArray2;
            }
        }
    }

    @Override
    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    @Override
    public void dispose() {
        this.currentPane.destroy();
        this.buttonPanel = null;
        super.dispose();
    }

    protected class TdmThresholdButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonNE;
        public JRadioButton buttonFE;
        public JRadioButton buttonSection;
        public JRadioButton buttonLine;
        public JRadioButton buttonPath;
        public JRadioButton buttonSecondaryPath;
        public JRadioButton buttonVt;
        public JButton showButton = new JButton("Refresh");
        public JButton resetToDefaultButton = new JButton("Reset to Default");
        public ButtonGroup periodButtonGroup;
        public ButtonGroup endButtonGroup;
        public ButtonGroup secLineButtonGroup;

        public TdmThresholdButtonPanel() {
            this.initialize();
        }

        protected void initButtonListeners() {
            this.buttonNE.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((JRadioButton)itemEvent.getSource()).isSelected()) {
                        TdmThresholdButtonPanel.this.buttonSection.setEnabled(true);
                        TdmThresholdButtonPanel.this.buttonLine.setEnabled(true);
                        TdmThresholdButtonPanel.this.buttonPath.setEnabled(true);
                        if (TdmThresholdButtonPanel.this.buttonSecondaryPath != null) {
                            TdmThresholdButtonPanel.this.buttonSecondaryPath.setEnabled(TdmThresholdButtonPanel.this.supportsSdhAu3());
                        }
                        TdmThresholdButtonPanel.this.buttonVt.setEnabled(TdmThresholdButtonPanel.this.supportsVtIppm());
                    }
                }
            });
            this.buttonFE.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((JRadioButton)itemEvent.getSource()).isSelected()) {
                        TdmThresholdButtonPanel.this.buttonSection.setEnabled(false);
                        TdmThresholdButtonPanel.this.buttonLine.setEnabled(true);
                        TdmThresholdButtonPanel.this.buttonPath.setEnabled(TdmThresholdButtonPanel.this.supportsFePathPm());
                        TdmThresholdButtonPanel.this.buttonVt.setEnabled(TdmThresholdButtonPanel.this.supportsVtIppm());
                        if (TdmThresholdProvPane.this.is15600()) {
                            TdmThresholdButtonPanel.this.buttonLine.setEnabled(true);
                            TdmThresholdButtonPanel.this.buttonSection.setEnabled(false);
                            TdmThresholdButtonPanel.this.buttonPath.setEnabled(true);
                            if (TdmThresholdButtonPanel.this.buttonSecondaryPath != null) {
                                TdmThresholdButtonPanel.this.buttonSecondaryPath.setEnabled(true);
                            }
                            TdmThresholdButtonPanel.this.buttonVt.setEnabled(TdmThresholdButtonPanel.this.supportsVtIppm());
                            if (TdmThresholdButtonPanel.this.buttonSection.isSelected()) {
                                TdmThresholdButtonPanel.this.buttonLine.setSelected(true);
                            }
                        } else {
                            boolean bl = TdmThresholdButtonPanel.this.getEntityModel().supportsFarEndPathPm();
                            boolean bl2 = TdmThresholdButtonPanel.this.supportsSdhAu3();
                            TdmThresholdButtonPanel.this.buttonLine.setEnabled(true);
                            TdmThresholdButtonPanel.this.buttonSection.setEnabled(false);
                            TdmThresholdButtonPanel.this.buttonPath.setEnabled(bl);
                            if (TdmThresholdButtonPanel.this.buttonSecondaryPath != null) {
                                TdmThresholdButtonPanel.this.buttonSecondaryPath.setEnabled(bl && bl2);
                            }
                            TdmThresholdButtonPanel.this.buttonVt.setEnabled(TdmThresholdButtonPanel.this.supportsVtIppm());
                            if (TdmThresholdButtonPanel.this.buttonSection.isSelected() && !TdmThresholdButtonPanel.this.buttonSection.isEnabled() || TdmThresholdButtonPanel.this.buttonPath.isSelected() && !TdmThresholdButtonPanel.this.buttonPath.isEnabled() || TdmThresholdButtonPanel.this.buttonVt.isSelected() && !TdmThresholdButtonPanel.this.buttonVt.isEnabled()) {
                                TdmThresholdButtonPanel.this.buttonLine.setSelected(true);
                            }
                        }
                    }
                }
            });
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.buttonNE = new JRadioButton("Near End", true);
            this.buttonFE = new JRadioButton("Far End");
            this.buttonLine = new JRadioButton(TdmThresholdProvPane.this.terms.getGeneralTerms(2), true);
            this.buttonSection = new JRadioButton(TdmThresholdProvPane.this.terms.getGeneralTerms(3));
            this.buttonPath = new JRadioButton(TdmThresholdProvPane.this.terms.getGeneralTerms(0));
            if (this.supportsSdhAu3()) {
                this.buttonSecondaryPath = new JRadioButton(TdmThresholdProvPane.this.terms.getTdmHoTerm(2));
            }
            this.buttonVt = new JRadioButton(TdmThresholdProvPane.this.terms.getGeneralTerms(1));
            this.buttonVt.setEnabled(this.supportsVtIppm());
            this.secLineButtonGroup = new ButtonGroup();
            this.secLineButtonGroup.add(this.buttonSection);
            this.secLineButtonGroup.add(this.buttonLine);
            this.secLineButtonGroup.add(this.buttonPath);
            if (this.buttonSecondaryPath != null) {
                this.secLineButtonGroup.add(this.buttonSecondaryPath);
            }
            this.secLineButtonGroup.add(this.buttonVt);
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.endButtonGroup = new ButtonGroup();
            this.endButtonGroup.add(this.buttonNE);
            this.endButtonGroup.add(this.buttonFE);
            this.showButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdmThresholdButtonPanel.this.refreshAction();
                }
            });
            this.resetToDefaultButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TdmThresholdButtonPanel.this.resetToDefaultAction();
                }
            });
            this.resetToDefaultButton.setEnabled(AbstractPane.isUserAuthorized(this.getEntityModel(), SecurityLevel.PROVISIONING));
            this.initButtonListeners();
            Dimension dimension = new Dimension(90, 70);
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(" Directions "));
            jPanel.setPreferredSize(dimension);
            jPanel.add(this.buttonNE);
            jPanel.add(this.buttonFE);
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel2.setBorder(BorderFactory.createTitledBorder(" Intervals "));
            jPanel2.setPreferredSize(new Dimension(dimension.width - 10, dimension.height));
            jPanel2.add((Component)this.button15Min, "North");
            jPanel2.add((Component)this.button1Day, "South");
            JPanel jPanel3 = new JPanel(new GridLayout(2, 2, 0, 0));
            jPanel3.setBorder(BorderFactory.createTitledBorder(" Types "));
            if (TdmThresholdProvPane.this.pType.isSonet()) {
                jPanel3.setPreferredSize(new Dimension(dimension.width + 70, dimension.height));
            } else {
                jPanel3.setPreferredSize(new Dimension(dimension.width * 4, dimension.height));
            }
            jPanel3.add(this.buttonLine);
            jPanel3.add(this.buttonPath);
            if (this.buttonSecondaryPath != null) {
                jPanel3.add(this.buttonSecondaryPath);
            }
            jPanel3.add(this.buttonSection);
            jPanel3.add(this.buttonVt);
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(jPanel3);
            this.add(this.showButton);
            this.add(this.resetToDefaultButton);
            this.setPreferredSize(new Dimension(800, 75));
        }

        public void resetToDefaultAction() {
            if (CerentDialog.yesNoDialog((Component)this, (String)"Do you really want to reset the thresholds to the default threshold values?", (String)"Reset to default")) {
                this.resetWithDefaultPmThresholds();
                return;
            }
        }

        public void resetWithDefaultPmThresholds() {
            int n;
            TdmThresholdProvPane.this.tableLabelString = " ";
            int n2 = 0;
            int n3 = n = TdmThresholdProvPane.this.pType.isSonet() ? 0 : 1;
            if (this.endButtonGroup.getSelection() == this.buttonFE.getModel()) {
                if (db.on()) {
                    db.println("FE");
                }
                n2 |= 4;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + "Far End";
            } else {
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + "Near End";
            }
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                if (db.on()) {
                    db.println("1 Day");
                }
                n2 |= 1;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", 1 Day";
            } else {
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", 15 Min";
            }
            if (this.secLineButtonGroup.getSelection() == this.buttonSection.getModel()) {
                if (db.on()) {
                    db.println("Section pressed");
                }
                n2 |= 2;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", " + TdmThresholdProvPane.this.terms.getGeneralTerms(3);
            } else if (this.secLineButtonGroup.getSelection() == this.buttonPath.getModel()) {
                if (db.on()) {
                    db.println("STS/VC4 pressed");
                }
                n2 |= 8;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", " + TdmThresholdProvPane.this.terms.getGeneralTerms(0);
            } else if (this.buttonSecondaryPath != null && this.secLineButtonGroup.getSelection() == this.buttonSecondaryPath.getModel()) {
                if (db.on()) {
                    db.println("VC3 pressed");
                }
                n2 |= 8;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", " + TdmThresholdProvPane.this.terms.getTdmHoTerm(2);
                n = 2;
            } else if (this.secLineButtonGroup.getSelection() == this.buttonLine.getModel()) {
                if (db.on()) {
                    db.println("Line pressed");
                }
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", " + TdmThresholdProvPane.this.terms.getGeneralTerms(2);
            } else if (this.secLineButtonGroup.getSelection() == this.buttonVt.getModel()) {
                if (db.on()) {
                    db.println("VT pressed");
                }
                n2 |= 0x10;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", " + TdmThresholdProvPane.this.terms.getGeneralTerms(1);
            }
            switch (n2) {
                case 7: {
                    if (db.on()) {
                        db.println("FE SEC 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetSonetSectionPmThresholdsToDefault(TdmThresholdProvPane.FE_SEC_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false));
                    break;
                }
                case 6: {
                    if (db.on()) {
                        db.println("FE SEC 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetSonetSectionPmThresholdsToDefault(TdmThresholdProvPane.FE_SEC_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false));
                    break;
                }
                case 3: {
                    if (db.on()) {
                        db.println("NE SEC 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetSonetSectionPmThresholdsToDefault(TdmThresholdProvPane.NE_SEC_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true));
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("NE SEC 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetSonetSectionPmThresholdsToDefault(TdmThresholdProvPane.FE_SEC_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true));
                    break;
                }
                case 5: {
                    if (db.on()) {
                        db.println("FE LIN 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetSonetLinePmThresholdsToDefault(TdmThresholdProvPane.FE_LIN_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false));
                    break;
                }
                case 4: {
                    if (db.on()) {
                        db.println("FE LIN 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetSonetLinePmThresholdsToDefault(TdmThresholdProvPane.FE_LIN_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false));
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("NE LIN 1 Day");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetSonetLinePmThresholdsToDefault(TdmThresholdProvPane.NE_LIN_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true));
                    break;
                }
                case 0: {
                    if (db.on()) {
                        db.println("NE LIN 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetSonetLinePmThresholdsToDefault(TdmThresholdProvPane.NE_LIN_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true));
                    break;
                }
                case 13: {
                    if (db.on()) {
                        db.println("FE PATH 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetSonetPathPmThresholdsToDefault(TdmThresholdProvPane.FE_PATH_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false, n));
                    break;
                }
                case 12: {
                    if (db.on()) {
                        db.println("FE PATH 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetSonetPathPmThresholdsToDefault(TdmThresholdProvPane.FE_PATH_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false, n));
                    break;
                }
                case 9: {
                    if (db.on()) {
                        db.println("NE PATH 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetSonetPathPmThresholdsToDefault(TdmThresholdProvPane.NE_PATH_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true, n));
                    break;
                }
                case 8: {
                    if (db.on()) {
                        db.println("NE PATH 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetSonetPathPmThresholdsToDefault(TdmThresholdProvPane.NE_PATH_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true, n));
                    break;
                }
                case 21: {
                    if (db.on()) {
                        db.println("FE VT 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetLoPathPmThresholdsToDefault(TdmThresholdProvPane.FE_VT_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false));
                    break;
                }
                case 20: {
                    if (db.on()) {
                        db.println("FE VT 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetLoPathPmThresholdsToDefault(TdmThresholdProvPane.FE_VT_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false));
                    break;
                }
                case 17: {
                    if (db.on()) {
                        db.println("NE VT 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetLoPathPmThresholdsToDefault(TdmThresholdProvPane.NE_VT_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true));
                    break;
                }
                case 16: {
                    if (db.on()) {
                        db.println("NE VT 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.resetLoPathPmThresholdsToDefault(TdmThresholdProvPane.NE_VT_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true));
                    break;
                }
            }
            TdmThresholdProvPane.this.tableLabel.setText(TdmThresholdProvPane.this.tableLabelString);
        }

        public void refreshAction() {
            int n;
            TdmThresholdProvPane.this.tableLabelString = " ";
            int n2 = 0;
            int n3 = n = TdmThresholdProvPane.this.pType.isSonet() ? 0 : 1;
            if (this.endButtonGroup.getSelection() == this.buttonFE.getModel()) {
                if (db.on()) {
                    db.println("FE");
                }
                n2 |= 4;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + "Far End";
            } else {
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + "Near End";
            }
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                if (db.on()) {
                    db.println("1 Day");
                }
                n2 |= 1;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", 1 Day";
            } else {
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", 15 Min";
            }
            if (this.secLineButtonGroup.getSelection() == this.buttonSection.getModel()) {
                if (db.on()) {
                    db.println("Section pressed");
                }
                n2 |= 2;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", " + TdmThresholdProvPane.this.terms.getGeneralTerms(3);
            } else if (this.secLineButtonGroup.getSelection() == this.buttonPath.getModel()) {
                if (db.on()) {
                    db.println("STS pressed");
                }
                n2 |= 8;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", " + TdmThresholdProvPane.this.terms.getGeneralTerms(0);
            } else if (this.buttonSecondaryPath != null && this.secLineButtonGroup.getSelection() == this.buttonSecondaryPath.getModel()) {
                if (db.on()) {
                    db.println("VC3 pressed");
                }
                n2 |= 8;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", " + TdmThresholdProvPane.this.terms.getTdmHoTerm(2);
                n = 2;
            } else if (this.secLineButtonGroup.getSelection() == this.buttonLine.getModel()) {
                if (db.on()) {
                    db.println("Line pressed");
                }
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", " + TdmThresholdProvPane.this.terms.getGeneralTerms(2);
            } else if (this.secLineButtonGroup.getSelection() == this.buttonVt.getModel()) {
                if (db.on()) {
                    db.println("VT pressed");
                }
                n2 |= 0x10;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", " + TdmThresholdProvPane.this.terms.getGeneralTerms(1);
            }
            switch (n2) {
                case 7: {
                    if (db.on()) {
                        db.println("FE SEC 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetSectionPmThresholdsPane(TdmThresholdProvPane.FE_SEC_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false));
                    break;
                }
                case 6: {
                    if (db.on()) {
                        db.println("FE SEC 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetSectionPmThresholdsPane(TdmThresholdProvPane.FE_SEC_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false));
                    break;
                }
                case 3: {
                    if (db.on()) {
                        db.println("NE SEC 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetSectionPmThresholdsPane(TdmThresholdProvPane.NE_SEC_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true));
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("NE SEC 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetSectionPmThresholdsPane(TdmThresholdProvPane.NE_SEC_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true));
                    break;
                }
                case 5: {
                    if (db.on()) {
                        db.println("FE LIN 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetFELinePmThresholdsPane(TdmThresholdProvPane.FE_LIN_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false));
                    break;
                }
                case 4: {
                    if (db.on()) {
                        db.println("FE LIN 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetFELinePmThresholdsPane(TdmThresholdProvPane.FE_LIN_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false));
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("NE LIN 1 Day");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetLinePmThresholdsPane(TdmThresholdProvPane.NE_LIN_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true));
                    break;
                }
                case 0: {
                    if (db.on()) {
                        db.println("NE LIN 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetLinePmThresholdsPane(TdmThresholdProvPane.NE_LIN_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true));
                    break;
                }
                case 13: {
                    if (db.on()) {
                        db.println("FE PATH 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetPathPmThresholdsPane(TdmThresholdProvPane.FE_PATH_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false, n));
                    break;
                }
                case 12: {
                    if (db.on()) {
                        db.println("FE PATH 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetPathPmThresholdsPane(TdmThresholdProvPane.FE_PATH_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false, n));
                    break;
                }
                case 9: {
                    if (db.on()) {
                        db.println("NE PATH 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetPathPmThresholdsPane(TdmThresholdProvPane.NE_PATH_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true, n));
                    break;
                }
                case 8: {
                    if (db.on()) {
                        db.println("NE PATH 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetPathPmThresholdsPane(TdmThresholdProvPane.NE_PATH_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true, n));
                    break;
                }
                case 21: {
                    if (db.on()) {
                        db.println("FE VT 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getLoPathPmThresholdsPane(TdmThresholdProvPane.FE_VT_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false));
                    break;
                }
                case 20: {
                    if (db.on()) {
                        db.println("FE VT 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getLoPathPmThresholdsPane(TdmThresholdProvPane.FE_VT_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false));
                    break;
                }
                case 17: {
                    if (db.on()) {
                        db.println("NE VT 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getLoPathPmThresholdsPane(TdmThresholdProvPane.NE_VT_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true));
                    break;
                }
                case 16: {
                    if (db.on()) {
                        db.println("NE VT 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getLoPathPmThresholdsPane(TdmThresholdProvPane.NE_VT_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true));
                    break;
                }
            }
            TdmThresholdProvPane.this.tableLabel.setText(TdmThresholdProvPane.this.tableLabelString);
        }

        protected ModuleModel getEntityModel() {
            return (ModuleModel)TdmThresholdProvPane.this.uiModel;
        }

        protected boolean supportsVtIppm() {
            return this.getEntityModel().supportsVtIppm();
        }

        protected boolean supportsSdhAu3() {
            return ((NodeModelDelegate)TdmThresholdProvPane.this.uiModel.getNodeModel()).isSdhAu3Supported();
        }

        protected boolean supportsFePathPm() {
            return TdmThresholdProvPane.this.is15600() ? true : this.getEntityModel().supportsFarEndPathPm();
        }
    }
}

