/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.PortModel;
import cerent.util.SDebug;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ECUMsIscPortsSupressionTableModel
extends AbstractTableModel {
    protected static final int ENTITY_NAME = 0;
    protected static final int SUPPRESS_INDEX = 1;
    private static SDebug db = new SDebug("ECUMsIscPortsSupressionTableModel");
    private IChassisModel model;
    protected List entities;
    private boolean[] rowDirty;
    private Boolean[] suppressFlags;
    private String[] columnNames;
    private int numLines;
    private static int ISC_SLOT_A = 24;
    private static int ISC_SLOT_B = 26;

    public ECUMsIscPortsSupressionTableModel(IChassisModel iChassisModel) {
        if (db.on()) {
            db.println("<init>");
        }
        this.columnNames = new String[]{"Ports", "Suppress Alarms"};
        this.model = iChassisModel;
        this.init();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getRowCount() {
        return this.entities.size();
    }

    protected void init() {
        this.initEntities();
        this.initFields();
    }

    protected void initEntities() {
        if (ECUMsIscPortsSupressionTableModel.db.on) {
            db.println("Refresh from Node...");
        }
        IEntityModel iEntityModel = null;
        try {
            iEntityModel = this.model.getEntityTableModel().getModule(this.model, ISC_SLOT_A);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
        }
        this.entities = iEntityModel.getChildren();
        try {
            iEntityModel = this.model.getEntityTableModel().getModule(this.model, ISC_SLOT_B);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
        }
        List list = iEntityModel.getChildren();
        this.entities.addAll(list);
    }

    protected void initFields() {
        this.numLines = this.entities.size();
        this.rowDirty = new boolean[this.numLines];
        this.suppressFlags = new Boolean[this.numLines];
    }

    protected String getEqTypeStringFor(int n) {
        return ((EntityModel)this.entities.get(n)).getEqTypeName();
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        try {
            switch (n2) {
                case 1: {
                    Boolean bl = (Boolean)object;
                    if (this.suppressFlags[n].equals(bl)) {
                        return;
                    }
                    this.suppressFlags[n] = bl;
                    break;
                }
                default: {
                    return;
                }
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 == 1) {
            return true;
        }
        return bl;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.getEntityName(n);
            }
            case 1: {
                return this.getSuppressAlarm(n);
            }
        }
        return "ERROR: INDEX OF " + n2;
    }

    public String getEntityName(int n) {
        EntityModel entityModel = (EntityModel)this.entities.get(n);
        String string = ((PortModel)entityModel).getPortString();
        return string;
    }

    public void refreshFromModel() throws Exception {
        this.initEntities();
        if (db.on()) {
            db.println("refreshFromModel");
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.suppressFlags[i] = null;
            this.rowDirty[i] = false;
        }
        this.fireTableDataChanged();
    }

    public void applyToModel() throws Exception {
        if (db.on()) {
            db.println("applyToModel");
        }
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (!this.rowDirty[n]) continue;
                ((EntityModel)this.entities.get(n)).setSuppressAlarms(this.getSuppressAlarm(n));
                this.rowDirty[n] = false;
            }
        }
        catch (Exception exception) {
            db.println("Exception occured ....");
        }
    }

    public boolean isDirty() {
        boolean bl = false;
        for (int i = 0; i < this.rowDirty.length; ++i) {
            if (!this.rowDirty[i]) continue;
            bl = true;
            break;
        }
        if (db.on()) {
            db.println("isDirty( ) -> " + bl);
        }
        return bl;
    }

    protected Boolean getSuppressAlarm(int n) {
        if (this.suppressFlags[n] == null) {
            this.suppressFlags[n] = new Boolean(((EntityModel)this.entities.get(n)).getSuppressAlarms());
        }
        return this.suppressFlags[n];
    }
}

