/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.model.PortModel;
import cerent.cms.model.TNCModuleModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NotApplicablePane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.oscm.OscOc3ThresholdProvPane;
import cerent.cms.ui.tnc.TNCOscOcLineProvPane;
import cerent.cms.ui.tnc.TNCPortsPane;
import java.awt.Component;
import java.util.Observable;

public class TNCLinePane
extends AbstractSubTabbedPane
implements ITabName {
    TNCModuleModel pcm = (TNCModuleModel)this.getUiModel();
    PortModel[] pt = null;
    NotApplicablePane nap;

    public TNCLinePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.registerWithModel();
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        db.info("Got an Update Message for " + observable);
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                TNCLinePane.this.refreshTabs();
            }
        };
    }

    private void refreshTabs() {
        TabbedView tabbedView;
        int n = this.subTabs.getSelectedIndex();
        Component component = this.subTabs.getSelectedComponent();
        int n2 = -1;
        if (component instanceof Pane && (tabbedView = ((Pane)component).getSubTabs()) != null && tabbedView.getTabCount() > 0) {
            n2 = tabbedView.getSelectedIndex();
        }
        if (n > -1) {
            this.subTabs.setSelectedIndex(n);
            component = this.subTabs.getSelectedComponent();
            if (component instanceof Pane && (tabbedView = ((Pane)component).getSubTabs()) != null && n2 > -1 && tabbedView.getTabCount() > 0) {
                tabbedView.setSelectedIndex(n2);
            }
        }
    }

    @Override
    public void enteringPage() {
        this.subTabs.removeAll();
        this.createSubTabs();
    }

    @Override
    protected void refreshMyLines(Object object) {
        this.subTabs.removeAll();
        this.createSubTabs();
    }

    @Override
    public void dispose() {
        db.info("Called dispose");
        super.dispose();
    }

    @Override
    protected void createSubTabs() {
        if (this.pcm.getAllInterfaceModels().length > 0) {
            this.subTabs.addTab("Ports", (Component)((Object)new TNCPortsPane("Ports", this.subTabs)));
        }
        if (this.pcm.getAllTdmLines().length > 0) {
            if (!this.pcm.getNodeModelDelegate().isSdh()) {
                this.subTabs.addTab("OC3 Line", (Component)((Object)new TNCOscOcLineProvPane("Line", this.subTabs)));
                this.subTabs.addTab("SONET Thresholds", (Component)this.getOC3ThresholdsPane());
            } else {
                this.subTabs.addTab("STM-1 Line", (Component)((Object)new TNCOscOcLineProvPane("Line", this.subTabs)));
                this.subTabs.addTab("SDH Thresholds", (Component)this.getOC3ThresholdsPane());
            }
        }
        if (this.pcm.getPpmPortModels().size() == 0) {
            this.nap = new NotApplicablePane("NotApplicablePane", this.getSubTabs());
            this.subTabs.addTab("NotApplicablePane", (Component)((Object)this.nap));
        }
    }

    private Pane getOC3ThresholdsPane() {
        return new ProtCardDualPane(this.subTabs, this.pcm, new OscOc3ThresholdProvPane("OC3 Line Thresholds", this.getParentView(), this.pcm.getAllTdmLines()));
    }
}

