/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.ConfigError;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InService;
import cerent.cms.model.InvalidLoopbackProvision;
import cerent.cms.model.InvalidQuality;
import cerent.cms.model.InvalidSoakTime;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SyncProvBusy;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.TNCModuleModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.tnc.TNCOscOcLineTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TNCOscOcLineProvPane
extends NodeProvPane
implements TableModelListener,
PropertyChangeListener {
    protected final int protocolType;
    protected TNCOscOcLineTableModel dataModel;
    protected TNCModuleModel eqpmtModel;
    protected TdmLineModel[] lineModels;
    protected int numLines;
    protected static final SDebug db = new SDebug("SonetLineProvPane");

    public TNCOscOcLineProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        INodeModel iNodeModel = tabbedView.getUiModel().getNodeModel();
        this.protocolType = iNodeModel.getTdmProtocolType();
        this.initProvPane();
    }

    protected void initProvPane() {
        this.eqpmtModel = (TNCModuleModel)this.getUiModel();
        this.lineModels = ((TNCModuleModel)this.getUiModel()).getAllTdmLines();
        this.numLines = 1;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane, "Center");
        this.customizeProvPane();
        this.registerWithModel();
    }

    protected void customizeProvPane() {
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(150);
        this.removeColumn(5);
        this.removeColumn(13);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[9]);
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor(this);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[12]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
        this.table.setRowHeight(soakTimeCellEditor.getPreferredHeight());
        tableColumn.sizeWidthToFit();
        this.prepareColumns();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected void prepareColumns() {
        this.removeColumn(10);
        this.removeColumn(11);
        boolean bl = false;
        if (this.eqpmtModel.getEqType() == 11) {
            String string;
            int n = this.eqpmtModel.getSlot();
            ArrayList arrayList = this.eqpmtModel.getNodeModel().getMfgData(this.eqpmtModel.getShelfId());
            if (n > 0 && (string = (String)arrayList.get(n - 1)) != null && string.indexOf("AS") != -1) {
                bl = true;
            }
        }
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(4));
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(TNCOscOcLineTableModel.blsrAttrs)));
        tableColumn.sizeWidthToFit();
        if (!bl) {
            this.removeColumn(4);
        }
        this.setAttrCellEditor(2, "declareSfBerLevel");
        this.setAttrCellEditor(3, "declareSdBerLevel");
    }

    protected void setAttrCellEditor(int n, String string) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[n]);
        try {
            Attribute[] attributeArray = this.getAttributeArray(string);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        }
        catch (NoSuchElementException noSuchElementException) {
            if (db.on()) {
                db.println("Warning: cannot find attributes for " + string);
            }
            this.table.removeColumn(tableColumn);
        }
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    private JComboBox getPJMonitorCombo() {
        int n = 0;
        try {
            int n2 = this.protocolType == 0 ? 0 : 1;
            n = this.lineModels[0].numHo(n2);
        }
        catch (Exception exception) {
            db.println("Caught exception in getPJMonitorCombo");
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_NBR_HOS_FOR_LINE);
        }
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        if (db.on()) {
            db.println("Num Ho = " + n);
        }
        for (int i = 0; i <= n; ++i) {
            jComboBox.addItem(new Integer(i));
        }
        jComboBox.setRenderer(new PJMonitorListCellRenderer());
        return jComboBox;
    }

    protected TNCOscOcLineTableModel getDataModel() {
        INodeModel iNodeModel = this.parentTV.getUiModel().getNodeModel();
        return new TNCOscOcLineTableModel(iNodeModel, this.lineModels);
    }

    protected AttributeMaps getAttributeMap() {
        IModel iModel = this.parentTV.getUiModel();
        return ElementDefaults.getAttributeMap(iModel);
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = this.getAttributeMap().getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void applyChangesToModel() throws InvalidLoopbackProvision, InvalidSoakTime, InService, NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError, AnnotatedException, SyncProvError, SyncProvBusy, InvalidQuality, EMCProvisionError {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dataModel.adminStateChangedToFormOfOOS()) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
        }
        if (this.dataModel.mediaChanged()) {
            stringBuffer.append("Some lines have their media changed.").append('\n');
        }
        if (this.dataModel.needRemoveLoopback()) {
            stringBuffer.append("Some lines will be removed from loopback since their new state does not allow loopback.").append('\n');
        }
        if (stringBuffer.length() != 0) {
            stringBuffer.append(this.getApplyString());
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                return;
            }
        }
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                TNCOscOcLineProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In TdmLineProvPane changeMessage cannot find Model " + observable);
        }
    }

    @Override
    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    protected void unRegisterWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void destroy() {
        this.unRegisterWithModel();
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void refreshFromModel() {
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("SonetLineProvPane::enteringPage!");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("SonetLineProvPane::leavingPage!");
        }
        super.leavingPage();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.TNCOscOcLineProvPane;
    }

    class PJMonitorListCellRenderer
    extends DefaultListCellRenderer {
        PJMonitorListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2 = object;
            if (object instanceof Integer && (Integer)object == 0) {
                object2 = "Off";
            }
            return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
        }
    }

    class SonetMonitorCellRenderer
    extends DefaultTableCellRenderer {
        SonetMonitorCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = object;
            if (object instanceof Integer && (Integer)object == 0) {
                object2 = "Off";
            }
            return super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
        }
    }
}

