/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.model.IRmonModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.RmonLineUpdate;
import cerent.cms.model.TNCModuleModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmTdmPmPane;
import cerent.cms.ui.rmon.RmonPmHistPane;
import cerent.cms.ui.rmon.RmonPmStatPane;
import cerent.cms.ui.rmon.RmonPmUtilPane;
import cerent.cms.ui.tnc.TNCEthernetPmPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Observer;

public class TNCPayloadPmPane
extends AbstractSubTabbedPane
implements ITabName {
    private boolean isSDH;
    private boolean isCombo;
    private AbstractPane tdmTab;
    private AbstractPane rmonStatTab;
    private AbstractPane rmonUtilTab;
    private AbstractPane rmonHistTab;
    private AbstractPane unframedTab;
    private TdmLineModel[] _tdmLines = null;
    private IRmonModel[] _rmonLines = null;

    public TNCPayloadPmPane(String string, TabbedView tabbedView, TNCModuleModel tNCModuleModel, TdmLineModel[] tdmLineModelArray, IRmonModel[] iRmonModelArray) {
        super(string, tabbedView);
        this._tdmLines = tdmLineModelArray;
        this._rmonLines = iRmonModelArray;
        this.setLayout(new BorderLayout());
        this.rmonStatTab = this.createDwdmRmonStatPane(this._rmonLines);
        this.rmonUtilTab = this.createDwdmRmonUtilPane(this._rmonLines);
        this.rmonHistTab = this.createDwdmRmonHistPane(this._rmonLines);
        this.registerWithModel();
        this.isSDH = tNCModuleModel.getNodeModel().getTdmProtocolTypeObj().isSdh();
    }

    @Override
    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        this.getUiModel().addObserver((Observer)((Object)this));
        for (n = 0; n < this._tdmLines.length; ++n) {
            if (this._tdmLines[n] == null) continue;
            this._tdmLines[n].addObserver((Observer)((Object)this));
        }
        if (this._rmonLines != null) {
            for (n = 0; n < this._rmonLines.length; ++n) {
                if (this._rmonLines[n] == null) continue;
                this._rmonLines[n].addObserver((Observer)((Object)this));
            }
        }
    }

    protected void unregisterWithModel() {
        int n;
        super.destroy();
        this.getUiModel().deleteObserver((Observer)((Object)this));
        for (n = 0; n < this._tdmLines.length; ++n) {
            if (this._tdmLines[n] == null) continue;
            this._tdmLines[n].deleteObserver((Observer)((Object)this));
        }
        for (n = 0; n < this._rmonLines.length; ++n) {
            if (this._rmonLines[n] == null) continue;
            this._rmonLines[n].deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void destroy() {
        AbstractPane[] abstractPaneArray = new AbstractPane[]{this.tdmTab, this.rmonStatTab, this.rmonUtilTab, this.rmonHistTab, this.unframedTab};
        this.subTabs.removeAll();
        for (int i = 0; i < abstractPaneArray.length; ++i) {
            if (abstractPaneArray[i] == null) continue;
            abstractPaneArray[i].destroy();
        }
        super.destroy();
    }

    @Override
    protected void createSubTabs() {
        this.tdmTab = this.createDwdmTdmPane(this._tdmLines);
        this.setupTabs(this._tdmLines, this._rmonLines);
    }

    @Override
    protected void refreshMyLines(Object object) {
        block6: {
            Object object2;
            TNCModuleModel tNCModuleModel = (TNCModuleModel)this.getUiModel();
            if (object instanceof RmonLineUpdate) {
                object2 = (RmonLineUpdate)object;
                this._rmonLines = object2.getRmonModels();
            } else if (object instanceof OcnLineUpdate) {
                object2 = (OcnLineUpdate)object;
                this._tdmLines = (TdmLineModel[])object2.getModels();
            }
            object2 = (AbstractPane)((Object)this.subTabs.getSelectedComponent());
            this.setupTabs(this._tdmLines, this._rmonLines);
            if (object2 != null) {
                try {
                    this.subTabs.setSelectedComponent((Component)object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.subTabs.getTabCount() <= 0) break block6;
                    this.subTabs.setSelectedIndex(0);
                }
            }
        }
    }

    protected AbstractPane createDwdmTdmPane(TdmLineModel[] tdmLineModelArray) {
        return new DwdmTdmPmPane(this.isSDH ? "SDH" : "SONET", this.getParentView(), tdmLineModelArray);
    }

    protected AbstractPane createDwdmRmonStatPane(IRmonModel[] iRmonModelArray) {
        return new RmonPmStatPane("Statistics", this.subTabs, iRmonModelArray, false);
    }

    protected AbstractPane createDwdmRmonUtilPane(IRmonModel[] iRmonModelArray) {
        return new RmonPmUtilPane("Utilization", this.subTabs, iRmonModelArray);
    }

    protected AbstractPane createDwdmRmonHistPane(IRmonModel[] iRmonModelArray) {
        return new RmonPmHistPane("History", this.subTabs, iRmonModelArray);
    }

    private void setupTabs(TdmLineModel[] tdmLineModelArray, IRmonModel[] iRmonModelArray) {
        this.subTabs.removeAll();
        AbstractPane[] abstractPaneArray = new AbstractPane[]{this.rmonStatTab, this.rmonUtilTab, this.rmonHistTab};
        if (iRmonModelArray.length > 0) {
            this.subTabs.add("Ethernet", (Component)((Object)new TNCEthernetPmPane("Ethernet", this.subTabs, iRmonModelArray, abstractPaneArray)));
        }
        if (tdmLineModelArray != null && tdmLineModelArray.length > 0) {
            this.subTabs.add(this.isSDH ? "SDH" : "SONET", (Component)((Object)this.tdmTab));
        }
    }
}

