/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.model.EtherLineUpdate;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.RmonLineUpdate;
import cerent.cms.model.TNCModuleModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NotApplicablePane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.OpticsPmHistPane;
import cerent.cms.ui.dwdm.OpticsPmStatPane;
import cerent.cms.ui.tnc.TNCPayloadPmPane;
import java.awt.Component;
import java.util.Observable;

public class TNCPerfPane
extends AbstractSubTabbedPane
implements ITabName {
    protected IRmonModel[] _rmonModels;
    protected TdmLineModel[] _sonetModels;
    protected boolean _supportsOTN;
    private AbstractPane _otnPmTab;
    private AbstractPane _payPmTab;
    private AbstractPane _optPmTab;
    private TNCModuleModel mm = (TNCModuleModel)this.getUiModel();
    private NotApplicablePane nap;

    public TNCPerfPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this._sonetModels = this.mm.getAllTdmLines();
        this._rmonModels = this.mm.getRmonModels();
        this.registerWithModel();
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        db.info("Got an Update Message for " + observable);
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                TNCPerfPane.this.refreshTabs();
            }
        };
    }

    private void refreshTabs() {
        int n = this.subTabs.indexOfTab("Payload PM");
        if (n > -1) {
            this.subTabs.removeTabAt(n);
            this.subTabs.insertTab("Payload PM", null, (Component)((Object)this.getPayloadPmTab("Payload PM")), "", n);
        }
    }

    @Override
    public void dispose() {
        db.info("Called dispose");
        super.dispose();
    }

    @Override
    public void enteringPage() {
        this.subTabs.removeAll();
        this.createSubTabs();
    }

    @Override
    protected void createSubTabs() {
        if (this.mm.getPpmPortModels().size() == 0) {
            this.nap = new NotApplicablePane("NotApplicablePane", this.getSubTabs());
            this.subTabs.addTab("NotApplicablePane", (Component)((Object)this.nap));
        } else {
            this._payPmTab = this.getPayloadPmTab("Payload PM");
            if (this._payPmTab != null) {
                this.subTabs.addTab("Payload PM", (Component)((Object)this._payPmTab));
            }
            this._optPmTab = this.getOptPmTab("Optics PM");
            if (this._optPmTab != null) {
                this.subTabs.addTab("Optics PM", (Component)((Object)this._optPmTab));
                this.subTabs.setTabPlacement(2);
            }
        }
    }

    private AbstractPane getOptPmTab(String string) {
        return new AbstractSubTabbedPane(string, this.subTabs){

            @Override
            public void createSubTabs() {
                this.subTabs.addTab("Current Values", (Component)((Object)new OpticsPmStatPane("Current Values", this.subTabs, TNCPerfPane.this.mm.getOpticsPmModels())));
                this.subTabs.addTab("Historical PM", (Component)((Object)new OpticsPmHistPane("Historical PM", this.subTabs, TNCPerfPane.this.mm.getOpticsPmModels())));
            }
        };
    }

    private AbstractPane getPayloadPmTab(String string) {
        TNCModuleModel tNCModuleModel = (TNCModuleModel)this.getUiModel();
        this._sonetModels = tNCModuleModel.getAllTdmLines();
        this._rmonModels = tNCModuleModel.getRmonModels();
        if (this._sonetModels.length > 0 || this._rmonModels.length > 0) {
            return new TNCPayloadPmPane("Payload PM", this.subTabs, tNCModuleModel, this._sonetModels, this._rmonModels);
        }
        return null;
    }

    @Override
    protected void refreshMyLines(Object object) {
        if (object instanceof EtherLineUpdate) {
            this._rmonModels = this.mm.getRmonModels();
        } else if (object instanceof OcnLineUpdate) {
            this._sonetModels = this.mm.getAllTdmLines();
        } else if (object instanceof RmonLineUpdate) {
            this._rmonModels = this.mm.getRmonModels();
        }
        this.subTabs.removeAll();
        this.createSubTabs();
    }
}

