/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ISupportsOpticsProvExtModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsProvExtModel;
import cerent.cms.model.TNCModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.OpticsProvExtHelper;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.VariComboBoxCellEditor;
import cerent.cms.ui.tnc.TNCPortsTableModel;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TNCPortsPane
extends NodeProvPane
implements TableModelListener,
PropertyChangeListener {
    protected TNCPortsTableModel dataModel;
    protected TNCModuleModel eqpmtModel = (TNCModuleModel)this.getUiModel();
    protected InterfaceModel[] lineModels = this.eqpmtModel.getAllInterfaceModels();
    private OpticsProvExtModel[] opticModels;
    protected int numLines = this.lineModels.length;
    private boolean notInited = true;
    private ObservableManager _obsMgr;
    private DefaultCellEditor stateEditor;
    private DefaultCellEditor nonAINSStateEditor;
    protected static final SDebug db = new SDebug("TNCPortsPane");

    public TNCPortsPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.updateOpticModels();
        this.registerWithModel();
    }

    @Override
    public void refreshMyLines(Object object) {
        this.numLines = this.lineModels.length;
        this.getObsMgr().addObservable((Observable[])this.lineModels);
        if (this.dataModel != null) {
            this.dataModel.refreshMyLines(this.lineModels);
        }
    }

    protected void init() {
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        boolean bl = AdminState.isANSI(this.getTdmProtocolType());
        this.nonAINSStateEditor = new DefaultCellEditor(this.getComboBoxFor(AdminState.getDefaultAdminStates(bl)));
        this.setOpticsExtCellEditor(this.eqpmtModel, this.opticModels, db);
        tableColumn.setCellEditor(this.nonAINSStateEditor);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.getObsMgr().addObservable((Observable[])this.lineModels);
        this.add((Component)uScrollPane, "Center");
    }

    protected TNCPortsTableModel getDataModel() {
        return new TNCPortsTableModel(this.lineModels, this.opticModels);
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    private int getTdmProtocolType() {
        return this.eqpmtModel.getNodeModel().getTdmProtocolType();
    }

    private JComboBox getComboBoxFor(Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected void setOpticsExtCellEditor(ModuleModel moduleModel, OpticsProvExtModel[] opticsProvExtModelArray, SDebug sDebug) {
        int n = 90;
        String string = this.dataModel.columnNames[4];
        TableColumn tableColumn = this.table.getColumn(string);
        Attribute[][] attributeArray = null;
        attributeArray = OpticsProvExtHelper.getCombinedReaches(moduleModel, opticsProvExtModelArray, sDebug);
        tableColumn.setCellEditor(new VariComboBoxCellEditor(attributeArray));
        tableColumn.sizeWidthToFit();
        tableColumn.setMinWidth(n);
    }

    private void updateOpticModels() {
        this.opticModels = new OpticsProvExtModel[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            InterfaceModel interfaceModel = this.lineModels[i];
            if (!(interfaceModel instanceof ISupportsOpticsProvExtModel)) continue;
            this.opticModels[i] = (OpticsProvExtModel)((ISupportsOpticsProvExtModel)((Object)interfaceModel)).getOpticsProvExtModel();
        }
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                TNCPortsPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1 && this.dataModel != null) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        }
    }

    @Override
    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        if (this.dataModel != null) {
            this.dataModel.refreshFromModel();
        }
        this.resetDirty();
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
        this.getObsMgr().setPassing(true);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.TNCEtherLinePane;
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }
}

