/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eReach;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsProvExtModel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.TNCModuleModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.IAdminTableAccess;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.table.AbstractTableModel;

public class TNCPortsTableModel
extends AbstractTableModel
implements IAdminTableAccess {
    private InterfaceModel[] model;
    protected String[] portNames;
    protected AdminState[] adminState;
    private TNCModuleModel eqpmtModel;
    OpticsProvExtModel[] opticModels;
    private IServiceState[] serviceState;
    private Attribute[] reach;
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int REACH = 4;
    int numLines;
    protected String[] columnNames;
    protected boolean[][] isDirty;
    private boolean FlgDlgAlreadyShowed;
    protected EntityCellRenderer myPortRenderer;
    private static final SDebug db = new SDebug("TNCPortsTableModel");

    public TNCPortsTableModel(InterfaceModel[] interfaceModelArray, OpticsProvExtModel[] opticsProvExtModelArray) {
        block3: {
            this.columnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "Reach"};
            this.FlgDlgAlreadyShowed = false;
            this.model = interfaceModelArray;
            this.numLines = interfaceModelArray.length;
            this.portNames = new String[this.numLines];
            this.opticModels = opticsProvExtModelArray;
            this.myPortRenderer = new EntityCellRenderer(false);
            if (interfaceModelArray.length > 0) {
                try {
                    this.eqpmtModel = (TNCModuleModel)interfaceModelArray[0].getModuleModel();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        this.refreshMyLines(interfaceModelArray);
    }

    public void refreshMyLines(InterfaceModel[] interfaceModelArray) {
        this.reach = new Attribute[this.numLines];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class getColumnClass(int n) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.model == null || this.numLines <= 0 || n2 != 3 && n2 != 2;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    @Override
    public boolean isAdminStateDirty(int n) {
        return this.isDirty(n, 2);
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 2: {
                    return this.getAdminState(n).toString(this.getTerms());
                }
                case 3: {
                    return this.getServiceState(n).toString(this.getTerms());
                }
                case 4: {
                    return this.getReach(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("DwdmLineProvTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private Attribute getReach(int n) {
        if (this.reach[n] == null) {
            eReach eReach2 = null;
            Attribute attribute = null;
            try {
                eReach2 = this.opticModels[n].getLineReach();
                this.reach[n] = attribute = this.getAttributeMap().getAttributeForVal("declDwdmReach", eReach2.value());
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.reach[n] = attribute = this.getAttributeMap().getAttributeForVal("declDwdmReach", 0);
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("DwdmLineProvTableModel: " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.reach[n];
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.eqpmtModel.getNodeModel().getTdmProtocolType(), this.getTerms());
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        if (n >= 0 && n < this.model.length) {
            IPortModel iPortModel = this.model[n].getPortModel();
            return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
        }
        return "!ERROR!";
    }

    protected String getPortName(int n) {
        if (n >= 0 && n < this.portNames.length) {
            if (this.portNames[n] == null) {
                try {
                    this.portNames[n] = this.model[n].getAlias();
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            return this.portNames[n];
        }
        return "!ERROR!";
    }

    @Override
    public AdminState getAdminState(int n) throws Exception {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.model[n].getAdminStateEnum();
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.model[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    private TDMTerminology getTerms() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value row=" + n + " col=" + n2 + " newVal=" + object);
        }
        try {
            switch (n2) {
                case 1: {
                    this.portNames[n] = (String)object;
                    break;
                }
                case 2: {
                    AdminState adminState = (AdminState)object;
                    if (adminState.equals(this.adminState[n])) {
                        return;
                    }
                    this.adminState[n] = adminState;
                    break;
                }
                case 4: {
                    this.reach[n] = (Attribute)object;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return;
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.FlgDlgAlreadyShowed = false;
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.reach[n] = null;
        this.portNames[n] = null;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    protected eAdminState getAdminStateFor(int n) throws Exception {
        return this.getAdminState(n).getAdminStateEnum();
    }

    public void applyToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                eReach eReach2;
                if (this.isDirty(n, 1)) {
                    this.model[n].setAlias(this.getPortName(n));
                    this.isDirty[n][1] = false;
                }
                if (this.isDirty(n, 2)) {
                    if (db.on()) {
                        db.fine("setting line to admin state " + this.getAdminState(n).toString());
                    }
                    this.model[n].setAdminState(this.getAdminStateFor(n));
                    this.isDirty[n][2] = false;
                }
                if (!this.isDirty(n, 4)) continue;
                Attribute attribute = this.getReach(n);
                if (db.on()) {
                    db.println("setting reach " + attribute);
                    db.println("Model is " + this.model[n]);
                }
                if ((eReach2 = eReach.from_int(attribute.getValue())).value() == 0) continue;
                this.opticModels[n].setLineReach(eReach2);
            }
        }
        catch (UnsupportedOperation unsupportedOperation) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1), (Exception)((Object)unsupportedOperation));
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }
}

