/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wxc;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.CommonHelper;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.ObflPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ampli.OchncMaintenancePane;
import cerent.cms.ui.ampli.WlPowerPane;
import cerent.cms.ui.wxc.WxcMaintenanceTabPane;
import java.awt.Component;

public class WxcMaintenancePane
extends NodeProvPane {
    private WxcMaintenanceTabPane wxcTabPane;
    private OchncMaintenancePane wxc80TabPane;
    private OpticsModuleModel module;

    public WxcMaintenancePane(String string, TabbedView tabbedView, ModuleModel moduleModel) {
        super(string, tabbedView);
        AbstractOpticsLineModel[] abstractOpticsLineModelArray;
        this.module = (OpticsModuleModel)moduleModel;
        OpticsLineModel[] opticsLineModelArray = this.module.getOpticsLineModels();
        this.subTabs = new SubTabbedView(moduleModel, tabbedView);
        if (CommonHelper.isChannelPowerSupported((OpticsModuleModel)this.getUiModel())) {
            abstractOpticsLineModelArray = this.module.getLinesSupportingChanelPower();
            this.subTabs.addTab("Wavelength Power", (Component)this.getWlPowerTab());
        }
        if (this.module.getEqType() == 266) {
            this.subTabs.addTab("OCHNC", (Component)this.getwxcMaintTabs(opticsLineModelArray));
        } else {
            this.setHelpVisible(false);
            this.setApplyVisible(false);
            this.setResetVisible(false);
            abstractOpticsLineModelArray = this.module.getAllOpticsInterfaces();
            this.subTabs.addTab("OCHNC", (Component)this.getOchnc(abstractOpticsLineModelArray));
        }
        if (((OpticsModuleModel)moduleModel).isOFBLSupported()) {
            this.subTabs.addTab("OBFL", (Component)this.getOBFLTab((OpticsModuleModel)moduleModel));
        }
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    protected Pane getOBFLTab(OpticsModuleModel opticsModuleModel) {
        return new ObflPane("OBFL", this.getParentView(), opticsModuleModel);
    }

    protected Pane getWlPowerTab() {
        return new WlPowerPane("Wavelength Power", this.getParentView());
    }

    private Pane getwxcMaintTabs(OpticsLineModel[] opticsLineModelArray) {
        this.wxcTabPane = new WxcMaintenanceTabPane("Parameters", this.getParentView(), this, opticsLineModelArray);
        return this.wxcTabPane;
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.WxcOCHParametersMaintPane;
    }

    @Override
    protected AbstractLeavePageException createLeavePageException(String string) {
        return null;
    }

    @Override
    public void leavingPage() throws Exception {
    }

    @Override
    public void enteringPage() throws Exception {
    }

    @Override
    public void customBehaviour() {
        this.enableApply(false);
        if (this.wxcTabPane != null) {
            this.wxcTabPane.resetModel();
        }
        if (this.wxc80TabPane != null) {
            this.wxc80TabPane.resetModel();
        }
    }

    @Override
    public void applyChangesToModel() throws Exception {
        if (this.wxcTabPane != null) {
            this.wxcTabPane.updateModel();
        }
        if (this.wxc80TabPane != null) {
            this.wxc80TabPane.updateModel();
        }
    }

    public void enableApply(boolean bl) {
        this.setDirty(bl);
    }

    private Pane getOchnc(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        this.wxc80TabPane = new OchncMaintenancePane("OCHNC", this.getParentView(), abstractOpticsLineModelArray);
        return this.wxc80TabPane;
    }
}

