/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wxc;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.wxc.WxcOchOpticalThresholdProvPane;
import cerent.cms.ui.wxc.WxcOchOpticalThresholdTableModel;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class WxcOchOpticalThresholdPane
extends AbstractPane {
    protected AbstractOpticsLineModel[] lowerInterfaces;
    private ObservableManager _obsMgr = null;
    private ButtonPanel buttonPanel = null;
    JPanel labeledTablePanel = null;
    protected JPanel tablePanel = null;
    protected Pane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    protected OpticsModuleModel eqpmtModel;
    public static final String WARNING_15MIN_TH_PANEL = "WARN_15MIN_TH";
    public static final String WARNING_1DAY_TH_PANEL = "WARN_1DAY_TH";
    public static final String ALARM_TH_PANEL = "ALARM_TH";
    public static final int WARNING_15MIN_TH = 0;
    public static final int WARNING_1DAY_TH = 1;
    public static final int ALARM_TH = 2;
    private boolean layoutInited = false;
    public JButton showButton = new JButton("Retrieve");
    private JLabel tableLabel = new JLabel("TEST LABEL...");
    private String tableLabelString = new String();
    private static final SDebug db = new SDebug("WxcOchOpticalThresholdPane");

    public WxcOchOpticalThresholdPane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(string, tabbedView);
        this.lowerInterfaces = abstractOpticsLineModelArray;
        this.panes = new Pane[4];
        this.eqpmtModel = (OpticsModuleModel)this.getUiModel();
        this.initializeLayout();
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.layoutInited = true;
        this.add(this.getButtonPanel(), "South");
        this.add(this.getTablePanel(), "Center");
        this.getButtonPanel().refreshAction();
    }

    private ButtonPanel getButtonPanel() {
        if (null == this.buttonPanel) {
            this.buttonPanel = new ButtonPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        this.labeledTablePanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(new Dimension(800, 300));
        this.panes[0] = this.getThresholdProvPane(WARNING_15MIN_TH_PANEL, 0);
        this.tablePanel.add((Component)this.panes[0], WARNING_15MIN_TH_PANEL);
        this.panes[1] = this.getThresholdProvPane(WARNING_1DAY_TH_PANEL, 1);
        this.tablePanel.add((Component)this.panes[1], WARNING_1DAY_TH_PANEL);
        this.panes[2] = this.getThresholdProvPane(ALARM_TH_PANEL, 2);
        this.tablePanel.add((Component)this.panes[2], ALARM_TH_PANEL);
        this.cl.show(this.tablePanel, WARNING_15MIN_TH_PANEL);
        this.currentPane = this.panes[0];
        this.labeledTablePanel.add((Component)this.tableLabel, "North");
        this.labeledTablePanel.add((Component)this.tablePanel, "Center");
        return this.labeledTablePanel;
    }

    protected WxcOchOpticalThresholdProvPane getThresholdProvPane(String string, int n) {
        return new WxcOchOpticalThresholdProvPane(string, this.getParentView(), this.lowerInterfaces, n);
    }

    protected void showPanel(Pane pane) {
        block4: {
            try {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
                this.currentPane.leavingPage();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            pane.enteringPage();
            TablePropertyMgr.getColumnPrefs(pane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + pane.getName());
        }
        catch (Exception exception) {
            db.finer("Exception in showPanel() " + exception);
        }
        this.cl.show(this.tablePanel, pane.getName());
        this.currentPane = pane;
    }

    @Override
    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    @Override
    public void leavingPage() throws Exception {
        if (this.currentPane != null) {
            TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
            this.currentPane.leavingPage();
        }
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
            this.getButtonPanel().refreshAction();
        }
    }

    @Override
    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    @Override
    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            if (null == this.panes[i]) continue;
            TablePropertyMgr.setColumnPrefs(this.panes[i].getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.panes[i].getName());
            if (this.panes[i] instanceof WxcOchOpticalThresholdProvPane) {
                ((WxcOchOpticalThresholdProvPane)this.panes[i]).dispose();
            }
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    protected void adjustColumn(int n) {
        this.removeColumn(4);
        this.removeColumn(3);
        this.removeColumn(5);
        this.removeColumn(6);
        this.removeColumn(7);
        if (n != 2) {
            this.addColumn(4);
            this.addColumn(3);
            this.setColumnW(3);
        } else {
            this.addColumn(5);
            this.addColumn(6);
            this.addColumn(7);
            this.setColumnW(4);
        }
    }

    protected void removeColumn(int n) {
        block2: {
            String string = WxcOchOpticalThresholdTableModel.columnNames[n];
            try {
                TableColumn tableColumn = this.currentPane.getTable().getColumn(string);
                this.currentPane.getTable().removeColumn(tableColumn);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void addColumn(int n) {
        TableColumn tableColumn = new TableColumn(n);
        String string = WxcOchOpticalThresholdTableModel.columnNames[n];
        tableColumn.setHeaderValue(string);
        this.currentPane.getTable().getColumnModel().addColumn(tableColumn);
    }

    protected void setColumnW(int n) {
        TableColumn tableColumn = null;
        block4: for (int i = 0; i < n; ++i) {
            tableColumn = this.currentPane.getTable().getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    tableColumn.setPreferredWidth(140);
                    continue block4;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    tableColumn.setPreferredWidth(120);
                }
            }
        }
    }

    private class ButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonWarning;
        public JRadioButton buttonAlarm;
        public ButtonGroup periodButtonGroup;
        public ButtonGroup warningAlarmButtonGroup;
        protected int ALARM_MASK = 2;
        protected int ONE_DAY_MASK = 1;

        private ButtonPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.buttonWarning = new JRadioButton("Warning", true);
            this.buttonAlarm = new JRadioButton("Alarm");
            this.warningAlarmButtonGroup = new ButtonGroup();
            this.warningAlarmButtonGroup.add(this.buttonWarning);
            this.warningAlarmButtonGroup.add(this.buttonAlarm);
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            WxcOchOpticalThresholdPane.this.showButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ButtonPanel.this.refreshAction();
                }
            });
            this.buttonWarning.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((JRadioButton)itemEvent.getSource()).isSelected()) {
                        ButtonPanel.this.button15Min.setEnabled(true);
                        ButtonPanel.this.button1Day.setEnabled(true);
                    } else {
                        ButtonPanel.this.button15Min.setEnabled(false);
                        ButtonPanel.this.button1Day.setEnabled(false);
                    }
                }
            });
            Dimension dimension = new Dimension(90, 70);
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(" Types "));
            jPanel.setPreferredSize(dimension);
            jPanel.add((Component)this.buttonWarning, "North");
            jPanel.add((Component)this.buttonAlarm, "South");
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel2.setBorder(BorderFactory.createTitledBorder(" Intervals "));
            jPanel2.setPreferredSize(dimension);
            jPanel2.add((Component)this.button15Min, "North");
            jPanel2.add((Component)this.button1Day, "South");
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(WxcOchOpticalThresholdPane.this.showButton);
            this.setPreferredSize(new Dimension(800, 75));
        }

        public void refreshAction() {
            int n = 0;
            WxcOchOpticalThresholdPane.this.tableLabelString = " ";
            if (this.warningAlarmButtonGroup.getSelection() == this.buttonAlarm.getModel()) {
                if (db.on()) {
                    db.println("Alarm Thresholds");
                }
                n = this.ALARM_MASK;
                WxcOchOpticalThresholdPane.this.tableLabelString = WxcOchOpticalThresholdPane.this.tableLabelString + "Alarm Thresholds";
            } else {
                WxcOchOpticalThresholdPane.this.tableLabelString = WxcOchOpticalThresholdPane.this.tableLabelString + "Warning Thresholds";
                if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                    if (db.on()) {
                        db.println("1 Day");
                    }
                    n |= this.ONE_DAY_MASK;
                    WxcOchOpticalThresholdPane.this.tableLabelString = WxcOchOpticalThresholdPane.this.tableLabelString + ", 1 Day";
                } else {
                    WxcOchOpticalThresholdPane.this.tableLabelString = WxcOchOpticalThresholdPane.this.tableLabelString + ", 15 Min";
                }
            }
            switch (n) {
                case 0: {
                    if (db.on()) {
                        db.println("WARNING 15MIN");
                    }
                    WxcOchOpticalThresholdPane.this.showPanel(WxcOchOpticalThresholdPane.this.panes[0]);
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("WARNING 1DAY");
                    }
                    WxcOchOpticalThresholdPane.this.showPanel(WxcOchOpticalThresholdPane.this.panes[1]);
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("ALARM TH");
                    }
                    WxcOchOpticalThresholdPane.this.showPanel(WxcOchOpticalThresholdPane.this.panes[2]);
                }
            }
            WxcOchOpticalThresholdPane.this.tableLabel.setText(WxcOchOpticalThresholdPane.this.tableLabelString);
            WxcOchOpticalThresholdPane.this.adjustColumn(n);
        }
    }
}

