/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sCVlanRange;
import cerent.cms.idl.EtherL2Media.sMEP;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IDomainProfileInfo;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.MEPInfo;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.xpl2.XPL2MEPTableModel;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.UComboBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class MEPCreateDialog
extends JDialog
implements ActionListener {
    private static final String TITLE = "Create MEP";
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    public static final int MARGIN = 5;
    private static final String SLOT = "Slot:";
    private static final String PORT = "Port:";
    private static final String DOMAIN = "Domain:";
    private static final String MPID = "MPID:";
    private static final String VLAN_ID = "Vlan Id:";
    private static final SDebug db = new SDebug("MEPCreateDialog");
    private static final int MAX_ROW_COUNT = 25;
    private static final int MAX_CVLAN_ID = 4094;
    private ComboBoxRenderer comboRenderer = new ComboBoxRenderer();
    private JButton okButton;
    private JButton cancelButton;
    private UComboBox slotCB;
    private UComboBox portCB;
    private UComboBox domainCB;
    private JTextField vrangeTF = new JTextField();
    private sCVlanRange vr;
    private JTextField mpId = new JTextField();
    private NodeModelDelegate nodeModel;
    private XPL2ModuleModel module;
    private XPL2LineModel[] lineModels;
    XPL2MEPTableModel tableModel;

    public MEPCreateDialog(Frame frame, XPL2ModuleModel xPL2ModuleModel, XPL2MEPTableModel xPL2MEPTableModel) {
        super(frame, TITLE, true);
        this.lineModels = xPL2ModuleModel.getXPL2EtherLines();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MEPCreateDialog.this.dispose();
            }
        });
        this.module = xPL2ModuleModel;
        this.nodeModel = xPL2ModuleModel.getNodeModelDelegate();
        this.tableModel = xPL2MEPTableModel;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.createAttributesPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.apply()) {
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    private JPanel createAttributesPanel() {
        JPanel jPanel = new JPanel();
        this.slotCB = this.createSlotCombo();
        this.slotCB.setRenderer((ListCellRenderer)new MEPCardRenderer());
        this.portCB = new UComboBox((Object[])this.lineModels);
        this.portCB.setRenderer((ListCellRenderer)this.comboRenderer);
        Integer[] integerArray = new Integer[8];
        for (int i = 0; i < 8; ++i) {
            integerArray[i] = new Integer(i);
        }
        try {
            this.domainCB = new UComboBox((Object[])this.module.getMaintenanceDomains());
            this.domainCB.setRenderer((ListCellRenderer)this.comboRenderer);
        }
        catch (ProvisionError provisionError) {
            provisionError.printStackTrace();
        }
        this.slotCB.setEnabled(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.add(new JLabel(SLOT));
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(new JLabel(PORT));
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(new JLabel(DOMAIN));
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(new JLabel(VLAN_ID));
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(new JLabel(MPID));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel3.add((Component)this.slotCB);
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add((Component)this.portCB);
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add((Component)this.domainCB);
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add(this.vrangeTF);
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add(this.mpId);
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private UComboBox createSlotCombo() {
        ArrayList<XPL2ModuleModel> arrayList = new ArrayList<XPL2ModuleModel>(0);
        ArrayList<String> arrayList2 = new ArrayList<String>(0);
        TDMTerminology tDMTerminology = this.nodeModel.getTDMTerminology();
        arrayList.add(this.module);
        arrayList2.add(this.module.getSlot() + " (" + EntityModel.eqType2Name(tDMTerminology, this.module.getEqType()) + ")");
        Object[][] objectArray = new Object[arrayList.size()][2];
        for (int i = 0; i < arrayList.size(); ++i) {
            objectArray[i][0] = arrayList2.get(i);
            objectArray[i][1] = arrayList.get(i);
        }
        UComboBox uComboBox = new UComboBox((Object[])objectArray);
        uComboBox.setSelectedIndex(0);
        return uComboBox;
    }

    private boolean apply() {
        short s;
        short s2 = 0;
        short s3 = 0;
        String string = null;
        if (this.slotCB.getSelectedIndex() == -1) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"slot");
            this.slotCB.requestFocus();
            return false;
        }
        sMEP sMEP2 = new sMEP();
        if (this.portCB.getSelectedIndex() == -1) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"port");
            this.portCB.requestFocus();
            return false;
        }
        try {
            if (!this.vrangeTF.getText().equalsIgnoreCase("")) {
                s2 = Short.valueOf(this.vrangeTF.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            KDebug.printStackTrace((Throwable)numberFormatException);
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_INVALID_NUMBER_PARAM_1, (Object)"VLAN");
            return false;
        }
        if (!this.checkCVlanValue(s2)) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_ERROR_PROVISIONING_CVLAN_ID);
            return false;
        }
        if (!this.mpId.getText().equalsIgnoreCase("")) {
            s = Short.valueOf(this.mpId.getText());
            if (s < 1 || s > 8191) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_INVALID_MPID, (Object)"port");
                return false;
            }
        } else {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_INVALID_MPID, (Object)"port");
            return false;
        }
        s3 = s;
        Object[] objectArray = (Object[])this.slotCB.getSelectedItem();
        ModuleModel moduleModel = (ModuleModel)objectArray[1];
        XPL2LineModel xPL2LineModel = (XPL2LineModel)this.portCB.getSelectedItem();
        string = ((IDomainProfileInfo)this.domainCB.getSelectedItem()).getDomainName();
        MEPInfo mEPInfo = new MEPInfo(xPL2LineModel, string, s3, s2);
        try {
            xPL2LineModel.createMEP(mEPInfo);
        }
        catch (ProvisionError provisionError) {
            EID eID = provisionError.getEID();
            if (eID != null) {
                ErrorMsg.displayDetailed((Component)this, eID, (Exception)((Object)provisionError));
            }
            ErrorMsg.displayDetailed((Component)this, CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
        }
        try {
            this.tableModel.getDataSrc().refresh();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return true;
    }

    private boolean checkCVlanValue(short s) {
        return s > 0 && s < 4094;
    }

    private String getSlotPort(int n) {
        String string = "unknown";
        try {
            short s = this.nodeModel.getIfModels().getInterfaceModel(n).getSlotNum();
            int[] nArray = this.nodeModel.getIfModels().getInterfaceModel(n).getPort().getPortNum();
            if (s != -1 && nArray[0] != -1) {
                string = "s" + s + "/p" + nArray[0];
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return string;
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                this.setText("");
                return this;
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof XPL2LineModel) {
                XPL2LineModel xPL2LineModel = (XPL2LineModel)object;
                EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                try {
                    this.setText(entityCellRenderer.getPortString((IEntityModel)xPL2LineModel.getPort(), false));
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            } else if (object instanceof IDomainProfileInfo) {
                this.setText(((IDomainProfileInfo)object).getDomainName());
            }
            return this;
        }
    }

    class MEPCardRenderer
    extends JLabel
    implements ListCellRenderer {
        public MEPCardRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object[] objectArray = (Object[])object;
            StringBuffer stringBuffer = new StringBuffer();
            if (objectArray != null) {
                stringBuffer.append(((String)objectArray[0]).toString());
            }
            this.setText(stringBuffer.toString());
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

