/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sMEPStats;
import cerent.cms.idl.Vlan.sVlanRangeInfo;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2ModuleModel;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

public class XPL2CCDBStatsDataSource
extends AbstractRowDataSource
implements Observer {
    private ArrayList mepList = new ArrayList();
    XPL2ModuleModel moduleM = null;
    private static final SDebug db = new SDebug("XPL2MEPCCDBStatsDataSource");

    public XPL2CCDBStatsDataSource(ModuleModel moduleModel) {
        this.moduleM = (XPL2ModuleModel)moduleModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMEPList(String string, sVlanRangeInfo[] sVlanRangeInfoArray) throws NoSuchInterface, WrongInterfaceType {
        sMEPStats[] sMEPStatsArray = null;
        try {
            sMEPStatsArray = this.moduleM.getMEPStats(string, sVlanRangeInfoArray);
            this.mepList.clear();
            for (int i = 0; i < sMEPStatsArray.length; ++i) {
                this.mepList.add(sMEPStatsArray[i]);
            }
        }
        finally {
            this.fireDataSourceChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws NoSuchInterface, WrongInterfaceType {
        try {
            this.moduleM.clearMEPStats();
            this.mepList.clear();
        }
        finally {
            this.fireDataSourceChanged();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        Integer n = (Integer)object;
        if (object.equals(ModelUpdateType.CHANGED)) {
            if (XPL2CCDBStatsDataSource.db.on) {
                db.println("Receiving ModelUpdateType.CHANGE");
            }
        } else if (object.equals(ModelUpdateType.ADDED)) {
            if (XPL2CCDBStatsDataSource.db.on) {
                db.println("Receiving ModelUpdateType.ADDED");
            }
        } else if (object.equals(ModelUpdateType.DELETED) && XPL2CCDBStatsDataSource.db.on) {
            db.println("Receiving ModelUpdateType.DELETED");
        }
        this.fireDataSourceChanged();
    }

    public void refresh() {
        this.fireDataSourceChanged();
    }

    public int getRowCount() {
        return this.mepList.size();
    }

    public Object getObjectAtRow(int n) {
        return this.mepList.get(n);
    }

    public Collection getAllObjects() {
        return this.mepList;
    }

    public void dispose() {
        if (XPL2CCDBStatsDataSource.db.on) {
            db.println("Disposing XPL2MIPDataSrc");
        }
        try {
            this.mepList.clear();
            this.mepList = null;
        }
        catch (Exception exception) {
            db.finest("Exception in dispose() " + exception);
        }
    }
}

