/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Vlan.sVlanRangeInfo;
import cerent.cms.model.IDomainProfileInfo;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.XPL2MIPCCDBDataSource;
import cerent.cms.ui.xpl2.XPL2MIPCCDBTableModel;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.SvlanRange;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.VlanListPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2CFMCCDBMIPPane
extends AbstractPane
implements ActionListener {
    private XPL2MIPCCDBTableModel dataModel;
    private XPL2MIPCCDBDataSource dataSource;
    private boolean initialized = true;
    private int[] sortCols = new int[]{0};
    private boolean[] sortDir = new boolean[]{true};
    private static final SDebug db = new SDebug("XPL2CFMCCDBMIPPane");
    private XPL2ModuleModel moduleM;
    private ObservableManager _obsMgr;
    private static final String REFRESH = "Refresh";
    private static final String CLEAR = "Clear";
    private JButton refreshButton = new JButton("Refresh");
    private JButton clearButton = new JButton("Clear");
    private UComboBox domainCB = new UComboBox();
    protected VlanListPropertyEditor slistEditor;
    private ComboBoxRenderer comboRenderer = new ComboBoxRenderer();

    public XPL2CFMCCDBMIPPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.moduleM = (XPL2ModuleModel)this.getUiModel();
        this.init();
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    @Override
    protected void registerWithModel() {
        super.registerWithModel();
        this.getObsMgr().addObservable((Observable)((Object)this.moduleM));
    }

    protected void unRegisterWithModel() {
        super.registerWithModel();
        this.getObsMgr().removeObservable((Observable)((Object)this.moduleM));
    }

    @Override
    protected void refreshMyLines(Object object) {
        this.dataSource.refresh();
    }

    public void init() {
        if (db.on()) {
            db.println("init");
        }
        this.setLayout(new BorderLayout());
        this.dataSource = new XPL2MIPCCDBDataSource(this.moduleM);
        this.dataModel = new XPL2MIPCCDBTableModel(this.dataSource, this.sortCols, this.sortDir);
        this.table = new UTable((TableModel)((Object)this.dataModel));
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        ((XPL2MIPCCDBTableModel)((Object)this.table.getModel())).initTable(this.table);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.customizedProvPane();
        this.add(this.makeControlPanel(), "South");
        this.add((Component)uScrollPane, "Center");
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(4));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(5));
        tableColumn.setPreferredWidth(100);
        this.table.sizeColumnsToFit(-1);
    }

    private JPanel makeControlPanel() {
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.XPL2CFMCCDBMIPPane);
        cSHelpButtonPane.addLeft(new JLabel("Domain Level:"));
        cSHelpButtonPane.addLeft((Component)this.domainCB);
        this.domainCB.addItem(null);
        for (int i = 0; i < 8; ++i) {
            this.domainCB.addItem((Object)new Integer(i));
        }
        this.slistEditor = new VlanListPropertyEditor("SVLAN ID :", 14, true);
        cSHelpButtonPane.addLeft(this.slistEditor);
        cSHelpButtonPane.addLeft(this.refreshButton);
        this.refreshButton.addActionListener(this);
        cSHelpButtonPane.addLeft(this.clearButton);
        this.clearButton.addActionListener(this);
        return cSHelpButtonPane;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = 8;
        if (object == this.refreshButton) {
            Integer n2 = (Integer)this.domainCB.getSelectedItem();
            if (n2 != null) {
                n = n2;
            }
            sVlanRangeInfo[] sVlanRangeInfoArray = null;
            this.slistEditor.setText(this.slistEditor.getText());
            SvlanRange[] svlanRangeArray = this.slistEditor.getVlanList().getRanges();
            if (svlanRangeArray.length == 0) {
                sVlanRangeInfoArray = new sVlanRangeInfo[]{new sVlanRangeInfo()};
                sVlanRangeInfoArray[0].minVlanId = 0;
                sVlanRangeInfoArray[0].maxVlanId = 0;
            } else {
                sVlanRangeInfoArray = new sVlanRangeInfo[svlanRangeArray.length];
                for (int i = 0; i < svlanRangeArray.length; ++i) {
                    sVlanRangeInfoArray[i] = new sVlanRangeInfo();
                    sVlanRangeInfoArray[i].minVlanId = svlanRangeArray[i].low;
                    sVlanRangeInfoArray[i].maxVlanId = svlanRangeArray[i].high;
                }
            }
            try {
                this.dataSource.getMIPList(n, sVlanRangeInfoArray);
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        } else if (object == this.clearButton) {
            boolean bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)"Clear Command clears both the MEP and MIP CCDB.Do you want to continue?", (String)"Clear MEP/MEP CCDB");
            try {
                if (bl) {
                    this.dataSource.clear();
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
        if (this.dataSource != null) {
            this.dataSource.dispose();
            this.dataSource = null;
        }
    }

    @Override
    public void refresh() {
        this.domainCB.removeAllItems();
        this.domainCB.addItem(null);
        for (int i = 0; i < 8; ++i) {
            this.domainCB.addItem((Object)new Integer(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.dataSource == null) {
                this.init();
            }
            this.refresh();
            this.getObsMgr().setPassing(true);
            this.registerWithModel();
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.getObsMgr().setPassing(false);
        this.unRegisterWithModel();
    }

    public IDomainProfileInfo[] getDomains() {
        IDomainProfileInfo[] iDomainProfileInfoArray = null;
        try {
            iDomainProfileInfoArray = this.moduleM.getMaintenanceDomains();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return iDomainProfileInfoArray;
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                this.setText("");
                return this;
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof IDomainProfileInfo) {
                this.setText(((IDomainProfileInfo)object).getDomainName());
            }
            return this;
        }
    }
}

