/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.IDomainProfileInfo;
import cerent.cms.model.IMAProfileInfo;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.XPL2MappingDialog;
import cerent.cms.ui.xpl2.XPL2MappingTableModel;
import cerent.util.ComparisonUtil;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedProgressDialog;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.IDetailedProgressController;
import cerent.util.gui.IDetailedProgressDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class XPL2CFMMappingPane
extends AbstractPane
implements ActionListener,
ListSelectionListener {
    private XPL2MappingTableModel dataModel;
    private boolean initialized = true;
    private static final SDebug db = new SDebug("XPL2CFMMappingPane");
    private XPL2LineModel[] lineModels = null;
    private XPL2ModuleModel moduleM;
    private ObservableManager _obsMgr;
    private static final String LINK = "Link Profiles...";
    private static final String DELETE = "Delete...";
    private JButton linkButton = new JButton("Link Profiles...");
    private JButton deleteButton = new JButton("Delete...");
    private JLabel portLabel;
    private UComboBox domainCB;
    private ComboBoxRenderer comboRenderer = new ComboBoxRenderer();
    private GridBagPanel gbp = null;
    private CSHelpButton helpButton;

    public XPL2CFMMappingPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.moduleM = (XPL2ModuleModel)this.getUiModel();
        this.lineModels = this.moduleM.getXPL2EtherLines();
        this.init();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2CFMMappingPane;
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    @Override
    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        this.getObsMgr().addObservable((Observable)((Object)this.moduleM));
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    protected void unRegisterWithModel() {
        int n;
        super.registerWithModel();
        this.getObsMgr().removeObservable((Observable)((Object)this.moduleM));
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    @Override
    protected void refreshMyLines(Object object) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length != 0) {
            this.enableComponent(this.deleteButton, this.moduleM, SecurityLevel.PROVISIONING);
        } else {
            this.deleteButton.setEnabled(false);
        }
    }

    private void init() {
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.setLayout(new BorderLayout(5, 5));
        this.gbp = new GridBagPanel();
        this.gbp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.gbp.fillBoth();
        this.gbp.add((Component)this.createPortPane(), 0, 1);
        this.gbp.fillBoth();
        this.gbp.add((Component)this.createCVlanPane(), 1, 1);
        this.add((Component)new UScrollPane((Component)this.gbp));
        this.add(this.getButtonPanel(), "East");
    }

    private JPanel getButtonPanel() {
        Dimension dimension = new Dimension(75, 25);
        JPanel jPanel = XPL2CFMMappingPane.createVerticalPanel(null);
        if (this.getHelpID() != null) {
            this.helpButton = new CSHelpButton(this);
            this.helpButton.setMinimumSize(dimension);
            this.helpButton.setMaximumSize(dimension);
            jPanel.add(Box.createVerticalStrut(5));
            jPanel.add(this.helpButton);
        }
        return jPanel;
    }

    private JPanel createPortPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setPreferredSize(new Dimension(400, 200));
        jPanel.setBorder(BorderFactory.createTitledBorder("Select Domain"));
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        double[] dArray = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 1.0E-4};
        double[] dArray2 = new double[]{1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0E-4};
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = dArray;
        gridBagLayout.rowWeights = dArray2;
        this.portLabel = new JLabel("Domain: ");
        jPanel.add((Component)this.portLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.domainCB = new UComboBox();
        this.domainCB.setRenderer((ListCellRenderer)this.comboRenderer);
        UComboBox.setPreferredWidth((JComboBox)this.domainCB, (int)300);
        jPanel.add((Component)this.domainCB, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.domainCB.addActionListener((ActionListener)this);
        this.linkButton = new JButton("Link MA Profiles");
        this.linkButton.addActionListener(this);
        jPanel.add((Component)this.linkButton, new GridBagConstraints(1, 6, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createCVlanPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        double[] dArray = new double[]{11.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        double[] dArray2 = new double[]{1.0, 0.0, 0.0, 1.0E-4};
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = dArray;
        gridBagLayout.rowWeights = dArray2;
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setPreferredSize(new Dimension(400, 200));
        jPanel.setBorder(BorderFactory.createTitledBorder("MA Profiles"));
        this.dataModel = new XPL2MappingTableModel(this.moduleM, this.lineModels);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.customizedProvPane();
        jPanel.add((Component)uScrollPane, new GridBagConstraints(0, 0, 5, 2, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.deleteButton = new JButton("Delete MA Profile");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){
            boolean flag = true;

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n;
                TableColumnModel tableColumnModel = XPL2CFMMappingPane.this.table.getColumnModel();
                int n2 = tableColumnModel.getColumn(n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
                if (n2 < 0) {
                    return;
                }
                XPL2CFMMappingPane.this.sortAllRowsBy(XPL2CFMMappingPane.this.dataModel, n2 + 1, this.flag);
                this.flag = !this.flag;
            }
        });
        return jPanel;
    }

    public void sortAllRowsBy(AbstractTableModel abstractTableModel, int n, boolean bl) {
        ArrayList<IMAProfileInfo> arrayList = ((XPL2MappingTableModel)abstractTableModel).getMAProfileCurrentList();
        Collections.sort(arrayList, new ColumnSorter(n, bl));
        abstractTableModel.fireTableDataChanged();
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = XPL2CFMMappingPane.createHorizontalPanel(null);
        this.portLabel = new JLabel("Domain:");
        jPanel2.add(this.portLabel);
        this.domainCB = new UComboBox();
        this.domainCB.setRenderer((ListCellRenderer)this.comboRenderer);
        this.domainCB.addActionListener((ActionListener)this);
        jPanel2.add((Component)this.domainCB);
        jPanel.add((Component)jPanel2, "West");
        this.deleteButton.setEnabled(false);
        return jPanel;
    }

    private JPanel makeBottomPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = XPL2CFMMappingPane.createHorizontalPanel(null);
        this.linkButton.addActionListener(this);
        jPanel2.add(this.linkButton);
        this.deleteButton.addActionListener(this);
        jPanel2.add(this.deleteButton);
        jPanel.add((Component)jPanel2, "West");
        return jPanel;
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(100);
    }

    private ArrayList<IMAProfileInfo> populateLinkDialogList() throws ProvisionError {
        ArrayList<IMAProfileInfo> arrayList = new ArrayList<IMAProfileInfo>();
        ArrayList<IMAProfileInfo> arrayList2 = new ArrayList<IMAProfileInfo>();
        arrayList.addAll(Arrays.asList(this.moduleM.getAllMAProfiles()));
        ArrayList<IMAProfileInfo> arrayList3 = this.dataModel.getMAProfileCurrentList();
        for (int i = 0; i < arrayList.size(); ++i) {
            IMAProfileInfo iMAProfileInfo = (IMAProfileInfo)arrayList.get(i);
            if (arrayList3.contains(iMAProfileInfo)) continue;
            arrayList2.add(iMAProfileInfo);
        }
        return arrayList2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        ArrayList<IMAProfileInfo> arrayList = null;
        if (object == this.linkButton) {
            try {
                arrayList = this.populateLinkDialogList();
            }
            catch (ProvisionError provisionError) {
                SDebug.printStackTrace((Throwable)provisionError);
            }
            XPL2MappingDialog xPL2MappingDialog = new XPL2MappingDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), arrayList, this);
        } else if (object == this.deleteButton) {
            int[] nArray = this.table.getSelectedRows();
            if (nArray.length == 0) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"MA Profiles");
                return;
            }
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)"Do you really want to delete the selected MA Profiles ?", (String)"Delete MA Profile")) {
                return;
            }
            this.deleteRowAction(nArray);
        } else if (object == this.domainCB) {
            String string = ((IDomainProfileInfo)this.domainCB.getSelectedItem()).getDomainName();
            try {
                ArrayList<IMAProfileInfo> arrayList2 = new ArrayList<IMAProfileInfo>();
                arrayList2.addAll(Arrays.asList(this.moduleM.getMAFromDomain(string)));
                this.dataModel.setData(new ArrayList<IMAProfileInfo>(arrayList2));
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (ProvisionError provisionError) {
                SDebug.printStackTrace((Throwable)provisionError);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        } else if (object == this.helpButton) {
            this.helpButton.launchHelp(this.getHelpID());
        }
    }

    public void deleteRowAction(int[] nArray) {
        String string = ((IDomainProfileInfo)this.domainCB.getSelectedItem()).getDomainName();
        String string2 = "detached";
        DetailedLog detailedLog = new DetailedLog(3, "The MA Profile was not " + string2);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            String string3;
            IMAProfileInfo iMAProfileInfo = this.dataModel.getObjectAt(nArray[i] - i);
            try {
                this.moduleM.detachMAProfile(string, iMAProfileInfo);
                this.dataModel.deleteMAProfileTableRow(nArray[i] - i);
            }
            catch (ProvisionError provisionError) {
                ++n;
                string2 = "detaching";
                string3 = null;
                if (provisionError instanceof ProvisionError && provisionError.getEID() != null) {
                    string3 = provisionError.getEID().getMessage();
                }
                DetailedLog detailedLog2 = new DetailedLog(3, "an error occurred while " + string2 + " the MA Profile " + iMAProfileInfo.getMAName() + " from the Domain. " + (string3 != null ? "Reason = " + string3 : ""), (Exception)((Object)provisionError));
                detailedLog.addChild(detailedLog2);
                detailedLog.updateTime();
            }
            if (n <= 0) continue;
            IDetailedProgressController iDetailedProgressController = new IDetailedProgressController(){

                public void start(IDetailedProgressDialog iDetailedProgressDialog) {
                }

                public boolean isCancelSupported() {
                    return false;
                }

                public void cancel() {
                }
            };
            string3 = new DetailedProgressDialog(JOptionPane.getFrameForComponent(this.getParent()), "Error", detailedLog, iDetailedProgressController);
            string3.setCompleted(true);
            string3.start();
        }
    }

    public void linkProfiles(IMAProfileInfo[] iMAProfileInfoArray) {
        String string;
        String string2 = "attached";
        DetailedLog detailedLog = new DetailedLog(3, "The MA Profile was not " + string2);
        int n = 0;
        for (int i = 0; i < iMAProfileInfoArray.length; ++i) {
            string = ((IDomainProfileInfo)this.domainCB.getSelectedItem()).getDomainName();
            try {
                this.moduleM.attachMAProfile(string, iMAProfileInfoArray[i]);
                this.dataModel.addMAProfileTableRow(iMAProfileInfoArray[i]);
                continue;
            }
            catch (ProvisionError provisionError) {
                ++n;
                string2 = "attaching";
                String string3 = null;
                if (provisionError instanceof ProvisionError && provisionError.getEID() != null) {
                    string3 = provisionError.getEID().getMessage();
                }
                DetailedLog detailedLog2 = new DetailedLog(3, "an error occurred while " + string2 + " the MA Profile " + iMAProfileInfoArray[i].getMAName() + " to the Domain. " + (string3 != null ? "Reason = " + string3 : ""), (Exception)((Object)provisionError));
                detailedLog.addChild(detailedLog2);
                detailedLog.updateTime();
            }
        }
        if (n > 0) {
            IDetailedProgressController iDetailedProgressController = new IDetailedProgressController(){

                public void start(IDetailedProgressDialog iDetailedProgressDialog) {
                }

                public boolean isCancelSupported() {
                    return false;
                }

                public void cancel() {
                }
            };
            string = new DetailedProgressDialog(JOptionPane.getFrameForComponent(this.getParent()), "Error", detailedLog, iDetailedProgressController);
            string.setCompleted(true);
            string.start();
        }
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void refresh() {
        this.domainCB.removeActionListener((ActionListener)this);
        this.domainCB.removeAllItems();
        IDomainProfileInfo[] iDomainProfileInfoArray = this.getDomains();
        for (int i = 0; i < iDomainProfileInfoArray.length; ++i) {
            this.domainCB.addItem((Object)iDomainProfileInfoArray[i]);
        }
        this.domainCB.addActionListener((ActionListener)this);
        if (this.domainCB.getItemCount() != 0) {
            this.domainCB.setEnabled(true);
            this.domainCB.setSelectedIndex(0);
            this.linkButton.setEnabled(true);
        } else {
            this.domainCB.setEnabled(false);
            this.linkButton.setEnabled(false);
            this.dataModel.setData(new ArrayList<IMAProfileInfo>());
            this.dataModel.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            this.refresh();
            this.getObsMgr().setPassing(true);
            this.registerWithModel();
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    public IDomainProfileInfo[] getDomains() {
        IDomainProfileInfo[] iDomainProfileInfoArray = null;
        try {
            iDomainProfileInfoArray = this.moduleM.getMaintenanceDomains();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return iDomainProfileInfoArray;
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.getObsMgr().setPassing(false);
        this.unRegisterWithModel();
    }

    class ColumnSorter
    implements Comparator {
        int colIndex;
        boolean ascending;

        ColumnSorter(int n, boolean bl) {
            this.colIndex = n;
            this.ascending = bl;
        }

        public int compare(Object object, Object object2) {
            IMAProfileInfo iMAProfileInfo = (IMAProfileInfo)object;
            IMAProfileInfo iMAProfileInfo2 = (IMAProfileInfo)object2;
            if (iMAProfileInfo == null && iMAProfileInfo2 == null) {
                return 0;
            }
            if (iMAProfileInfo == null) {
                return 1;
            }
            if (iMAProfileInfo2 == null) {
                return -1;
            }
            if (iMAProfileInfo instanceof Comparable) {
                if (this.ascending) {
                    if (this.colIndex == 1) {
                        String string = iMAProfileInfo.getMAName();
                        String string2 = iMAProfileInfo2.getMAName();
                        return string.compareTo(string2);
                    }
                    if (this.colIndex == 2) {
                        short s = iMAProfileInfo.getVlanId();
                        short s2 = iMAProfileInfo2.getVlanId();
                        return ComparisonUtil.compare((long)s, (long)s2);
                    }
                    return ((Comparable)iMAProfileInfo).compareTo(iMAProfileInfo2);
                }
                if (this.colIndex == 1) {
                    String string = iMAProfileInfo.getMAName();
                    String string3 = iMAProfileInfo2.getMAName();
                    return string3.compareTo(string);
                }
                if (this.colIndex == 2) {
                    short s = iMAProfileInfo.getVlanId();
                    short s3 = iMAProfileInfo2.getVlanId();
                    return ComparisonUtil.compare((long)s3, (long)s);
                }
                return ((Comparable)iMAProfileInfo2).compareTo(iMAProfileInfo);
            }
            if (this.ascending) {
                return iMAProfileInfo.toString().compareTo(iMAProfileInfo2.toString());
            }
            return iMAProfileInfo2.toString().compareTo(iMAProfileInfo.toString());
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                this.setText("");
                return this;
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof IDomainProfileInfo) {
                this.setText(((IDomainProfileInfo)object).getDomainName());
            }
            return this;
        }
    }
}

