/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sEtherMacAddr;
import cerent.cms.idl.EtherL2Media.eCfmCmdType;
import cerent.cms.idl.EtherL2Media.sCfmCmdReqInfo;
import cerent.cms.idl.EtherL2Media.sCfmCmdRspInfo;
import cerent.cms.model.CFMCommandFailed;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.MacAddrFormat;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class XPL2CFMPingProvPane
extends AbstractPane
implements ActionListener {
    private XPL2ModuleModel module;
    NodeModelDelegate nmd;
    JButton ping = new JButton("Ping");
    JButton cancel = new JButton("Cancel");
    JButton clear = new JButton("Clear");
    private CSHelpButton helpButton;
    JTextField mpId;
    private JTextField macTF;
    JTextField dSize;
    JTextField dName;
    JTextField vlanId;
    JTextField noOfReqs;
    JTextArea pResponse;
    private static final Dimension ROW_SIZE = new Dimension(TabbedView.TABBED_VIEW_DIM.width, 25);
    private static final Dimension tabSize = new Dimension(TabbedView.TABBED_VIEW_DIM.width, 250);
    private JLabel mpIdLB;
    private JLabel reqLB;
    private JLabel dSizeLB;
    private JLabel macLB;
    private JLabel domainLB;
    private int id = -1;
    private boolean pingOn = false;

    public XPL2CFMPingProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.module = (XPL2ModuleModel)this.getUiModel();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        uScrollPane.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.add((Component)uScrollPane, "West");
        Dimension dimension = new Dimension(XPL2CFMPingProvPane.ROW_SIZE.width, 400);
        jPanel.setPreferredSize(dimension);
        jPanel.setMaximumSize(dimension);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = XPL2CFMPingProvPane.createHorizontalPanel(null);
        JPanel jPanel3 = new JPanel();
        jPanel3.setPreferredSize(dimension);
        jPanel3.setMaximumSize(dimension);
        jPanel3.setLayout(new FlowLayout(0, 0, 0));
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel4.add(Box.createVerticalStrut(40));
        this.mpId = this.addTextPanel(jPanel4, this.createLabel(" MPID: "), 13);
        this.macLB = new JLabel(" Mac Addr: ");
        jPanel4.add(Box.createHorizontalStrut(20));
        this.macTF = this.addTextPanel(jPanel4, this.macLB, 13);
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel4.add(Box.createRigidArea(new Dimension(100, 20)));
        jPanel3.add(jPanel4);
        jPanel4 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel4.add(Box.createVerticalStrut(30));
        this.vlanId = this.addTextPanel(jPanel4, this.createLabel(" VLAN ID: "), 13);
        jPanel4.add(Box.createHorizontalStrut(20));
        this.domainLB = new JLabel(" Domain Name: ");
        this.dName = this.addTextPanel(jPanel4, this.domainLB, 13);
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel4.add(Box.createRigidArea(new Dimension(100, 20)));
        jPanel3.add(jPanel4);
        jPanel4 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel4.add(Box.createVerticalStrut(30));
        this.dSize = this.addTextPanel(jPanel4, this.createLabel(" DataGram Size: "), 13);
        jPanel4.add(Box.createHorizontalStrut(20));
        this.reqLB = new JLabel(" No of Requests: ");
        this.noOfReqs = this.addTextPanel(jPanel4, this.reqLB, 13);
        this.noOfReqs.setText("5");
        this.dSize.setText("100");
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel4.add(Box.createRigidArea(new Dimension(100, 20)));
        jPanel3.add(jPanel4);
        jPanel2.add(jPanel3);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2 = XPL2CFMPingProvPane.createHorizontalPanel(null);
        jPanel4 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel4.setBorder(BorderFactory.createTitledBorder("Ping Response"));
        this.pResponse = new JTextArea(10, 50);
        UScrollPane uScrollPane2 = new UScrollPane((Component)this.pResponse, 20, 30);
        jPanel4.add((Component)uScrollPane2);
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel4.add(Box.createRigidArea(new Dimension(100, 20)));
        jPanel3.add(jPanel4);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2 = XPL2CFMPingProvPane.createHorizontalPanel(null);
        jPanel4 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel4.add(this.ping);
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel4.add(this.cancel);
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel4.add(this.clear);
        jPanel4.add(Box.createHorizontalStrut(5));
        Dimension dimension2 = new Dimension(75, 25);
        if (this.getHelpID() != null) {
            this.helpButton = new CSHelpButton(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    XPL2CFMPingProvPane.this.helpButton.launchHelp(XPL2CFMPingProvPane.this.getHelpID());
                }
            });
            this.helpButton.setMinimumSize(dimension2);
            this.helpButton.setMaximumSize(dimension2);
            jPanel4.add(this.helpButton);
        }
        jPanel4.add(Box.createRigidArea(new Dimension(100, 20)));
        jPanel3.add(jPanel4);
        this.ping.addActionListener(this);
        this.clear.addActionListener(this);
        this.cancel.addActionListener(this);
        this.cancel.setEnabled(false);
        jPanel2.setAlignmentX(0.5f);
        jPanel.add(jPanel2);
        jPanel3.setAlignmentX(0.0f);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.nmd = (NodeModelDelegate)this.module.getNodeModel().getDelegate();
        this.nmd.getConnectionNotifier().addObserver((Observer)((Object)this));
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(140, 20));
        return jLabel;
    }

    private JTextField addTextPanel(JPanel jPanel, JLabel jLabel, int n) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        if (jLabel != null) {
            jPanel2.add(jLabel);
        }
        JTextField jTextField = new JTextField(n);
        jTextField.setMaximumSize(jTextField.getPreferredSize());
        jPanel2.add(jTextField);
        jPanel.add(jPanel2);
        return jTextField;
    }

    private JPanel createEditPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 3));
        jPanel2.add(this.mpId);
        jPanel2.add(this.dSize);
        jPanel2.add(this.dName);
        jPanel2.add(this.vlanId);
        jPanel2.add(this.noOfReqs);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        return jPanel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        long l = 0L;
        if (actionEvent.getSource() == this.ping) {
            try {
                this.id = (Integer)this.module.getIdForCommand();
            }
            catch (ProvisionError provisionError) {
                SDebug.printStackTrace((Throwable)provisionError);
                EID eID = provisionError.getEID();
                if (eID != null) {
                    ErrorMsg.displayDetailed((Component)((Object)this), eID, (Exception)((Object)provisionError));
                } else {
                    ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
                }
            }
            catch (NoSuchEquipment noSuchEquipment) {
                SDebug.printStackTrace((Throwable)noSuchEquipment);
            }
            if (this.id <= 0) return;
            try {
                if (!this.macTF.getText().equalsIgnoreCase("")) {
                    if (!this.mpId.getText().equalsIgnoreCase("")) {
                        ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CFM_MPID_MAC_PRESENT);
                        return;
                    }
                    l = MacAddrFormat.parseMacAddr(this.macTF.getText());
                } else {
                    l = 0L;
                }
            }
            catch (ParseException parseException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MAC_FORMAT_ERROR);
                return;
            }
            sCfmCmdReqInfo sCfmCmdReqInfo2 = new sCfmCmdReqInfo();
            sCfmCmdReqInfo2.cmdId = (short)this.id;
            sCfmCmdReqInfo2.cmdType = eCfmCmdType.PING;
            sEtherMacAddr sEtherMacAddr2 = new sEtherMacAddr();
            byte[] byArray = MacAddrFormat.toBytes(l);
            sEtherMacAddr2.addr = byArray;
            sCfmCmdReqInfo2.macAddr = sEtherMacAddr2;
            if (!this.mpId.getText().equalsIgnoreCase("")) {
                if (!this.macTF.getText().equalsIgnoreCase("")) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CFM_MPID_MAC_PRESENT);
                    return;
                }
                try {
                    sCfmCmdReqInfo2.mpId = Short.parseShort(this.mpId.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_NUMBER_PARAM_1, (Object)"MPID");
                    this.mpId.setText("");
                    return;
                }
            } else if (l == 0L) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_MPID);
                sCfmCmdReqInfo2.mpId = 0;
                return;
            }
            if (this.vlanId.getText().equalsIgnoreCase("")) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_VLAN_OUT_OF_RANGE);
                sCfmCmdReqInfo2.sVlan = 0;
                return;
            }
            try {
                sCfmCmdReqInfo2.sVlan = Short.parseShort(this.vlanId.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_NUMBER_PARAM_1, (Object)"Vlan");
                this.vlanId.setText("");
                return;
            }
            sCfmCmdReqInfo2.domainName = this.dName.getText();
            if (this.dName.getText().equalsIgnoreCase("")) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CFM_DOMAIN_NOT_NULL);
                return;
            }
            sCfmCmdReqInfo2.domainName = this.dName.getText();
            if (!this.dSize.getText().equalsIgnoreCase("")) {
                try {
                    sCfmCmdReqInfo2.datagramSize = Integer.parseInt(this.dSize.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_NUMBER_PARAM_1, (Object)"Datagram Size");
                    this.dSize.setText("");
                    return;
                }
            } else {
                sCfmCmdReqInfo2.datagramSize = 0;
            }
            if (!this.noOfReqs.getText().equalsIgnoreCase("")) {
                try {
                    sCfmCmdReqInfo2.numOfRequest = Short.parseShort(this.noOfReqs.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_NUMBER_PARAM_1, (Object)"No Of Requests");
                    this.noOfReqs.setText("");
                    return;
                }
            } else {
                sCfmCmdReqInfo2.numOfRequest = 0;
            }
            if (!this.validateValues(sCfmCmdReqInfo2)) {
                return;
            }
            ((NodeModelDelegate)this.module.getNodeModel().getDelegate()).getDispatcher().addObserver(ObjectType.ObjectCFMCommand, this.id, (Observer)((Object)this));
            try {
                this.module.setCFMCommand(sCfmCmdReqInfo2);
                this.ping.setEnabled(false);
                this.pingOn = true;
                this.cancel.setEnabled(true);
                return;
            }
            catch (ProvisionError provisionError) {
                SDebug.printStackTrace((Throwable)provisionError);
                EID eID = provisionError.getEID();
                if (eID != null) {
                    ErrorMsg.displayDetailed((Component)((Object)this), eID, (Exception)((Object)provisionError));
                } else {
                    ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
                }
                this.pingOn = false;
                this.ping.setEnabled(true);
                this.cancel.setEnabled(false);
                ((NodeModelDelegate)this.module.getNodeModel().getDelegate()).getDispatcher().deleteObserver(ObjectType.ObjectCFMCommand, this.id, (Observer)((Object)this));
                return;
            }
            catch (NoSuchEquipment noSuchEquipment) {
                SDebug.printStackTrace((Throwable)noSuchEquipment);
                this.pingOn = false;
                this.ping.setEnabled(true);
                this.cancel.setEnabled(false);
                ((NodeModelDelegate)this.module.getNodeModel().getDelegate()).getDispatcher().deleteObserver(ObjectType.ObjectCFMCommand, this.id, (Observer)((Object)this));
                return;
            }
            catch (CFMCommandFailed cFMCommandFailed) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_CFM_COMMAND_FAIL, (Exception)((Object)cFMCommandFailed.getUserException()));
                this.pingOn = false;
                this.ping.setEnabled(true);
                this.cancel.setEnabled(false);
                ((NodeModelDelegate)this.module.getNodeModel().getDelegate()).getDispatcher().deleteObserver(ObjectType.ObjectCFMCommand, this.id, (Observer)((Object)this));
                return;
            }
        }
        if (actionEvent.getSource() == this.cancel) {
            this.cancel();
            return;
        }
        if (actionEvent.getSource() != this.clear) return;
        this.pResponse.setText("");
    }

    private boolean validateValues(sCfmCmdReqInfo sCfmCmdReqInfo2) {
        if ((sCfmCmdReqInfo2.mpId < 1 || sCfmCmdReqInfo2.mpId > 8191) && sCfmCmdReqInfo2.mpId != 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_MPID);
            return false;
        }
        if (sCfmCmdReqInfo2.sVlan < 1 || sCfmCmdReqInfo2.sVlan > 4094) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_VLAN_OUT_OF_RANGE);
            return false;
        }
        if (sCfmCmdReqInfo2.domainName == null || sCfmCmdReqInfo2.domainName.length() > 43) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CFM_DOMAIN_LENGTH_ERROR);
            return false;
        }
        if (sCfmCmdReqInfo2.datagramSize < 64 || sCfmCmdReqInfo2.datagramSize > 1500) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CFM_DSIZE_ERROR);
            return false;
        }
        if (sCfmCmdReqInfo2.numOfRequest < 1 || sCfmCmdReqInfo2.numOfRequest > 1000) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CFM_NO_OF_REQ_ERROR);
            return false;
        }
        return true;
    }

    @Override
    public void refresh() throws Exception {
    }

    public boolean onValidate() {
        return true;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update from " + observable + "arg obj is " + object + " class=" + this.getClass());
        }
        if (this.nmd == null) {
            return;
        }
        db.println("update( " + object + " ) from " + observable);
        if (observable instanceof NodeModelDelegate.ConnectionNotifier) {
            if (!(object != ModelUpdateType.CHANGED || this.nmd.isInited() && this.nmd.getConnectionState() || !this.pingOn)) {
                this.cancel();
                this.pingOn = false;
            }
        } else if (observable instanceof NodeModelDelegate) {
            if (object == ModelUpdateType.DELETED) {
                db.println("Got a DELETED event");
            }
        } else if (object instanceof ObjectMessageInfo) {
            sCfmCmdRspInfo sCfmCmdRspInfo2 = null;
            if (this.pingOn) {
                try {
                    if (((ObjectMessageInfo)object).getUpdateType() == 5) {
                        this.pingOn = false;
                        this.ping.setEnabled(true);
                        this.cancel.setEnabled(false);
                        ((NodeModelDelegate)this.module.getNodeModel().getDelegate()).getDispatcher().deleteObserver(ObjectType.ObjectCFMCommand, this.id, (Observer)((Object)this));
                    } else {
                        sCfmCmdRspInfo2 = this.module.getCFMCommandRsp(this.id);
                    }
                }
                catch (ProvisionError provisionError) {
                    SDebug.printStackTrace((Throwable)provisionError);
                    EID eID = provisionError.getEID();
                    if (eID != null) {
                        ErrorMsg.displayDetailed((Component)((Object)this), eID, (Exception)((Object)provisionError));
                    } else {
                        ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
                    }
                    ((NodeModelDelegate)this.module.getNodeModel().getDelegate()).getDispatcher().deleteObserver(ObjectType.ObjectCFMCommand, this.id, (Observer)((Object)this));
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    SDebug.printStackTrace((Throwable)noSuchEquipment);
                    ((NodeModelDelegate)this.module.getNodeModel().getDelegate()).getDispatcher().deleteObserver(ObjectType.ObjectCFMCommand, this.id, (Observer)((Object)this));
                }
                if (sCfmCmdRspInfo2 != null) {
                    this.pResponse.setText(sCfmCmdRspInfo2.response);
                } else if (db.on()) {
                    db.println("Response was null string");
                }
            }
        }
    }

    @Override
    public void dispose() {
        if (this.pingOn) {
            this.cancel();
            this.pingOn = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        try {
            this.module.cancelCFMCommand();
            this.pingOn = false;
        }
        catch (ProvisionError provisionError) {
            this.pingOn = false;
            this.ping.setEnabled(true);
            this.cancel.setEnabled(false);
            SDebug.printStackTrace((Throwable)provisionError);
        }
        finally {
            ((NodeModelDelegate)this.module.getNodeModel().getDelegate()).getDispatcher().deleteObserver(ObjectType.ObjectCFMCommand, this.id, (Observer)((Object)this));
        }
        if (!this.pingOn) {
            this.ping.setEnabled(true);
            this.cancel.setEnabled(false);
        }
    }

    @Override
    public void leavingPage() throws Exception {
    }

    @Override
    public void enteringPage() throws Exception {
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2CFMPingProvPane;
    }
}

