/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.XPL2ModuleModel;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class XPL2CardMacAddrTableModel
extends AbstractTableModel {
    private final XPL2ModuleModel _module;
    private String[] _keys;
    private String[] _vals;
    private static final String[] _columnNames = new String[]{"Port", "MAC Address"};
    private static final TreeMap ports = new TreeMap(Collator.getInstance());

    public XPL2CardMacAddrTableModel(XPL2ModuleModel xPL2ModuleModel) {
        this._module = xPL2ModuleModel;
        this.fetchValues();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this._keys.length;
    }

    @Override
    public int getColumnCount() {
        return _columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return _columnNames[n];
    }

    private String getKey(int n) {
        String string = (String)ports.get(this._keys[n]);
        if (string == null) {
            string = this._keys[n];
        }
        return string;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.getKey(n);
            }
            case 1: {
                return this._vals[n];
            }
        }
        return null;
    }

    private void fetchValues() {
        TreeMap treeMap = new TreeMap();
        treeMap.putAll(this._module.getExtraInfoMap());
        this.removeNotPortValues(treeMap);
        this._keys = new String[treeMap.size()];
        this._vals = new String[treeMap.size()];
        Iterator iterator = treeMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this._keys[n] = (String)iterator.next();
            this._vals[n] = (String)treeMap.get(this._keys[n]);
            ++n;
        }
    }

    public void refreshFromModel() {
        int n = this.getRowCount();
        this.fetchValues();
        int n2 = this.getRowCount();
        if (n < n2) {
            this.fireTableRowsInserted(n, n2 - 1);
        } else if (n > n2) {
            this.fireTableRowsDeleted(n2, n - 1);
        }
        this.fireTableRowsUpdated(0, this._keys.length - 1);
    }

    public void dispose() {
        this._keys = null;
        this._vals = null;
    }

    public void removeNotPortValues(TreeMap treeMap) {
        Set set = treeMap.keySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : set) {
            if (string.toUpperCase().contains("PORT")) continue;
            arrayList.add(string);
        }
        for (String string : arrayList) {
            treeMap.remove(string);
        }
    }

    static {
        ports.put("PORT_0", "Port 1");
        ports.put("PORT_1", "Port 2");
        ports.put("PORT_2", "Port 3");
        ports.put("PORT_3", "Port 4");
        ports.put("PORT_4", "Port 5");
        ports.put("PORT_5", "Port 6");
        ports.put("PORT_6", "Port 7");
        ports.put("PORT_7", "Port 8");
        ports.put("PORT_8", "Port 9");
        ports.put("PORT_9", "Port 10");
        ports.put("PORT_10", "Port 11");
        ports.put("PORT_11", "Port 12");
        ports.put("PORT_12", "Port 13");
        ports.put("PORT_13", "Port 14");
        ports.put("PORT_14", "Port 15");
        ports.put("PORT_15", "Port 16");
        ports.put("PORT_16", "Port 17");
        ports.put("PORT_17", "Port 18");
        ports.put("PORT_18", "Port 19");
        ports.put("PORT_19", "Port 20");
        ports.put("PORT_20", "Port 21");
        ports.put("PORT_21", "Port 22");
        ports.put("CPU_PORT", "CPU Port");
    }
}

