/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.EtherL2Media.eHashingMode;
import cerent.cms.idl.EtherL2Media.eLacpMode;
import cerent.cms.idl.EtherL2Media.sChannelGroupAttributes;
import cerent.cms.idl.EtherL2Media.sChannelGroupInfo;
import cerent.cms.idl.EtherMedia.sIngressQOSInfo;
import cerent.cms.idl.EtherMedia.sL1Info;
import cerent.cms.idl.If.sIfAttributes;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InterfaceModels;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.XPL2ChannelGroupModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class XPL2ChannelGroupCreationDlg
extends JDialog
implements ActionListener,
ListSelectionListener {
    JLabel chGroupIDLB;
    JComboBox chGroupIDCB;
    JLabel chGroupNameLB;
    JTextField chGroupNameTF;
    JList srcPortsList;
    SortedListModel srcPortListModel;
    JList dstPortsList;
    SortedListModel dstPortListModel;
    JButton addPortsBT;
    JButton removePortsBT;
    JLabel lacpModeLB;
    JComboBox lacpModeCB;
    JLabel lacpHashLB;
    JComboBox lacpHashCB;
    JButton okBT;
    JButton cancelBT;
    XPL2ModuleModel card;
    Frame parent;
    XPL2ChannelGroupModel[] chGroups;
    int selectedChGr = -1;
    boolean isCancelled = false;
    boolean isAddRemoveOnlyFashion;
    private static final SDebug db = new SDebug("XPL2ChannelGroupCreationDialog");

    public XPL2ChannelGroupCreationDlg(Frame frame, XPL2ModuleModel xPL2ModuleModel, XPL2ChannelGroupModel[] xPL2ChannelGroupModelArray, int n) {
        super(frame, true);
        this.card = xPL2ModuleModel;
        this.parent = frame;
        this.chGroups = xPL2ChannelGroupModelArray;
        this.isAddRemoveOnlyFashion = n != -1;
        this.selectedChGr = n;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XPL2ChannelGroupCreationDlg.this.isCancelled = true;
            }
        });
        this.init();
    }

    private void init() {
        JPanel jPanel;
        JPanel jPanel2;
        CSHelpID cSHelpID;
        int[] nArray;
        Dimension dimension;
        String string;
        String string2;
        if (this.isAddRemoveOnlyFashion) {
            string2 = "Add/Remove Ports";
            string = "Apply";
            dimension = new Dimension(350, 320);
            nArray = this.chGroups[this.selectedChGr].getPortList();
            cSHelpID = CSHelpConst.XPL2ChannelGroupsAddPortsDialog;
        } else {
            string2 = "Channel Group Creation";
            string = "Create";
            dimension = new Dimension(350, 470);
            nArray = new int[]{};
            cSHelpID = CSHelpConst.XPL2ChannelGroupsCreateDialog;
        }
        this.setTitle(string2);
        this.setResizable(false);
        this.setPreferredSize(dimension);
        this.setLocationRelativeTo(this.parent);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        if (!this.isAddRemoveOnlyFashion) {
            jPanel2 = new JPanel(new FlowLayout(0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            this.chGroupNameLB = new JLabel("Name: ");
            jPanel2.add(this.chGroupNameLB);
            this.chGroupNameTF = new JTextField("");
            this.chGroupNameTF.setPreferredSize(new Dimension(100, 20));
            jPanel2.add(this.chGroupNameTF);
            jPanel2.add(Box.createRigidArea(new Dimension(40, 10)));
            this.chGroupIDLB = new JLabel("ID: ");
            jPanel2.add(this.chGroupIDLB);
            this.chGroupIDCB = new JComboBox<Integer>(new DefaultComboBoxModel<Integer>(this.getChGroupIds()));
            jPanel2.add(this.chGroupIDCB);
            container.add((Component)jPanel2, "West");
        }
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setPreferredSize(new Dimension(230, 220));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder("Ports")));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(Box.createRigidArea(new Dimension(17, 0)));
        JLabel jLabel = new JLabel("Stand Alone");
        JLabel jLabel2 = new JLabel("Bundled");
        jPanel3.add(jLabel);
        jPanel3.add(Box.createRigidArea(new Dimension(110, 0)));
        jPanel3.add(jLabel2);
        JPanel jPanel4 = new JPanel(new FlowLayout());
        PortListCellRenderer portListCellRenderer = new PortListCellRenderer();
        this.srcPortListModel = new SortedListModel();
        this.fillSrcPortList(nArray);
        this.srcPortsList = new JList(this.srcPortListModel);
        this.srcPortsList.setCellRenderer(portListCellRenderer);
        this.srcPortsList.setSelectionMode(2);
        this.srcPortsList.addListSelectionListener(this);
        this.srcPortsList.setVisibleRowCount(-1);
        JScrollPane jScrollPane = new JScrollPane(this.srcPortsList);
        jScrollPane.setPreferredSize(new Dimension(110, 150));
        this.dstPortListModel = new SortedListModel();
        this.fillDstPortList(nArray);
        this.dstPortsList = new JList(this.dstPortListModel);
        this.dstPortsList.setCellRenderer(portListCellRenderer);
        this.dstPortsList.setSelectionMode(2);
        this.dstPortsList.addListSelectionListener(this);
        this.dstPortsList.setVisibleRowCount(-1);
        JScrollPane jScrollPane2 = new JScrollPane(this.dstPortsList);
        jScrollPane2.setPreferredSize(new Dimension(110, 150));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.addPortsBT = new JButton(">>");
        this.addPortsBT.addActionListener(this);
        this.addPortsBT.setEnabled(false);
        this.removePortsBT = new JButton("<<");
        this.removePortsBT.addActionListener(this);
        this.removePortsBT.setEnabled(false);
        jPanel5.add(this.addPortsBT);
        jPanel5.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel5.add(this.removePortsBT);
        jPanel4.add(jScrollPane);
        jPanel4.add(jPanel5);
        jPanel4.add(jScrollPane2);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        container.add(jPanel2);
        if (!this.isAddRemoveOnlyFashion) {
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            this.lacpModeLB = new JLabel("LACP Mode: ");
            jPanel.add(this.lacpModeLB);
            this.lacpModeCB = new JComboBox<Attribute>(this.getAttributeArray("LacpMode"));
            jPanel.add(this.lacpModeCB);
            container.add((Component)jPanel, "West");
            JPanel jPanel6 = new JPanel(new FlowLayout(0));
            jPanel6.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            this.lacpHashLB = new JLabel("LACP Hashing: ");
            jPanel6.add(this.lacpHashLB);
            this.lacpHashCB = new JComboBox<Attribute>(this.getAttributeArray("LacpHashingMode"));
            this.lacpHashCB.setSelectedIndex(2);
            jPanel6.add(this.lacpHashCB);
            container.add((Component)jPanel6, "West");
        }
        jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 0, 10, 0));
        this.okBT = new JButton(string);
        jPanel.add(this.okBT);
        this.okBT.addActionListener(this);
        this.cancelBT = new JButton("Cancel");
        jPanel.add(this.cancelBT);
        this.cancelBT.addActionListener(this);
        jPanel.add(new CSHelpButton(cSHelpID));
        container.add(jPanel);
        this.pack();
    }

    private Integer[] getChGroupIds() {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 0; n < this.chGroups.length; ++n) {
            arrayList2.add(this.chGroups[n].getChGroupID());
        }
        n = this.card.getEqType() == 271 ? 2 : 11;
        for (int i = 0; i < n; ++i) {
            arrayList.add(i + 1);
        }
        arrayList.removeAll(arrayList2);
        return arrayList.toArray(new Integer[0]);
    }

    private void fillSrcPortList(int[] nArray) {
        ArrayList arrayList;
        ArrayList<IEntityModel> arrayList2 = new ArrayList<IEntityModel>();
        arrayList2.addAll(this.getPortEntityList(nArray));
        ArrayList<IEntityModel> arrayList3 = new ArrayList<IEntityModel>();
        for (int i = 0; i < this.chGroups.length; ++i) {
            arrayList3.addAll(this.getPortEntityList(this.chGroups[i].getPortList()));
        }
        ArrayList arrayList4 = new ArrayList();
        if (!arrayList2.isEmpty()) {
            int n = ((IEntityModel)arrayList2.get(0)).getEqType();
            arrayList = (ArrayList)this.card.getDescendantsOfType(eEqType.from_int(n));
        } else {
            arrayList = (ArrayList)this.card.getDescendantsOfType(eEqType.ONE_GE_PORT);
            arrayList.addAll((ArrayList)this.card.getDescendantsOfType(eEqType.TEN_GE_PORT));
            arrayList.addAll((ArrayList)this.card.getDescendantsOfType(eEqType.FE_PORT));
        }
        for (IEntityModel iEntityModel : arrayList) {
            if (arrayList3.contains(iEntityModel)) continue;
            this.srcPortListModel.add(new PortDescriptor(iEntityModel));
        }
    }

    private void fillDstPortList(int[] nArray) {
        ArrayList<IEntityModel> arrayList = this.getPortEntityList(nArray);
        for (IEntityModel iEntityModel : arrayList) {
            this.dstPortListModel.add(new PortDescriptor(iEntityModel));
        }
    }

    private ArrayList<IEntityModel> getPortEntityList(int[] nArray) {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        NodeModelDelegate nodeModelDelegate = this.card.getNodeModelDelegate();
        InterfaceModels interfaceModels = nodeModelDelegate.getIfModels();
        for (int i = 0; i < nArray.length; ++i) {
            try {
                InterfaceModel interfaceModel = interfaceModels.getInterfaceModel(nArray[i]);
                arrayList.add((IEntityModel)interfaceModel.getPort());
                continue;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error getting interfaces " + exception);
            }
        }
        return arrayList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block8: {
            Object[] objectArray;
            Object object;
            block10: {
                block9: {
                    block7: {
                        object = actionEvent.getSource();
                        if (object != this.cancelBT) break block7;
                        this.isCancelled = true;
                        this.setVisible(false);
                        break block8;
                    }
                    if (object != this.okBT) break block9;
                    this.setVisible(false);
                    break block8;
                }
                if (object != this.addPortsBT) break block10;
                Object[] objectArray2 = this.srcPortsList.getSelectedValues();
                if (objectArray2 == null || objectArray2.length <= 0) break block8;
                for (int i = 0; i < objectArray2.length; ++i) {
                    PortDescriptor portDescriptor = (PortDescriptor)objectArray2[i];
                    if (portDescriptor.isRemoved()) {
                        portDescriptor.setRemoved(false);
                    } else {
                        portDescriptor.setAdded(true);
                    }
                    this.dstPortListModel.add(portDescriptor);
                    this.srcPortListModel.removeElement(portDescriptor);
                }
                break block8;
            }
            if (object == this.removePortsBT && (objectArray = this.dstPortsList.getSelectedValues()) != null && objectArray.length > 0) {
                for (int i = 0; i < objectArray.length; ++i) {
                    PortDescriptor portDescriptor = (PortDescriptor)objectArray[i];
                    if (portDescriptor.isAdded()) {
                        portDescriptor.setAdded(false);
                    } else {
                        portDescriptor.setRemoved(true);
                    }
                    this.dstPortListModel.removeElement(portDescriptor);
                    this.srcPortListModel.add(portDescriptor);
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        if (jList == this.srcPortsList) {
            if (jList.getSelectedIndex() != -1) {
                this.addPortsBT.setEnabled(true);
                this.removePortsBT.setEnabled(false);
                this.dstPortsList.clearSelection();
            } else {
                this.addPortsBT.setEnabled(false);
                this.removePortsBT.setEnabled(false);
            }
        } else if (jList == this.dstPortsList) {
            if (jList.getSelectedIndex() != -1) {
                this.addPortsBT.setEnabled(false);
                this.removePortsBT.setEnabled(true);
                this.srcPortsList.clearSelection();
            } else {
                this.addPortsBT.setEnabled(false);
                this.removePortsBT.setEnabled(false);
            }
        }
    }

    protected Attribute[] getAttributeArray(String string) {
        INodeModel iNodeModel = this.card.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeArray(string);
    }

    @Override
    public void dispose() {
        this.srcPortListModel = null;
        this.dstPortListModel = null;
        this.getContentPane().removeAll();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public ArrayList<PortDescriptor> getAddedPorts() {
        ArrayList<PortDescriptor> arrayList = new ArrayList<PortDescriptor>();
        int n = this.dstPortListModel.getSize();
        for (int i = 0; i < n; ++i) {
            PortDescriptor portDescriptor = (PortDescriptor)this.dstPortListModel.getElementAt(i);
            if (!portDescriptor.isAdded()) continue;
            arrayList.add(portDescriptor);
        }
        return arrayList;
    }

    public ArrayList<PortDescriptor> getRemovedPorts() {
        ArrayList<PortDescriptor> arrayList = new ArrayList<PortDescriptor>();
        int n = this.srcPortListModel.getSize();
        for (int i = 0; i < n; ++i) {
            PortDescriptor portDescriptor = (PortDescriptor)this.srcPortListModel.getElementAt(i);
            if (!portDescriptor.isRemoved()) continue;
            arrayList.add(portDescriptor);
        }
        return arrayList;
    }

    public sChannelGroupAttributes getChannelGroupAttributes() {
        sChannelGroupAttributes sChannelGroupAttributes2 = new sChannelGroupAttributes();
        sChannelGroupAttributes2.info = new sChannelGroupInfo();
        sChannelGroupAttributes2.info.l1Info = new sL1Info();
        sChannelGroupAttributes2.info.l1Info.ingressQos = new sIngressQOSInfo();
        sChannelGroupAttributes2.base = new sIfAttributes();
        sChannelGroupAttributes2.base.alias = this.chGroupNameTF.getText();
        sChannelGroupAttributes2.cgId = (char)((Integer)this.chGroupIDCB.getSelectedItem()).intValue();
        sChannelGroupAttributes2.info.algoritm = eHashingMode.from_int(((Attribute)this.lacpHashCB.getSelectedItem()).getIntValue());
        sChannelGroupAttributes2.info.lacpMode = eLacpMode.from_int(((Attribute)this.lacpModeCB.getSelectedItem()).getIntValue());
        return sChannelGroupAttributes2;
    }

    protected class PortDescriptor
    implements Comparable<PortDescriptor> {
        IEntityModel model;
        protected EntityCellRenderer portNameRenderer;
        boolean added = false;
        boolean removed = false;

        public PortDescriptor(IEntityModel iEntityModel) {
            this.model = iEntityModel;
            this.portNameRenderer = new EntityCellRenderer(false);
        }

        public IEntityModel getModel() {
            return this.model;
        }

        public String toString() {
            return this.portNameRenderer.getPortString(this.model, false);
        }

        public void setAdded(boolean bl) {
            this.added = bl;
        }

        public boolean isAdded() {
            return this.added;
        }

        public void setRemoved(boolean bl) {
            this.removed = bl;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public int getIfIndex() {
            InterfaceModel interfaceModel;
            InterfaceModel[] interfaceModelArray;
            IInterfaceModel iInterfaceModel = ((PortModel)this.model).getInterfaceModel();
            if (iInterfaceModel != null && (interfaceModelArray = (interfaceModel = (InterfaceModel)iInterfaceModel).getHigherLayerModels()) != null && interfaceModelArray.length > 0) {
                return interfaceModelArray[0].getIndex();
            }
            if (db.on()) {
                db.println("ERROR!!! not able to get the higher interface of " + this.toString());
            }
            return 0;
        }

        @Override
        public int compareTo(PortDescriptor portDescriptor) {
            if (this.model.getEntityIndex() < portDescriptor.model.getEntityIndex()) {
                return -1;
            }
            if (this.model.getEntityIndex() > portDescriptor.model.getEntityIndex()) {
                return 1;
            }
            return 0;
        }
    }

    private class PortListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public PortListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Color color;
            PortDescriptor portDescriptor = (PortDescriptor)object;
            Color color2 = Color.BLACK;
            if (portDescriptor.isAdded()) {
                color = bl ? Color.GREEN.darker() : Color.GREEN;
            } else if (portDescriptor.isRemoved()) {
                color = bl ? Color.RED.darker() : Color.RED;
            } else if (bl) {
                color = jList.getSelectionBackground();
                color2 = jList.getSelectionForeground();
            } else {
                color = jList.getBackground();
                color2 = jList.getForeground();
            }
            this.setText(portDescriptor.toString());
            this.setBackground(color);
            this.setForeground(color2);
            return this;
        }
    }

    private class SortedListModel
    extends AbstractListModel {
        SortedSet model = new TreeSet();

        @Override
        public int getSize() {
            return this.model.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.model.toArray()[n];
        }

        public void add(Object object) {
            if (this.model.add(object)) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
        }

        public void addAll(Object[] objectArray) {
            List<Object> list = Arrays.asList(objectArray);
            this.model.addAll(list);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void clear() {
            this.model.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public boolean contains(Object object) {
            return this.model.contains(object);
        }

        public Object firstElement() {
            return this.model.first();
        }

        public Iterator iterator() {
            return this.model.iterator();
        }

        public Object lastElement() {
            return this.model.last();
        }

        public boolean removeElement(Object object) {
            boolean bl = this.model.remove(object);
            if (bl) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
            return bl;
        }
    }
}

