/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.VlanList;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.xpl2.XPL2CvlanProfileMappingTableModel;
import cerent.util.DetailedLog;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.DetailedLogDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.VlanListPropertyEditor;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class XPL2CvlanProfileMappingProvPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener {
    private static final Preferences prefs = Preferences.instance();
    private static final TableColumn[] TABLE_COLUMN_ARRAY_TEMPLATE = new TableColumn[0];
    private static final int MARGIN = 6;
    protected VlanListPropertyEditor slistEditor;
    protected VlanList slist;
    protected XPL2CvlanProfileMappingTableModel dataModel = null;
    protected XPL2ModuleModel eqpmt = null;
    private static final SDebug db = new SDebug("XPL2CvlanProfileMappingProvPane");

    public XPL2CvlanProfileMappingProvPane(String string, TabbedView tabbedView, XPL2ModuleModel xPL2ModuleModel) {
        super(string, tabbedView);
        this.eqpmt = xPL2ModuleModel;
        this.slistEditor = new VlanListPropertyEditor("CVLANS to View (e.g. 1,3-5 + Enter):", 14, false);
        String string2 = prefs.getProperty("ctc", this.getSVlanListDefaultPropertyName(), null);
        if (string2 != null) {
            this.slistEditor.setText(string2);
        }
        this.slistEditor.addPropertyChangeListener(this);
        this.add(this.slistEditor, "Last");
    }

    private String getSVlanListDefaultPropertyName() {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.eqpmt.getNodeModel();
        return "cvlanprofilemapping." + nodeModelDelegate.getNodeId() + "." + this.eqpmt.getIndex() + "." + "vanlist";
    }

    private void reinit() throws CTCUserException {
        this.reinit(null);
    }

    private void reinit(VlanList vlanList) throws CTCUserException {
        block24: {
            if (db.on()) {
                db.println("reinit(" + vlanList + ") entered");
            }
            boolean bl = false;
            if (this.slist == null) {
                this.slist = vlanList == null ? this.slistEditor.getVlanList() : vlanList;
                if (this.slist != null) {
                    bl = true;
                }
            }
            if (this.slist != null && this.slist.getBitSet().size() > 0) {
                if (vlanList != null) {
                    if (vlanList.equals(this.slist)) {
                        if (this.dataModel != null) {
                            return;
                        }
                    } else {
                        if (db.on()) {
                            db.println("slist changed");
                        }
                        bl = true;
                        this.slist = vlanList;
                    }
                }
                if (db.on()) {
                    db.println("reiniting data model w/ slist: " + this.slist);
                }
                XPL2LineModel[] xPL2LineModelArray = this.eqpmt.getXPL2UNILines();
                PortModel[] portModelArray = new PortModel[xPL2LineModelArray.length];
                for (int i = 0; i < xPL2LineModelArray.length; ++i) {
                    try {
                        portModelArray[i] = (PortModel)xPL2LineModelArray[i].getPortModel();
                        continue;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                if (this.dataModel != null) {
                    this.dataModel.dispose();
                }
                try {
                    this.dataModel = new XPL2CvlanProfileMappingTableModel(this.eqpmt, portModelArray, xPL2LineModelArray, this.slist);
                    this.dataModel.setPassing(true);
                }
                catch (CTCUserException cTCUserException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)cTCUserException);
                    }
                    throw cTCUserException;
                }
                this.dataModel.addTableModelListener(this);
                if (this.table == null) {
                    if (db.on()) {
                        db.println("initing table");
                    }
                    this.table = new UTable(this.dataModel){

                        public void createDefaultColumnsFromModel() {
                            if (db.on()) {
                                db.println("createDefaultColumnsFromModel() enter");
                            }
                            TableColumn[] tableColumnArray = XPL2CvlanProfileMappingProvPane.this.getTableColumns();
                            boolean bl = this.getTableHeader() == null;
                            boolean bl2 = true;
                            if (!bl) {
                                ((XPL2CvlanProfileMappingTableModel)this.dataModel).initLines();
                                bl2 = XPL2CvlanProfileMappingProvPane.this.isInDefaultSortOrder(tableColumnArray);
                            }
                            super.createDefaultColumnsFromModel();
                            if (!bl) {
                                if (!bl2) {
                                    XPL2CvlanProfileMappingProvPane.this.reorderTableColumns(tableColumnArray);
                                }
                                XPL2CvlanProfileMappingProvPane.this.initColumns((JTable)((Object)this));
                            }
                        }
                    };
                    this.table.setAutoResizeMode(0);
                    this.table.setCellSelectionEnabled(true);
                    this.initColumns(this.table);
                    UScrollPane uScrollPane = new UScrollPane((Component)this.table);
                    this.add((Component)uScrollPane, "Center");
                    uScrollPane.invalidate();
                    this.validate();
                } else {
                    if (db.on()) {
                        db.println("update table model");
                    }
                    this.table.setModel(this.dataModel);
                }
                if (bl) {
                    try {
                        this.dataModel.refreshFromModel(this.slist);
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block24;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInDefaultSortOrder(TableColumn[] tableColumnArray) {
        int n;
        if (tableColumnArray == null || tableColumnArray.length == 0) {
            return true;
        }
        String[] stringArray = this.dataModel.getPortNums();
        if (db.on()) {
            db.println("Current table columns:");
            for (TableColumn object : tableColumnArray) {
                db.println("  " + object.getHeaderValue());
            }
            db.println("Current model columns:");
            Object[] objectArray = stringArray;
            int n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                Object object = objectArray[n];
                db.println("  " + (String)object);
            }
        }
        boolean bl = false;
        if (tableColumnArray[0].getHeaderValue().equals("CVLAN")) {
            void var6_13;
            bl = true;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (n = 0; n < stringArray.length; ++n) {
                hashMap.put(stringArray[n], n);
            }
            n = -1;
            boolean bl2 = true;
            while (var6_13 < tableColumnArray.length && bl) {
                String string = tableColumnArray[var6_13].getHeaderValue().toString();
                Integer n2 = (Integer)hashMap.get(string);
                if (n2 != null) {
                    int n3 = n2;
                    bl = n3 > n;
                    n = n3;
                }
                ++var6_13;
            }
        }
        if (db.on()) {
            db.println("isInDefaultSortOrder: " + bl);
            if (!bl) {
                void var6_17;
                void var6_15;
                db.println("...table columns:");
                Object[] objectArray = tableColumnArray;
                n = objectArray.length;
                boolean bl3 = false;
                while (var6_15 < n) {
                    TableColumn tableColumn = objectArray[var6_15];
                    db.println("  " + tableColumn.getHeaderValue());
                    ++var6_15;
                }
                db.println("...ports:");
                objectArray = stringArray;
                n = objectArray.length;
                boolean bl4 = false;
                while (var6_17 < n) {
                    Object object = objectArray[var6_17];
                    db.println("  " + (String)object);
                    ++var6_17;
                }
            }
        }
        return bl;
    }

    private void fitColumnToHeader(JTable jTable, TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Object object = tableColumn.getHeaderValue();
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, 0, 0);
        int n = component.getPreferredSize().width;
        XPL2CvlanProfileMappingProvPane.setPreferredWidth(tableColumn, n);
        if (db.on()) {
            db.println("column: '" + object + "' was set to pref. width: " + n);
        }
    }

    private void fitColumnToHeaderAndCvlans(JTable jTable, TableColumn tableColumn, int n) {
        int n2;
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Object object = tableColumn.getHeaderValue();
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, 0, 0);
        int n3 = component.getPreferredSize().width;
        VlanList vlanList = this.dataModel.getVlanDbIntersectedList(this.slist);
        short[] sArray = vlanList.getVLANs();
        if (db.on()) {
            db.println("user/intersected cvlans: " + vlanList);
            db.println("corr. cvlan id:");
            for (n2 = 0; n2 < sArray.length; ++n2) {
                db.println("  " + sArray[n2]);
            }
        }
        n2 = sArray.length;
        for (int i = 0; i < n2; ++i) {
            TableCellRenderer tableCellRenderer2 = jTable.getCellRenderer(i, n);
            if (tableCellRenderer2 == null) {
                tableCellRenderer2 = tableCellRenderer;
            }
            component = tableCellRenderer2.getTableCellRendererComponent(jTable, sArray[i], false, false, i, n);
            n3 = Math.max(n3, component.getPreferredSize().width);
        }
        XPL2CvlanProfileMappingProvPane.setPreferredWidth(tableColumn, n3);
        if (db.on()) {
            db.println("column: '" + object + "' in column index: " + n + " was set to pref. width: " + n3);
        }
    }

    private static void setPreferredWidth(TableColumn tableColumn, int n) {
        tableColumn.setPreferredWidth(n + 12);
    }

    private TableColumn[] getTableColumns() {
        if (this.table == null) {
            return null;
        }
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray(TABLE_COLUMN_ARRAY_TEMPLATE);
    }

    private void reorderTableColumns(TableColumn[] tableColumnArray) {
        if (this.table == null || tableColumnArray == null || this.dataModel == null) {
            return;
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = Math.min(this.dataModel.getColumnCount(), this.table.getColumnCount());
        for (int i = 0; i < tableColumnArray.length; ++i) {
            Object object = tableColumnArray[i].getIdentifier();
            for (int j = 0; j < n; ++j) {
                TableColumn tableColumn = tableColumnModel.getColumn(j);
                int n2 = tableColumnModel.getColumnIndex(tableColumn.getIdentifier());
                if (!object.equals(tableColumn.getIdentifier()) || i == n2 || i >= n) continue;
                this.table.moveColumn(n2, i);
            }
        }
    }

    @Override
    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("calling enteringPage");
        }
        if (this.dataModel != null) {
            if (this.dataModel.didMissEvent()) {
                this.dataModel.dispose();
                this.dataModel = null;
            } else {
                this.dataModel.setPassing(true);
            }
        }
        this.reinit();
        boolean bl = this.isUserAuthorized(SecurityLevel.PROVISIONING);
        if (this.dataModel != null) {
            this.dataModel.setCellEditable(bl);
        }
        if (db.on()) {
            if (this.table == null) {
                db.println("No table");
            } else {
                db.println("Display column order is now...");
                TableColumnModel tableColumnModel = this.table.getColumnModel();
                int n = tableColumnModel.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    db.println("  " + i + ": " + tableColumn.getHeaderValue());
                }
            }
        }
        super.enteringPage();
    }

    @Override
    public void leavingPage() throws Exception {
        if (db.on()) {
            db.println("leavingPage enter");
        }
        this.setDirty(this.dataModel.isDirty());
        super.leavingPage();
        this.dataModel.setPassing(false);
        String string = this.slistEditor.getText();
        if (string != null) {
            prefs.setProperty("ctc", this.getSVlanListDefaultPropertyName(), string);
        }
    }

    private void initColumns(JTable jTable) {
        Object object;
        if (db.on()) {
            db.println("initColumns(" + jTable + ") enter");
        }
        if (jTable == null) {
            return;
        }
        DefaultCellEditor defaultCellEditor = null;
        Object[] objectArray = this.dataModel.getProfileNames();
        if (objectArray != null) {
            object = new JComboBox<Object>(objectArray);
            defaultCellEditor = new DefaultCellEditor((JComboBox)object){

                @Override
                public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                    Component component = this.getComponent();
                    if (component instanceof JComboBox && XPL2CvlanProfileMappingProvPane.this.dataModel.hasNameSequenceNumChanged()) {
                        JComboBox jComboBox = (JComboBox)component;
                        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
                        Object[] objectArray = XPL2CvlanProfileMappingProvPane.this.dataModel.getProfileNames();
                        defaultComboBoxModel.removeAllElements();
                        for (Object object2 : objectArray) {
                            defaultComboBoxModel.addElement(object2);
                        }
                    }
                    return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
            };
            defaultCellEditor.setClickCountToStart(2);
        }
        object = jTable.getColumnModel();
        int n = object.getColumnCount();
        if (db.on()) {
            db.println("data model column count: " + n);
        }
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = object.getColumn(i);
            Object object2 = tableColumn.getHeaderValue();
            if (object2.equals("CVLAN")) {
                this.fitColumnToHeaderAndCvlans(jTable, tableColumn, i);
                continue;
            }
            if (db.on()) {
                db.println("fitColumnToHeader(" + object2 + ")");
            }
            this.fitColumnToHeader(jTable, tableColumn);
            if (defaultCellEditor == null) continue;
            tableColumn.setCellEditor(defaultCellEditor);
        }
    }

    @Override
    public void destroy() {
        this.dispose();
        super.destroy();
    }

    @Override
    public void dispose() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.dispose();
            this.dataModel = null;
        }
        super.dispose();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setDirty(this.dataModel.isDirty());
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if (db.on()) {
            db.println("received property change: " + propertyChangeEvent);
        }
        if ((object = propertyChangeEvent.getNewValue()) instanceof VlanList) {
            if (!object.equals(this.slist)) {
                if (db.on()) {
                    db.println("CVLAN list changed...reiniting data");
                }
                try {
                    this.reinit((VlanList)object);
                }
                catch (CTCUserException cTCUserException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)cTCUserException);
                    }
                }
            }
        } else {
            this.setDirty();
            if (db.on()) {
                db.println(this.slistEditor.toString());
            }
        }
    }

    @Override
    public void applyChangesToModel() throws Exception {
        DetailedLog detailedLog = new DetailedLog(0);
        int n = 0;
        for (int i = 1; i < this.dataModel.getColumnCount(); ++i) {
            try {
                n += this.dataModel.applyToModel(i, detailedLog);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dataModel.resetDirty();
        this.resetDirty();
        if (db.on()) {
            db.println("total # of apply changes done: " + n);
        }
        if (detailedLog.getChildCount() > 0) {
            this.dataModel.refreshFromModel();
            DetailedLogDialog detailedLogDialog = DetailedLogDialog.getMixedDetailedLogDialog((Frame)JOptionPane.getFrameForComponent(this.getParent()), (DetailedLog)detailedLog);
            detailedLogDialog.show();
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel enter");
        }
        if (this.dataModel != null) {
            this.dataModel.resetDirty();
            this.dataModel.refreshFromModel();
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2CvlanProfileMappingProvPane;
    }
}

