/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.eEfmLmAction;
import cerent.cms.idl.EtherL2Media.sEfmLinkMonitorInfo;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class XPL2EFMLinkMonitoringTableModel
extends AbstractTableModel
implements Observer {
    public static final int LINENUMBER_INDEX = 0;
    public static final int EF_MAX_INDEX = 1;
    public static final int EF_MIN_INDEX = 2;
    public static final int EF_ACTION_INDEX = 3;
    public static final int EF_WINDOW_INDEX = 4;
    public static final int EFP_MAX_INDEX = 5;
    public static final int EFP_MIN_INDEX = 6;
    public static final int EFP_ACTION_INDEX = 7;
    public static final int EFP_WINDOW_INDEX = 8;
    public static final int EFSS_MAX_INDEX = 9;
    public static final int EFSS_MIN_INDEX = 10;
    public static final int EFSS_ACTION_INDEX = 11;
    public static final int EFSS_WINDOW_INDEX = 12;
    static final String[] columnNames = new String[]{"Port", "EF Max", "EF Min", "EF Action", "EF Window", "EFP Max", "EFP Min", "EFP Action", "EFP Window", "EFSS Max", "EFSS Min", "EFSS Action", "EFSS Window"};
    private XPL2ModuleModel eqpmtModel = null;
    private XPL2LineModel[] lineModels = null;
    private sEfmLinkMonitorInfo[] efmLMInfo = null;
    private boolean[][] isDirty = null;
    private int numLines = 0;
    protected EntityCellRenderer myPortRenderer;
    private static final SDebug db = new SDebug("XPL2EFMLinkMonitorTableModel");

    public XPL2EFMLinkMonitoringTableModel(XPL2ModuleModel xPL2ModuleModel, XPL2LineModel[] xPL2LineModelArray) {
        this.eqpmtModel = xPL2ModuleModel;
        this.myPortRenderer = new EntityCellRenderer(false);
        this.refreshMyLines(xPL2LineModelArray);
    }

    public void refreshMyLines(XPL2LineModel[] xPL2LineModelArray) {
        this.unRegisterWithLineModels();
        this.lineModels = xPL2LineModelArray;
        this.numLines = this.lineModels.length;
        this.efmLMInfo = new sEfmLinkMonitorInfo[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirty();
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.registerWithLineModels();
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.lineModels != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.lineModels[0], SecurityLevel.PROVISIONING)) {
            return n2 != 0;
        }
        return false;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    private String getLineNumber(int n) {
        try {
            IPortModel iPortModel = this.lineModels[n].getPortModel();
            return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
        }
        catch (Exception exception) {
            if (XPL2EFMLinkMonitoringTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public Attribute[] getEfmLmActionAttrs() {
        return this.getAttributeArray("EfmLmActions");
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        block17: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumber(n);
                    }
                    case 1: {
                        return String.valueOf(this.efmLMInfo[n].errFrame.upperThreshold);
                    }
                    case 2: {
                        return String.valueOf(this.efmLMInfo[n].errFrame.lowerThreshold);
                    }
                    case 3: {
                        return this.getAttributeFor("EfmLmActions", this.efmLMInfo[n].errFrame.action.value());
                    }
                    case 4: {
                        return String.valueOf(this.efmLMInfo[n].errFrame.window);
                    }
                    case 5: {
                        return String.valueOf(this.efmLMInfo[n].errPeriod.upperThreshold);
                    }
                    case 6: {
                        return String.valueOf(this.efmLMInfo[n].errPeriod.lowerThreshold);
                    }
                    case 7: {
                        return this.getAttributeFor("EfmLmActions", this.efmLMInfo[n].errPeriod.action.value());
                    }
                    case 8: {
                        return String.valueOf(this.efmLMInfo[n].errPeriod.window);
                    }
                    case 9: {
                        return String.valueOf(this.efmLMInfo[n].errFrameSecondSummary.upperThreshold);
                    }
                    case 10: {
                        return String.valueOf(this.efmLMInfo[n].errFrameSecondSummary.lowerThreshold);
                    }
                    case 11: {
                        return this.getAttributeFor("EfmLmActions", this.efmLMInfo[n].errFrameSecondSummary.action.value());
                    }
                    case 12: {
                        return String.valueOf(this.efmLMInfo[n].errFrameSecondSummary.window);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block17;
                db.println("Error in getValueAt in XPL2MapEtherPortTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        boolean bl = false;
        try {
            switch (n2) {
                case 1: {
                    this.efmLMInfo[n].errFrame.upperThreshold = Integer.parseInt(object.toString());
                    break;
                }
                case 2: {
                    this.efmLMInfo[n].errFrame.lowerThreshold = Integer.parseInt(object.toString());
                    break;
                }
                case 3: {
                    this.efmLMInfo[n].errFrame.action = eEfmLmAction.from_int(((Attribute)object).getIntValue());
                    break;
                }
                case 4: {
                    this.efmLMInfo[n].errFrame.window = Short.parseShort(object.toString());
                    break;
                }
                case 5: {
                    this.efmLMInfo[n].errPeriod.upperThreshold = Integer.parseInt(object.toString());
                    break;
                }
                case 6: {
                    this.efmLMInfo[n].errPeriod.lowerThreshold = Integer.parseInt(object.toString());
                    break;
                }
                case 7: {
                    this.efmLMInfo[n].errPeriod.action = eEfmLmAction.from_int(((Attribute)object).getIntValue());
                    break;
                }
                case 8: {
                    this.efmLMInfo[n].errPeriod.window = Short.parseShort(object.toString());
                    break;
                }
                case 9: {
                    this.efmLMInfo[n].errFrameSecondSummary.upperThreshold = Integer.parseInt(object.toString());
                    break;
                }
                case 10: {
                    this.efmLMInfo[n].errFrameSecondSummary.lowerThreshold = Integer.parseInt(object.toString());
                    break;
                }
                case 11: {
                    this.efmLMInfo[n].errFrameSecondSummary.action = eEfmLmAction.from_int(((Attribute)object).getIntValue());
                    break;
                }
                case 12: {
                    this.efmLMInfo[n].errFrameSecondSummary.window = Short.parseShort(object.toString());
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (!bl) {
            this.isDirty[n][n2] = true;
        }
        this.fireTableCellUpdated(n, n2);
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public Attribute getAttributeFor(String string, int n) {
        INodeModel iNodeModel = this.eqpmtModel.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeForVal(string, n);
    }

    protected Attribute[] getAttributeArray(String string) {
        INodeModel iNodeModel = this.eqpmtModel.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeArray(string);
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
                this.fireTableRowsUpdated(n, n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void applyToModel(int n) throws Exception {
        if (this.isDirty[n][1] || this.isDirty[n][2] || this.isDirty[n][3] || this.isDirty[n][4] || this.isDirty[n][5] || this.isDirty[n][6] || this.isDirty[n][7] || this.isDirty[n][8] || this.isDirty[n][9] || this.isDirty[n][10] || this.isDirty[n][11] || this.isDirty[n][12]) {
            this.lineModels[n].setEfmLMConfig(this.efmLMInfo[n]);
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetLineCache(int n) {
        try {
            this.efmLMInfo[n] = this.getEfmLMInfoFromModel(n);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.isDirty[n][i] = false;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private sEfmLinkMonitorInfo getEfmLMInfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        sEfmLinkMonitorInfo sEfmLinkMonitorInfo2 = this.lineModels[n].getEfmLMConfig();
        return sEfmLinkMonitorInfo2;
    }

    private void registerWithLineModels() {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    public void dispose() {
        this.unRegisterWithLineModels();
    }
}

