/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.XPL2EFMLoopbackTableModel;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2EFMLoopbackPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener {
    protected XPL2EFMLoopbackTableModel dataModel = null;
    protected XPL2ModuleModel eqpmtModel = null;
    protected XPL2LineModel[] lineModels = null;
    private ObservableManager _obsMgr;
    private static final SDebug db = new SDebug("XPL2EFMLoopbackPane");

    public XPL2EFMLoopbackPane(String string, TabbedView tabbedView, XPL2ModuleModel xPL2ModuleModel) {
        super(string, tabbedView);
        this.eqpmtModel = xPL2ModuleModel;
        this.lineModels = xPL2ModuleModel.getXPL2EtherLines();
        this.dataModel = new XPL2EFMLoopbackTableModel(xPL2ModuleModel, this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        this.table.setCellSelectionEnabled(true);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        this.add((Component)uScrollPane);
        this.registerWithModel();
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
    }

    protected void addColumn(int n) {
        TableColumn tableColumn = new TableColumn(n);
        this.table.addColumn(tableColumn);
    }

    @Override
    public void refreshMyLines(Object object) {
        if (!(object instanceof DwdmLineUpdate)) {
            return;
        }
        DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
        EtherLineModel[] etherLineModelArray = dwdmLineUpdate.getEtherLineModel();
        this.lineModels = new XPL2LineModel[etherLineModelArray.length];
        System.arraycopy(etherLineModelArray, 0, this.lineModels, 0, this.lineModels.length);
        this.dataModel.refreshMyLines(this.lineModels);
    }

    @Override
    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("calling enteringPage");
        }
        super.enteringPage();
        this.getObsMgr().setPassing(true);
        this.registerWithModel();
    }

    @Override
    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
        this.unRegisterWithModel();
    }

    @Override
    protected void deleteMessage(Observable observable, Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XPL2EFMLoopbackPane.this.unRegisterWithModel();
                XPL2EFMLoopbackPane.this.refreshMyLines(null);
            }
        });
    }

    @Override
    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    protected void unRegisterWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        Object[] objectArray = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        try {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
            tableColumn.setPreferredWidth(120);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
            objectArray = this.dataModel.getEfmLoopbackAttrs();
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn.setPreferredWidth(120);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.table.sizeColumnsToFit(-1);
    }

    private JComboBox getComboBoxFor(Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    @Override
    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.dispose();
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    @Override
    public void applyChangesToModel() throws Exception {
        Exception exception = null;
        for (int i = 0; i < this.lineModels.length; ++i) {
            try {
                this.dataModel.applyToModel(i);
                continue;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        if (exception != null) {
            this.dataModel.refreshFromModel();
            throw exception;
        }
        this.resetDirty();
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2EFMLoopbackPane;
    }
}

