/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.MEPInfo;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class XPL2MEPColumnRenderer
extends AbstractColumnRenderer {
    private static final int PORT_INDEX = 0;
    private static final int DOMAIN_INDEX = 1;
    private static final int MPID_INDEX = 2;
    private static final int VLANID_INDEX = 3;
    private static final int COLUMN_NO = 4;
    private JLabel label = new JLabel();
    protected static final SDebug db = new SDebug("XPL2MEPColumnRenderer");

    public XPL2MEPColumnRenderer(String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = "";
        JLabel jLabel = this.label;
        MEPInfo mEPInfo = (MEPInfo)object;
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (n2) {
            case 0: {
                string = this.getPString(((MEPInfo)object).getLineModel());
                break;
            }
            case 1: {
                string = ((MEPInfo)object).getDomainName();
                break;
            }
            case 2: {
                string = String.valueOf(((MEPInfo)object).getMpId());
                break;
            }
            case 3: {
                string = String.valueOf(((MEPInfo)object).getVlanId());
            }
        }
        this.label.setText(string);
        ((Component)jLabel).setForeground(color);
        ((Component)jLabel).setBackground(color2);
        return jLabel;
    }

    private String getSlotPort(NodeModelDelegate nodeModelDelegate, int n) {
        int n2 = XPL2MEPColumnRenderer.getSlotInt(nodeModelDelegate, n);
        int n3 = XPL2MEPColumnRenderer.getPortInt(nodeModelDelegate, n);
        if (n2 == -1 || n3 == -1) {
            return "unknown";
        }
        return "s" + String.valueOf(n2) + "/p" + this.getPortString(nodeModelDelegate, n);
    }

    private String getPString(XPL2LineModel xPL2LineModel) {
        EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
        try {
            if (xPL2LineModel != null) {
                return entityCellRenderer.getPortString((IEntityModel)xPL2LineModel.getPort(), false);
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
        }
        return null;
    }

    private String getPortString(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            EntityModel entityModel = (EntityModel)nodeModelDelegate.getIfModels().getInterfaceModel(n).getPortModel();
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            if (entityModel != null) {
                return entityCellRenderer.getPortString(entityModel, false);
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return null;
    }

    static int getSlotInt(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            return nodeModelDelegate.getIfModels().getInterfaceModel(n).getSlotNum();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
            return -1;
        }
    }

    static int getPortInt(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            return nodeModelDelegate.getIfModels().getInterfaceModel(n).getPortModel().getPort();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return -1;
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        XPL2LineModel xPL2LineModel = ((MEPInfo)object).getLineModel();
        XPL2LineModel xPL2LineModel2 = ((MEPInfo)object2).getLineModel();
        switch (n) {
            case 0: {
                String string = this.getPString(xPL2LineModel);
                String string2 = this.getPString(xPL2LineModel2);
                n2 = string.compareTo(string2);
                break;
            }
            case 1: {
                String string = ((MEPInfo)object).getDomainName();
                String string3 = ((MEPInfo)object2).getDomainName();
                n2 = string.compareTo(string3);
                break;
            }
            case 2: {
                short s = ((MEPInfo)object).getMpId();
                short s2 = ((MEPInfo)object2).getMpId();
                n2 = ComparisonUtil.compare((int)s, (int)s2);
                break;
            }
            case 3: {
                short s = ((MEPInfo)object).getVlanId();
                short s3 = ((MEPInfo)object2).getVlanId();
                n2 = ComparisonUtil.compare((int)s, (int)s3);
            }
        }
        return n2;
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[4];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = XPL2MEPColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Port";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Domain Name";
                n3 = 150;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "MPID";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "VLAN ID";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new XPL2MEPColumnRenderer(string, n3, bl, n2);
    }
}

