/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.MEPInfo;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.xpl2.XPL2MEPTableModel;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

public class XPL2MEPDataSource
extends AbstractRowDataSource
implements Observer {
    private ArrayList mepList = new ArrayList();
    XPL2ModuleModel moduleM = null;
    private static final SDebug db = new SDebug("XPL2MEPDataSource");

    public XPL2MEPDataSource(ModuleModel moduleModel) {
        this.moduleM = (XPL2ModuleModel)moduleModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMEPList() throws NoSuchInterface, WrongInterfaceType {
        MEPInfo[] mEPInfoArray = null;
        try {
            mEPInfoArray = this.moduleM.getMEPS();
            this.mepList = new ArrayList();
            for (int i = 0; i < mEPInfoArray.length; ++i) {
                this.mepList.add(mEPInfoArray[i]);
            }
        }
        finally {
            this.fireDataSourceChanged();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        Integer n = (Integer)object;
        if (object.equals(ModelUpdateType.CHANGED)) {
            if (XPL2MEPDataSource.db.on) {
                db.println("Receiving ModelUpdateType.CHANGE");
            }
        } else if (object.equals(ModelUpdateType.ADDED)) {
            if (XPL2MEPDataSource.db.on) {
                db.println("Receiving ModelUpdateType.ADDED");
            }
        } else if (object.equals(ModelUpdateType.DELETED) && XPL2MEPDataSource.db.on) {
            db.println("Receiving ModelUpdateType.DELETED");
        }
        try {
            this.getMEPList();
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        this.fireDataSourceChanged();
    }

    public void refresh() throws NoSuchInterface, WrongInterfaceType {
        this.getMEPList();
        this.fireDataSourceChanged();
    }

    public int getRowCount() {
        return this.mepList.size();
    }

    public Object getObjectAtRow(int n) {
        return this.mepList.get(n);
    }

    public Collection getAllObjects() {
        return this.mepList;
    }

    public void dispose() {
        if (XPL2MEPDataSource.db.on) {
            db.println("Disposing XPL2MEPDataSrc");
        }
    }

    public void deleteMEP(XPL2MEPTableModel xPL2MEPTableModel, int[] nArray) throws ProvisionError {
        for (int i = 0; i < nArray.length; ++i) {
            MEPInfo mEPInfo = (MEPInfo)xPL2MEPTableModel.getValueAt(nArray[i], 0);
            XPL2LineModel xPL2LineModel = mEPInfo.getLineModel();
            xPL2LineModel.removeMEP(mEPInfo);
        }
        try {
            this.refresh();
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
    }
}

