/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sCFMCondReportInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModels;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.KDebug;
import cerent.util.MacAddrFormat;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class XPL2MEPDownTableModel
extends AbstractTableModel
implements Observer {
    public static final int PORT_INDEX = 0;
    private static final String DNAME = "DOMAIN NAME";
    private static final String SVLANID = "SVLAN ID";
    private static final String RMPID = "REMOTE MPID";
    private static final String RMAC = "REMOTE MAC";
    static final String[] columnNames = new String[]{"Port"};
    private XPL2ModuleModel eqpmtModel = null;
    private int numLines = 0;
    private EntityTableModel etm;
    protected EntityCellRenderer myPortRenderer;
    private InterfaceModels ifs;
    private ArrayList reportInfoList = new ArrayList();
    private static final SDebug db = new SDebug("XPL2MEPDownTableModel");

    public XPL2MEPDownTableModel(XPL2ModuleModel xPL2ModuleModel) {
        this.eqpmtModel = xPL2ModuleModel;
        this.myPortRenderer = new EntityCellRenderer(false);
        this.etm = xPL2ModuleModel.getNodeModelDelegate().getEntityTableModel();
        this.ifs = xPL2ModuleModel.getNodeModelDelegate().getIfModels();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string;
        block5: {
            string = null;
            try {
                switch (n2) {
                    case 0: {
                        string = this.getPortName(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("Error in getValueAt in XPL2AffectedVlanTableModel " + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public StringBuffer getAffectedMEPs(int n) {
        AffectedMEPInfo affectedMEPInfo = (AffectedMEPInfo)this.reportInfoList.get(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DNAME + this.myPortRenderer.fillWhiteSpace(32) + "\t" + SVLANID + "\t" + RMPID + "\t" + RMAC + "\n");
        for (int i = 0; i < affectedMEPInfo.mepInfo.length; ++i) {
            stringBuffer.append(affectedMEPInfo.mepInfo[i].domainName + this.myPortRenderer.fillWhiteSpace(1, affectedMEPInfo.mepInfo[i].domainName) + "\t" + Short.toString(affectedMEPInfo.mepInfo[i].vlanId) + this.myPortRenderer.fillWhiteSpace(5) + "\t" + affectedMEPInfo.mepInfo[i].remoteMpId + this.myPortRenderer.fillWhiteSpace(7) + "\t" + MacAddrFormat.format(affectedMEPInfo.mepInfo[i].remoteMac.addr) + "\n");
            if (!db.on()) continue;
            db.println("received from conditionreport struct->");
            db.println("dname=" + affectedMEPInfo.mepInfo[i].domainName);
            db.println("vlanid=" + Short.toString(affectedMEPInfo.mepInfo[i].vlanId));
            db.println("remotempid=" + affectedMEPInfo.mepInfo[i].remoteMpId);
            db.println("remotemac=" + MacAddrFormat.format(affectedMEPInfo.mepInfo[i].remoteMac.addr));
            db.println("-------");
        }
        return stringBuffer;
    }

    public String getPortName(int n) {
        block5: {
            AffectedMEPInfo affectedMEPInfo = (AffectedMEPInfo)this.reportInfoList.get(n);
            if (affectedMEPInfo.mepInfo.length > 0) {
                try {
                    IPortModel iPortModel = this.ifs.getInterfaceModel(affectedMEPInfo.ifIndex).getPortModel();
                    return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("Error in getPortName in XPL2SecurityTableModel " + (Object)((Object)noSuchInterface));
                        KDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block5;
                    db.println("Error in getPortName in XPL2SecurityTableModel " + (Object)((Object)abstractCmsNoSuchEntityException));
                    KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return null;
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    public void reload(String string, int n) {
        XPL2Layer2LineModel[] xPL2Layer2LineModelArray = this.eqpmtModel.getXPL2Layer2EtherLines();
        this.numLines = 0;
        this.reportInfoList.clear();
        if (xPL2Layer2LineModelArray != null) {
            for (int i = 0; i < xPL2Layer2LineModelArray.length; ++i) {
                try {
                    sCFMCondReportInfo[] sCFMCondReportInfoArray = this.eqpmtModel.getActualMEPDownConditions(xPL2Layer2LineModelArray[i].getIndex(), string, n);
                    if (sCFMCondReportInfoArray == null || sCFMCondReportInfoArray.length <= 0) continue;
                    this.reportInfoList.add(new AffectedMEPInfo(xPL2Layer2LineModelArray[i].getIndex(), sCFMCondReportInfoArray));
                    ++this.numLines;
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (!db.on()) continue;
                    db.println("Error in reload in XPL2AffectedVlanTableModel " + (Object)((Object)noSuchInterface));
                    KDebug.printStackTrace((Throwable)noSuchInterface);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) continue;
                    db.println("Error in reload in XPL2AffectedVlanTableModel " + (Object)((Object)wrongInterfaceType));
                    KDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
        }
        this.fireTableDataChanged();
    }

    public void dispose() {
        this.reportInfoList.clear();
    }

    private class AffectedMEPInfo {
        int ifIndex;
        sCFMCondReportInfo[] mepInfo;

        AffectedMEPInfo(int n, sCFMCondReportInfo[] sCFMCondReportInfoArray) {
            this.ifIndex = n;
            this.mepInfo = new sCFMCondReportInfo[sCFMCondReportInfoArray.length];
            this.mepInfo = sCFMCondReportInfoArray;
        }
    }
}

