/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sMIPCCDB;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.ComparisonUtil;
import cerent.util.MacAddrFormat;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class XPL2MIPCCDBColumnRenderer
extends AbstractColumnRenderer {
    private static final int MAC_ADDR = 0;
    private static final int SVLANID = 1;
    private static final int LEVEL = 2;
    private static final int PORT = 3;
    private static final int MPID = 4;
    private static final int TIMER = 5;
    private static final int COLUMN_NO = 6;
    private JLabel label = new JLabel();
    protected static final SDebug db = new SDebug("XPL2MIPCCDBColumnRenderer");

    public XPL2MIPCCDBColumnRenderer(String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = "";
        JLabel jLabel = this.label;
        sMIPCCDB sMIPCCDB2 = (sMIPCCDB)object;
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (n2) {
            case 0: {
                string = MacAddrFormat.format(sMIPCCDB2.macAddr.addr);
                break;
            }
            case 1: {
                string = String.valueOf(sMIPCCDB2.svlanId);
                break;
            }
            case 2: {
                string = String.valueOf(sMIPCCDB2.level);
                break;
            }
            case 3: {
                string = String.valueOf(sMIPCCDB2.ingressPort);
                break;
            }
            case 4: {
                string = String.valueOf(sMIPCCDB2.mpId);
                break;
            }
            case 5: {
                string = String.valueOf(sMIPCCDB2.archive_timer);
            }
        }
        this.label.setText(string);
        ((Component)jLabel).setForeground(color);
        ((Component)jLabel).setBackground(color2);
        return jLabel;
    }

    private String getSlotPort(NodeModelDelegate nodeModelDelegate, int n) {
        int n2 = XPL2MIPCCDBColumnRenderer.getSlotInt(nodeModelDelegate, n);
        int n3 = XPL2MIPCCDBColumnRenderer.getPortInt(nodeModelDelegate, n);
        if (n2 == -1 || n3 == -1) {
            return "unknown";
        }
        return "s" + String.valueOf(n2) + "/p" + this.getPortString(nodeModelDelegate, n);
    }

    private String getPString(XPL2LineModel xPL2LineModel) {
        EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
        try {
            return entityCellRenderer.getPortString((IEntityModel)xPL2LineModel.getPort(), false);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
            return null;
        }
    }

    private String getPortString(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            EntityModel entityModel = (EntityModel)nodeModelDelegate.getIfModels().getInterfaceModel(n).getPortModel();
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            return entityCellRenderer.getPortString(entityModel, false);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return null;
    }

    static int getSlotInt(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            return nodeModelDelegate.getIfModels().getInterfaceModel(n).getSlotNum();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
            return -1;
        }
    }

    static int getPortInt(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            return nodeModelDelegate.getIfModels().getInterfaceModel(n).getPortModel().getPort();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return -1;
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        sMIPCCDB sMIPCCDB2 = (sMIPCCDB)object;
        sMIPCCDB sMIPCCDB3 = (sMIPCCDB)object2;
        switch (n) {
            case 0: {
                String string = MacAddrFormat.format(sMIPCCDB2.macAddr.addr);
                String string2 = MacAddrFormat.format(sMIPCCDB3.macAddr.addr);
                n2 = string.compareTo(string2);
                break;
            }
            case 1: {
                n2 = ComparisonUtil.compare((int)sMIPCCDB2.svlanId, (int)sMIPCCDB3.svlanId);
                break;
            }
            case 2: {
                n2 = ComparisonUtil.compare((int)sMIPCCDB2.level, (int)sMIPCCDB3.level);
                break;
            }
            case 3: {
                n2 = ComparisonUtil.compare((int)sMIPCCDB2.ingressPort, (int)sMIPCCDB3.ingressPort);
                break;
            }
            case 4: {
                n2 = ComparisonUtil.compare((int)sMIPCCDB2.mpId, (int)sMIPCCDB3.mpId);
                break;
            }
            case 5: {
                n2 = ComparisonUtil.compare((int)sMIPCCDB2.archive_timer, (int)sMIPCCDB3.archive_timer);
            }
        }
        return n2;
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[6];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = XPL2MIPCCDBColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Mac Address";
                n3 = 150;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Svlan ID";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Level";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "Port";
                n3 = 150;
                bl = true;
                n2 = 2;
                break;
            }
            case 4: {
                string = "MPID";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 5: {
                string = "Archive Timer";
                n3 = 150;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new XPL2MIPCCDBColumnRenderer(string, n3, bl, n2);
    }
}

