/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sMIPCCDB;
import cerent.cms.idl.Vlan.sVlanRangeInfo;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2ModuleModel;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

public class XPL2MIPCCDBDataSource
extends AbstractRowDataSource
implements Observer {
    private ArrayList mipList = new ArrayList();
    XPL2ModuleModel moduleM = null;
    private static final SDebug db = new SDebug("XPL2MIPCCDBDataSource");

    public XPL2MIPCCDBDataSource(ModuleModel moduleModel) {
        this.moduleM = (XPL2ModuleModel)moduleModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMIPList(int n, sVlanRangeInfo[] sVlanRangeInfoArray) throws NoSuchInterface, WrongInterfaceType {
        sMIPCCDB[] sMIPCCDBArray = null;
        try {
            sMIPCCDBArray = this.moduleM.getMIPCCDB(n, sVlanRangeInfoArray);
            this.mipList.clear();
            for (int i = 0; i < sMIPCCDBArray.length; ++i) {
                this.mipList.add(sMIPCCDBArray[i]);
            }
        }
        finally {
            this.fireDataSourceChanged();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        Integer n = (Integer)object;
        if (object.equals(ModelUpdateType.CHANGED)) {
            if (XPL2MIPCCDBDataSource.db.on) {
                db.println("Receiving ModelUpdateType.CHANGE");
            }
        } else if (object.equals(ModelUpdateType.ADDED)) {
            if (XPL2MIPCCDBDataSource.db.on) {
                db.println("Receiving ModelUpdateType.ADDED");
            }
        } else if (object.equals(ModelUpdateType.DELETED) && XPL2MIPCCDBDataSource.db.on) {
            db.println("Receiving ModelUpdateType.DELETED");
        }
        this.fireDataSourceChanged();
    }

    public void refresh() {
        this.fireDataSourceChanged();
    }

    public int getRowCount() {
        return this.mipList.size();
    }

    public Object getObjectAtRow(int n) {
        return this.mipList.get(n);
    }

    public Collection getAllObjects() {
        return this.mipList;
    }

    public void dispose() {
        if (XPL2MIPCCDBDataSource.db.on) {
            db.println("Disposing XPL2MIPCCDBDataSrc");
        }
        try {
            this.mipList.clear();
            this.mipList = null;
        }
        catch (Exception exception) {
            db.finest("Exception in dispose() " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws NoSuchInterface, WrongInterfaceType {
        try {
            this.moduleM.clearMEPMIPCCDB();
            this.mipList.clear();
        }
        finally {
            this.fireDataSourceChanged();
        }
    }
}

