/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.MIPInfo;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class XPL2MIPColumnRenderer
extends AbstractColumnRenderer {
    private static final int PORT_INDEX = 0;
    private static final int LEVEL = 1;
    private static final int RANGE = 2;
    private static final int COLUMN_NO = 3;
    private JLabel label = new JLabel();
    protected static final SDebug db = new SDebug("XPL2MIPColumnRenderer");

    public XPL2MIPColumnRenderer(String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = "";
        JLabel jLabel = this.label;
        MIPInfo mIPInfo = (MIPInfo)object;
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (n2) {
            case 0: {
                string = this.getPString(((MIPInfo)object).getLineModel());
                break;
            }
            case 1: {
                string = String.valueOf(((MIPInfo)object).getLevel());
                break;
            }
            case 2: {
                string = String.valueOf(((MIPInfo)object).getFirst());
            }
        }
        this.label.setText(string);
        ((Component)jLabel).setForeground(color);
        ((Component)jLabel).setBackground(color2);
        return jLabel;
    }

    private String getSlotPort(NodeModelDelegate nodeModelDelegate, int n) {
        int n2 = XPL2MIPColumnRenderer.getSlotInt(nodeModelDelegate, n);
        int n3 = XPL2MIPColumnRenderer.getPortInt(nodeModelDelegate, n);
        if (n2 == -1 || n3 == -1) {
            return "unknown";
        }
        return "s" + String.valueOf(n2) + "/p" + this.getPortString(nodeModelDelegate, n);
    }

    private String getPString(XPL2LineModel xPL2LineModel) {
        EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
        try {
            if (xPL2LineModel != null) {
                return entityCellRenderer.getPortString((IEntityModel)xPL2LineModel.getPort(), false);
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
        }
        return null;
    }

    private String getPortString(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            EntityModel entityModel = (EntityModel)nodeModelDelegate.getIfModels().getInterfaceModel(n).getPortModel();
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            if (entityModel != null) {
                return entityCellRenderer.getPortString(entityModel, false);
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return null;
    }

    static int getSlotInt(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            return nodeModelDelegate.getIfModels().getInterfaceModel(n).getSlotNum();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
            return -1;
        }
    }

    static int getPortInt(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            return nodeModelDelegate.getIfModels().getInterfaceModel(n).getPortModel().getPort();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return -1;
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        XPL2LineModel xPL2LineModel = ((MIPInfo)object).getLineModel();
        XPL2LineModel xPL2LineModel2 = ((MIPInfo)object2).getLineModel();
        switch (n) {
            case 0: {
                String string = this.getPString(xPL2LineModel);
                String string2 = this.getPString(xPL2LineModel2);
                n2 = string.compareTo(string2);
                break;
            }
            case 1: {
                int n3 = ((MIPInfo)object).getLevel();
                int n4 = ((MIPInfo)object2).getLevel();
                n2 = ComparisonUtil.compare((int)n3, (int)n4);
                break;
            }
            case 2: {
                int n5 = ((MIPInfo)object).getFirst();
                int n6 = ((MIPInfo)object2).getFirst();
                n2 = ComparisonUtil.compare((int)n5, (int)n6);
            }
        }
        return n2;
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[3];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = XPL2MIPColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Port";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Level";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Vlan ID";
                n3 = 200;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new XPL2MIPColumnRenderer(string, n3, bl, n2);
    }
}

