/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.MIPCreateDialog;
import cerent.cms.ui.xpl2.XPL2MIPDataSource;
import cerent.cms.ui.xpl2.XPL2MIPTableModel;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class XPL2MIPPane
extends AbstractPane
implements ActionListener,
ListSelectionListener {
    private XPL2MIPTableModel dataModel;
    private XPL2MIPDataSource dataSource;
    private boolean initialized = true;
    private int[] sortCols = new int[]{0};
    private boolean[] sortDir = new boolean[]{true};
    private static final SDebug db = new SDebug("XPL2MIPPane");
    private XPL2LineModel[] lineModels = null;
    private XPL2ModuleModel moduleM;
    private ObservableManager _obsMgr;
    private static final String CREATE = "Create...";
    private static final String DELETE = "Delete...";
    private static final String EDIT = "Edit...";
    private JButton createButton = new JButton("Create...");
    private JButton deleteButton = new JButton("Delete...");
    private JButton editButton = new JButton("Edit...");

    public XPL2MIPPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.moduleM = (XPL2ModuleModel)this.getUiModel();
        this.lineModels = this.moduleM.getXPL2EtherLines();
        this.init();
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    @Override
    protected void registerWithModel() {
        super.registerWithModel();
        this.getObsMgr().addObservable((Observable)((Object)this.moduleM));
    }

    protected void unRegisterWithModel() {
        super.registerWithModel();
        this.getObsMgr().removeObservable((Observable)((Object)this.moduleM));
    }

    @Override
    protected void refreshMyLines(Object object) {
        this.dataSource.refresh();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length != 0) {
            this.enableComponent(this.deleteButton, this.moduleM, SecurityLevel.PROVISIONING);
            if (nArray.length == 1) {
                this.enableComponent(this.editButton, this.moduleM, SecurityLevel.PROVISIONING);
            }
        } else {
            this.deleteButton.setEnabled(false);
        }
    }

    public void init() {
        if (db.on()) {
            db.println("init");
        }
        this.setLayout(new BorderLayout());
        this.dataSource = new XPL2MIPDataSource(this.moduleM);
        this.dataModel = new XPL2MIPTableModel(this.dataSource, this.sortCols, this.sortDir);
        this.table = new UTable((TableModel)((Object)this.dataModel));
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        ((XPL2MIPTableModel)((Object)this.table.getModel())).initTable(this.table);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.add(this.makeControlPanel(), "South");
        this.add((Component)uScrollPane, "West");
    }

    private JPanel makeControlPanel() {
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.XPL2MIPPane);
        this.createButton.addActionListener(this);
        cSHelpButtonPane.addLeft(this.createButton);
        this.deleteButton.addActionListener(this);
        cSHelpButtonPane.addLeft(this.deleteButton);
        this.editButton.addActionListener(this);
        cSHelpButtonPane.addLeft(this.editButton);
        this.deleteButton.setEnabled(false);
        this.editButton.setEnabled(false);
        return cSHelpButtonPane;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block13: {
            Object object = actionEvent.getSource();
            if (object == this.createButton) {
                MIPCreateDialog mIPCreateDialog = new MIPCreateDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), this.moduleM, this.dataModel, -1);
            } else if (object == this.deleteButton) {
                int[] nArray = this.table.getSelectedRows();
                if (nArray.length == 0) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"MIPs");
                    return;
                }
                if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)"Do you really want to delete the selected MIPs ?", (String)"Delete MIP")) {
                    return;
                }
                try {
                    this.dataModel.deleteMIP(nArray);
                }
                catch (ProvisionError provisionError) {
                    EID eID;
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)provisionError);
                    }
                    if ((eID = provisionError.getEID()) != null) {
                        ErrorMsg.displayDetailed((Component)((Object)this), eID, (Exception)((Object)provisionError));
                        break block13;
                    }
                    ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
                }
            } else if (object == this.editButton) {
                int[] nArray = this.table.getSelectedRows();
                if (nArray.length == 0) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"MIPs");
                    return;
                }
                if (nArray.length > 1) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)" MIPs ");
                    return;
                }
                MIPCreateDialog mIPCreateDialog = new MIPCreateDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), this.moduleM, this.dataModel, nArray[0]);
            }
        }
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
        if (this.dataSource != null) {
            this.dataSource.dispose();
            this.dataSource = null;
        }
    }

    @Override
    public void refresh() {
        this.dataSource.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.dataSource == null) {
                this.init();
            }
            this.refresh();
            this.getObsMgr().setPassing(true);
            this.registerWithModel();
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.getObsMgr().setPassing(false);
        this.unRegisterWithModel();
    }
}

