/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.DomainProfileInfo;
import cerent.cms.model.IDomainProfileInfo;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.XPL2FwdLoopTableModel;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.TextAreaDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.WindowHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2MaintFwdLoopPane
extends AbstractPane
implements ITabName,
ActionListener,
MouseListener,
ListSelectionListener {
    protected static final String REFRESH_STRING = "Refresh";
    protected static final String SHOW_STRING = "Show";
    protected XPL2FwdLoopTableModel dataModel = null;
    protected XPL2ModuleModel eqpmtModel = null;
    protected JButton refreshButton = new JButton("Refresh");
    protected JButton showButton = new JButton("Show");
    protected UComboBox domainCB = new UComboBox();
    protected JComboBox svlanCB = null;
    private ComboBoxRenderer comboRenderer = new ComboBoxRenderer();
    private Frame parentFrame;
    private int selectedRow;
    private static final String NULLSTRING = "------------";

    public XPL2MaintFwdLoopPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.showButton.setEnabled(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 5));
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.eqpmtModel = (XPL2ModuleModel)this.getUiModel();
        this.dataModel = new XPL2FwdLoopTableModel(this.eqpmtModel);
        this.table = new UTable((TableModel)this.dataModel);
        this.table.getSelectionModel().setSelectionMode(0);
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(70);
        this.table.addMouseListener(this);
        this.table.getSelectionModel().addListSelectionListener(this);
        Dimension dimension = new Dimension(100, 25);
        this.showButton.setEnabled(false);
        this.showButton.setMinimumSize(dimension);
        this.showButton.setMaximumSize(dimension);
        this.refreshButton.setMinimumSize(dimension);
        this.refreshButton.setMaximumSize(dimension);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.add(jPanel, "South");
        this.add((Component)uScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        jPanel2.add(new JLabel("Domain:"));
        jPanel2.add((Component)this.domainCB);
        DomainProfileInfo domainProfileInfo = new DomainProfileInfo(NULLSTRING, -1);
        this.domainCB.addItem((Object)domainProfileInfo);
        IDomainProfileInfo[] iDomainProfileInfoArray = this.getDomains();
        if (iDomainProfileInfoArray != null) {
            for (int i = 0; i < iDomainProfileInfoArray.length; ++i) {
                this.domainCB.addItem((Object)iDomainProfileInfoArray[i]);
            }
        }
        this.domainCB.setRenderer((ListCellRenderer)this.comboRenderer);
        this.svlanCB = new JComboBox<Short>(new DefaultComboBoxModel<Short>(this.getSvlanListFromModule()));
        jPanel2.add(new JLabel("SVLAN:"));
        jPanel2.add(this.svlanCB);
        jPanel2.add(this.refreshButton);
        jPanel2.add(this.showButton);
        cSHelpButtonPane.addLeft(jPanel2);
        jPanel.add((Component)cSHelpButtonPane, "South");
        this.refreshButton.addActionListener(this);
        this.showButton.addActionListener(this);
    }

    public IDomainProfileInfo[] getDomains() {
        IDomainProfileInfo[] iDomainProfileInfoArray = null;
        try {
            iDomainProfileInfoArray = this.eqpmtModel.getMaintenanceDomains();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return iDomainProfileInfoArray;
    }

    @Override
    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("calling enteringPage");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        String string = new String("");
        int n = 0;
        IDomainProfileInfo iDomainProfileInfo = (IDomainProfileInfo)this.domainCB.getSelectedItem();
        string = iDomainProfileInfo != null && this.domainCB.getSelectedIndex() != 0 ? iDomainProfileInfo.getDomainName() : "";
        if ((Short)this.svlanCB.getSelectedItem() != null) {
            n = ((Short)this.svlanCB.getSelectedItem()).intValue();
        }
        this.dataModel.reload(string, n);
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
    }

    public void applyChangesToModel() throws Exception {
    }

    public void refreshFromModel() throws Exception {
        String string = new String("");
        int n = 0;
        IDomainProfileInfo iDomainProfileInfo = (IDomainProfileInfo)this.domainCB.getSelectedItem();
        string = iDomainProfileInfo != null && this.domainCB.getSelectedIndex() != 0 ? iDomainProfileInfo.getDomainName() : "";
        if ((Short)this.svlanCB.getSelectedItem() != null) {
            n = ((Short)this.svlanCB.getSelectedItem()).intValue();
        }
        this.dataModel.reload(string, n);
    }

    @Override
    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void refresh() {
        try {
            this.refreshFromModel();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH_PANE);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH_PANE);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.refresh();
        } else if (object == this.showButton && this.table.getSelectedRow() != -1) {
            this.showVlanList(this.table.getSelectedRow());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
            this.table.setRowSelectionInterval(n, n);
            this.showVlanList(n);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void showVlanList(int n) {
        this.selectedRow = n;
        this.parentFrame = JOptionPane.getFrameForComponent((Component)((Object)this));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextAreaDialog textAreaDialog = new TextAreaDialog(XPL2MaintFwdLoopPane.this.parentFrame, XPL2MaintFwdLoopPane.this.dataModel.getValueAt(XPL2MaintFwdLoopPane.this.selectedRow, 0) + " Fwd-Loop Condition list ", XPL2MaintFwdLoopPane.this.dataModel.getAffectedFwdLoops(XPL2MaintFwdLoopPane.this.selectedRow).toString(), 1050, 200);
                textAreaDialog.getTextPanel().setHorizontalScrollBarPolicy(32);
                textAreaDialog.getInnerTextArea().setLineWrap(false);
                textAreaDialog.repaint();
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            WindowHelper.setEnabled((JComponent)this.showButton, (boolean)true);
        } else {
            WindowHelper.setEnabled((JComponent)this.showButton, (boolean)false);
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2MaintFwdLoopPane;
    }

    private Short[] getSvlanListFromModule() {
        IVlanInfo[] iVlanInfoArray = this.eqpmtModel.getVlanDb();
        Short[] shortArray = new Short[iVlanInfoArray.length + 1];
        shortArray[0] = null;
        for (int i = 0; i < iVlanInfoArray.length; ++i) {
            shortArray[i + 1] = iVlanInfoArray[i].getVlanId();
        }
        return shortArray;
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                this.setText("");
                return this;
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof IDomainProfileInfo) {
                this.setText(((IDomainProfileInfo)object).getDomainName());
            }
            return this;
        }
    }
}

