/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.SecurityLevel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.XPL2MulticastTableModel;
import cerent.util.SvlanRange;
import cerent.util.gui.TextAreaDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.VlanListPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class XPL2MaintMulticastPane
extends AbstractPane
implements ITabName,
TableModelListener,
ActionListener,
MouseListener {
    protected static final String REFRESH_STRING = "Refresh";
    protected XPL2MulticastTableModel dataModel = null;
    protected XPL2ModuleModel eqpmtModel = null;
    protected XPL2LineModel[] lineModels = null;
    protected JButton refreshButton;
    private Frame parentFrame;
    private int selectedRow;
    private VlanListPropertyEditor svlanList = new VlanListPropertyEditor("SVLANs", 10, true);
    private TableColumnModel columnModel;

    public XPL2MaintMulticastPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 5));
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.eqpmtModel = (XPL2ModuleModel)this.getUiModel();
        this.lineModels = this.eqpmtModel.getXPL2EtherLines();
        this.dataModel = new XPL2MulticastTableModel(this.eqpmtModel, this.svlanList);
        this.table = new UTable((TableModel)this.dataModel);
        this.table.addMouseListener(this);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.dataModel.addTableModelListener(this);
        this.customizedProvPane();
        this.add((Component)uScrollPane);
        this.enableComponent(this.svlanList);
        this.refreshButton = new JButton(REFRESH_STRING);
        this.refreshButton.addActionListener(this);
        JPanel jPanel = XPL2MaintMulticastPane.createVerticalPanel(null);
        jPanel.add(this.makeControlPanel());
        this.add(jPanel, "South");
        this.add((Component)uScrollPane, "Center");
    }

    @Override
    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("calling enteringPage");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        jPanel.add(this.svlanList);
        jPanel.add(this.refreshButton);
        jPanel.add(new JLabel("To list multicast port please double clik on a row."));
        cSHelpButtonPane.addLeft(jPanel);
        return cSHelpButtonPane;
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        this.table.removeColumn(tableColumn);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(120);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setPreferredWidth(100);
    }

    public void applyChangesToModel() throws Exception {
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2MulticastMaintenancePane;
    }

    @Override
    public final void refresh() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.svlanList.actionPerformed(null);
            if (this.svlanList.getVlanList() != null) {
                SvlanRange[] svlanRangeArray = this.svlanList.getVlanList().getRanges();
                this.dataModel.reload();
                this.dataModel.refreshMyLines();
            }
        }
    }

    protected void showVlanList(int n) {
        this.selectedRow = n;
        this.parentFrame = JOptionPane.getFrameForComponent((Component)((Object)this));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TextAreaDialog(XPL2MaintMulticastPane.this.parentFrame, "Multicast port list for VLAN " + XPL2MaintMulticastPane.this.dataModel.getValueAt(XPL2MaintMulticastPane.this.selectedRow, 1), XPL2MaintMulticastPane.this.dataModel.getValueAt(XPL2MaintMulticastPane.this.selectedRow, 2).toString(), 350, 100);
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
            this.table.setRowSelectionInterval(n, n);
            this.showVlanList(n);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

