/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.eAISActionType;
import cerent.cms.idl.EtherL2Media.eMRouter;
import cerent.cms.idl.EtherL2Media.eNiValue;
import cerent.cms.idl.EtherL2Media.eProtActionType;
import cerent.cms.idl.EtherL2Media.sBasicL2Info;
import cerent.cms.idl.EtherL2Media.sStormControlInfo;
import cerent.cms.idl.EtherMedia.eBucketSize;
import cerent.cms.idl.EtherMedia.eEtherDuplex;
import cerent.cms.idl.EtherMedia.eEtherSpeed;
import cerent.cms.idl.EtherMedia.eFlowControlNegotiated;
import cerent.cms.idl.EtherMedia.eMediaType;
import cerent.cms.idl.EtherMedia.sL1AdminInfo;
import cerent.cms.idl.EtherMedia.sL1Info;
import cerent.cms.idl.EtherMedia.sLineInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISVlanProfileModel;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SVlanProfileModels;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.CEMC;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class XPL2MapEtherPortTableModel
extends AbstractTableModel
implements Observer {
    public static final int LINENUMBER_INDEX = 0;
    public static final int MTU_INDEX = 1;
    public static final int MODE_INDEX = 2;
    public static final int SPEED_INDEX = 3;
    public static final int DUPLEX_INDEX = 4;
    public static final int FLOW_CTRL_INDEX = 5;
    public static final int ETHER_MEDIA_TYPE = 6;
    public static final int COMM_INFO_RATE_INDEX = 7;
    public static final int COMM_BURST_SIZE_INDEX = 8;
    public static final int EX_BURST_SIZE_INDEX = 9;
    public static final int NIM_INDEX = 10;
    public static final int EGRESS_QOS_INDEX = 11;
    public static final int MAC_ADDR_INDEX = 12;
    public static final int INGRESS_INDEX = 13;
    public static final int ETHER_INNER_INDEX = 14;
    public static final int ETHER_OUTER_INDEX = 15;
    public static final int IGMP_MROUTER_INDEX = 16;
    public static final int AIS_ACTION_INDEX = 17;
    public static final int PROT_ACTION_INDEX = 18;
    static final String[] columnNames = new String[]{"Port", "MTU", "Mode", "Speed", "Duplex", "Flow Control", "Media Type", "Committed Info Rate", "Committed Burst Size", "Excess Burst Size", "NIM", "Egress QoS", "MAC Learning", "Ingress CoS", "Inner Ethertype (Hex)", "Outer Ethertype (Hex)", "IGMP Static Router Port", "AIS Action", "Protection Action"};
    private XPL2ModuleModel eqpmtModel = null;
    private PortModel[] portModels = null;
    private XPL2LineModel[] lineModels = null;
    private sLineInfo[] etherLineInfo = null;
    private sL1Info[] etherL1Info = null;
    private sL1AdminInfo[] etherL1AdminInfo = null;
    private sBasicL2Info[] etherBasicL2Info = null;
    private eMediaType[] etherMediaType = null;
    private Boolean[] egressQOS = null;
    private eMRouter[] igmpMrouter = null;
    private eAISActionType[] aisAction = null;
    private eProtActionType[] protAction = null;
    private boolean[][] isDirty = null;
    private int numLines = 0;
    protected EntityCellRenderer myPortRenderer;
    private static final SDebug db = new SDebug("XPL2MapEtherPortTableModel");

    public XPL2MapEtherPortTableModel(XPL2ModuleModel xPL2ModuleModel, PortModel[] portModelArray, XPL2LineModel[] xPL2LineModelArray) {
        if (xPL2ModuleModel == null || portModelArray == null || xPL2LineModelArray == null || portModelArray.length != xPL2LineModelArray.length) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + xPL2ModuleModel + " portModels=" + portModelArray + " lineModels=" + xPL2LineModelArray);
            }
            return;
        }
        this.eqpmtModel = xPL2ModuleModel;
        this.portModels = portModelArray;
        this.myPortRenderer = new EntityCellRenderer(false);
        this.refreshMyLines(xPL2LineModelArray);
    }

    public void refreshMyLines(XPL2LineModel[] xPL2LineModelArray) {
        this.unRegisterWithLineModels();
        this.lineModels = xPL2LineModelArray;
        this.numLines = this.lineModels.length;
        this.etherLineInfo = new sLineInfo[this.numLines];
        this.etherL1Info = new sL1Info[this.numLines];
        this.etherL1AdminInfo = new sL1AdminInfo[this.numLines];
        this.egressQOS = new Boolean[this.numLines];
        this.igmpMrouter = new eMRouter[this.numLines];
        this.etherBasicL2Info = new sBasicL2Info[this.numLines];
        this.aisAction = new eAISActionType[this.numLines];
        this.protAction = new eProtActionType[this.numLines];
        this.etherMediaType = new eMediaType[this.numLines];
        this.numLines = this.lineModels.length;
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirty();
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.registerWithLineModels();
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 4 || n2 == 3) {
            return false;
        }
        if (this.lineModels != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.lineModels[0], SecurityLevel.PROVISIONING)) {
            if (n2 == 14 && n > 0) {
                return false;
            }
            if (n2 == 5 && this.eqpmtModel.isInTxpMode()) {
                return false;
            }
            if (n2 == 2 && this.eqpmtModel.isInTxpMode()) {
                return false;
            }
            return n2 != 0;
        }
        return false;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    private sBasicL2Info getEtherBasicL2InfoFromModel(int n) throws NoSuchInterface, InvalidOperation {
        sBasicL2Info sBasicL2Info2 = this.lineModels[n].getEtherBasicL2Info();
        if (db.on()) {
            db.finest("sL1Info: row=" + n);
            db.finest("   niMode=" + sBasicL2Info2.niMode.value());
            db.finest("   macLearningState=" + sBasicL2Info2.macLearningState);
            db.finest("   sIngressCOS=" + sBasicL2Info2.sIngressCOS);
            db.finest("   cEtherType=" + sBasicL2Info2.cEtherType);
            db.finest("   sEtherType=" + sBasicL2Info2.sEtherType);
        }
        return sBasicL2Info2;
    }

    private Boolean getEgressQOSFromModel(int n) throws NoSuchInterface, InvalidOperation, WrongInterfaceType {
        return this.lineModels[n].getEgressQOS();
    }

    private sStormControlInfo getStormControlInfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType {
        sStormControlInfo sStormControlInfo2 = this.lineModels[n].getLayer2LineModel().getStromControlInfo();
        return sStormControlInfo2;
    }

    private eMRouter getIgmpMrouterFromModel(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.lineModels[n].getIgmpMrouter();
    }

    private eAISActionType getAisActionFromModel(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.lineModels[n].getAisAction();
    }

    private eProtActionType getProtActionFromModel(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.lineModels[n].getProtAction();
    }

    private sL1Info getEtherL1InfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType, NotSupportedOnEquipment {
        sL1Info sL1Info2 = this.lineModels[n].getEtherL1Info();
        if (db.on()) {
            db.finest("sL1Info: row=" + n);
            db.finest("   duplex=" + sL1Info2.duplex.value());
            db.finest("   speed=" + sL1Info2.speed.value());
            db.finest("   bandwidth=" + sL1Info2.ingressQos.committedInfoRate);
            db.finest("   flowControl=" + sL1Info2.flowControl);
            db.finest("   mtu=" + sL1Info2.mtu);
        }
        return sL1Info2;
    }

    private sL1AdminInfo getEtherL1AdminInfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType, NotSupportedOnEquipment {
        sL1AdminInfo sL1AdminInfo2 = this.lineModels[n].getEtherL1AdminInfo();
        if (db.on()) {
            db.finest("sL1Info: row=" + n);
            db.finest("   duplex=" + sL1AdminInfo2.duplex.value());
            db.finest("   speed=" + sL1AdminInfo2.speed.value());
            db.finest("   flowControl=" + sL1AdminInfo2.flowControl);
        }
        return sL1AdminInfo2;
    }

    private eMediaType getEthMediaTypeFromModel(int n) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        eMediaType eMediaType2 = this.lineModels[n].getEthMediaType();
        if (db.on()) {
            db.finest("eMediaType: row=" + n);
            db.finest("   Media Type=" + eMediaType2.value());
        }
        return eMediaType2;
    }

    public Attribute getEthMediaType(int n) {
        return this.getAttributeFor("EtherMediaType", this.etherMediaType[n].value());
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    private String getLineNumber(int n) {
        try {
            IPortModel iPortModel = this.lineModels[n].getPortModel();
            return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
        }
        catch (Exception exception) {
            if (XPL2MapEtherPortTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 11: 
            case 12: 
            case 16: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        block23: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumber(n);
                    }
                    case 1: {
                        return this.getMTU(n);
                    }
                    case 2: {
                        return this.getSpeed(n);
                    }
                    case 4: {
                        return this.getAdminDuplex(n);
                    }
                    case 3: {
                        return this.getAdminSpeed(n);
                    }
                    case 10: {
                        return this.getNim(n);
                    }
                    case 7: {
                        return this.getBandwidth(n);
                    }
                    case 8: {
                        return this.getCommSize(n);
                    }
                    case 9: {
                        return this.getExSize(n);
                    }
                    case 13: {
                        return this.getIngress(n);
                    }
                    case 5: {
                        return this.getFlowControl(n);
                    }
                    case 11: {
                        return this.getEgress(n);
                    }
                    case 12: {
                        return this.getMAC(n);
                    }
                    case 14: {
                        return this.getEtherIn(n);
                    }
                    case 15: {
                        return this.getEtherOut(n);
                    }
                    case 16: {
                        return this.getIgmpMrouter(n) == eMRouter.L2_STATIC_MROUTER ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 17: {
                        return this.getAisAction(n);
                    }
                    case 18: {
                        return this.getProtAction(n);
                    }
                    case 6: {
                        return this.getEthMediaType(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block23;
                db.println("Error in getValueAt in XPL2MapEtherPortTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 0: {
                return;
            }
            case 2: {
                this.etherL1Info[n].speed = eEtherSpeed.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 10: {
                this.etherBasicL2Info[n].niMode = eNiValue.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 5: {
                this.etherL1Info[n].flowControl = eFlowControlNegotiated.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 12: {
                if (!(object instanceof Boolean)) break;
                this.etherBasicL2Info[n].macLearningState = (Boolean)object;
                break;
            }
            case 7: {
                try {
                    short s;
                    this.etherL1Info[n].ingressQos.committedInfoRate = s = Short.parseShort(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                break;
            }
            case 8: {
                this.etherL1Info[n].ingressQos.committedBurstSize = eBucketSize.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 9: {
                this.etherL1Info[n].ingressQos.excOrPeakBurstSize = eBucketSize.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 1: {
                try {
                    int n3;
                    this.etherL1Info[n].mtu = n3 = Integer.parseInt(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                break;
            }
            case 13: {
                this.etherBasicL2Info[n].sIngressCOS = (short)((Attribute)object).getIntValue();
                break;
            }
            case 11: {
                this.egressQOS[n] = (Boolean)object;
                break;
            }
            case 14: {
                try {
                    int n4 = Integer.parseInt(object.toString(), 16);
                    for (int i = 0; i < this.getRowCount(); ++i) {
                        this.etherBasicL2Info[i].cEtherType = (short)n4;
                        this.fireTableCellUpdated(i, n2);
                    }
                    this.isDirty[0][n2] = true;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                break;
            }
            case 15: {
                try {
                    int n5 = Integer.parseInt(object.toString(), 16);
                    this.etherBasicL2Info[n].sEtherType = (short)n5;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                break;
            }
            case 16: {
                this.igmpMrouter[n] = (Boolean)object == true ? eMRouter.L2_STATIC_MROUTER : eMRouter.L2_NONE_MROUTER;
                break;
            }
            case 17: {
                this.aisAction[n] = eAISActionType.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 18: {
                this.protAction[n] = eProtActionType.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 6: {
                this.etherMediaType[n] = eMediaType.from_int(((Attribute)object).getIntValue());
                if (!db.on()) break;
                db.finest("eMediaType: row=" + n);
                db.finest("Setting Media Type=" + ((Attribute)object).getIntValue());
                break;
            }
            default: {
                return;
            }
        }
        if (!bl) {
            this.isDirty[n][n2] = true;
        }
        this.fireTableCellUpdated(n, n2);
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public Attribute getAttributeFor(String string, int n) {
        INodeModel iNodeModel = this.eqpmtModel.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeForVal(string, n);
    }

    protected Attribute[] getAttributeArray(String string) {
        INodeModel iNodeModel = this.eqpmtModel.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeArray(string);
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
                this.fireTableRowsUpdated(n, n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void applyToModel(int n, DetailedLog detailedLog) throws Exception {
        try {
            if (this.isDirty[n][11]) {
                this.lineModels[n].setEgressQOS(this.egressQOS[n]);
            }
            if (this.isDirty[n][16]) {
                this.lineModels[n].setIgmpMrouter(this.igmpMrouter[n]);
            }
            if (this.isDirty[n][17]) {
                this.lineModels[n].setAisAction(this.aisAction[n]);
                this.checkAisSquelchActionAdmitted(n, detailedLog);
            }
            if (this.isDirty[n][18]) {
                this.lineModels[n].setProtAction(this.protAction[n]);
            }
            if (this.isDirty[n][2] || this.isDirty[n][7] || this.isDirty[n][8] || this.isDirty[n][9] || this.isDirty[n][5] || this.isDirty[n][1]) {
                this.etherL1Info[n].duplex = eEtherDuplex.ETHER_DUPLEX_FULL;
                this.lineModels[n].setEtherL1Info(this.etherL1Info[n]);
            }
            if (this.isDirty[n][12] || this.isDirty[n][10] || this.isDirty[n][15] || this.isDirty[n][14] || this.isDirty[n][13]) {
                this.lineModels[n].setEtherBasicL2Info(this.etherBasicL2Info[n]);
            }
            if (this.isDirty[n][6]) {
                this.lineModels[n].setEthMediaType(this.etherMediaType[n]);
            }
        }
        catch (Exception exception) {
            EID eID;
            String string = null;
            string = exception instanceof ProvisionError ? ((eID = ((ProvisionError)((Object)exception)).getEID()) != null ? ErrorMsg.getString((EID)eID) : ErrorMsg.getString((EID)CEMC.EID_PROVISION_ERROR)) : (exception instanceof ConfigError ? ErrorMsg.getString((EID)EMC.EID_PROTECTED_LINE_DENY) : ErrorMsg.getString((EID)CEMC.EID_PROVISION_ERROR));
            if (detailedLog != null) {
                eID = new DetailedLog(3, string + " Port " + this.myPortRenderer.getPortString((IEntityModel)this.lineModels[n].getPortModel(), false), exception);
                detailedLog.addChild((DetailedLog)eID);
                detailedLog.updateTime();
            }
            throw exception;
        }
    }

    private void checkAisSquelchActionAdmitted(int n, DetailedLog detailedLog) {
        block8: {
            if (this.aisAction[n] == eAISActionType.AIS_ACTION_SQUELCH_PORT) {
                SVlanProfileModels sVlanProfileModels = SVlanProfileModels.getInstance(this.lineModels[n].getNodeModelDelegate());
                try {
                    Map<Integer, Map<Short, ISVlanProfileModel>> map = sVlanProfileModels.getProfileMappings(this.lineModels[n].getPortModel());
                    if (!map.isEmpty()) {
                        Set<Integer> set = map.keySet();
                        Iterator<Integer> iterator = set.iterator();
                        while (iterator.hasNext()) {
                            Map<Short, ISVlanProfileModel> map2 = map.get(iterator.next());
                            Set<Short> set2 = map2.keySet();
                            for (Short s : set2) {
                                ISVlanProfileModel iSVlanProfileModel = map2.get(s);
                                if (!iSVlanProfileModel.getLinkIntegrity() || detailedLog == null) continue;
                                DetailedLog detailedLog2 = new DetailedLog(2, ErrorMsg.getString((EID)EMC.WID_AIS_PORT_SQUELCH_NC_LINK_INTEGRITY, (Object)iSVlanProfileModel.getName(), (Object)this.myPortRenderer.getPortString((IEntityModel)this.lineModels[n].getPortModel(), false), (Object)s));
                                detailedLog.addChild(detailedLog2);
                                detailedLog.updateTime();
                            }
                        }
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                catch (CTCUserException cTCUserException) {
                    if (!db.on()) break block8;
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
            }
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetLineCache(int n) {
        try {
            this.etherL1Info[n] = this.getEtherL1InfoFromModel(n);
            if (this.eqpmtModel.getEqType() == 272) {
                this.etherL1AdminInfo[n] = this.getEtherL1AdminInfoFromModel(n);
            }
            this.egressQOS[n] = this.getEgressQOSFromModel(n);
            this.etherBasicL2Info[n] = this.getEtherBasicL2InfoFromModel(n);
            this.igmpMrouter[n] = this.getIgmpMrouterFromModel(n);
            this.aisAction[n] = this.getAisActionFromModel(n);
            this.protAction[n] = this.getProtActionFromModel(n);
            this.etherMediaType[n] = this.getEthMediaTypeFromModel(n);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.isDirty[n][i] = false;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public Integer getMTU(int n) throws NoSuchInterface {
        if (db.on()) {
            db.println("getMTU " + this.etherL1Info[n].mtu);
        }
        return new Integer(this.etherL1Info[n].mtu);
    }

    public Attribute getIngress(int n) throws NoSuchInterface {
        return this.getAttributeFor("IngressCos", this.etherBasicL2Info[n].sIngressCOS);
    }

    public Attribute getFlowControl(int n) throws NoSuchInterface {
        return this.getAttributeFor("EtherFlowControl", this.etherL1Info[n].flowControl.value());
    }

    public Short getBandwidth(int n) throws NoSuchInterface {
        if (db.on()) {
            db.println("getBandwidth " + this.etherL1Info[n].ingressQos.committedInfoRate);
        }
        return new Short(this.etherL1Info[n].ingressQos.committedInfoRate);
    }

    public Attribute getSpeed(int n) throws NoSuchInterface {
        if (db.on()) {
            db.println("getSpeed " + this.etherL1Info[n].speed);
        }
        if (this.etherL1Info[n].speed.value() == 4) {
            return this.getAttributeFor("EtherSpeed", this.etherL1Info[n].speed.value());
        }
        if (this.etherL1Info[n].speed.value() == 1 || this.lineModels[n].supportsFESpeed()) {
            return this.getAttributeFor("EtherFeSpeedMode", this.etherL1Info[n].speed.value());
        }
        return this.getAttributeFor("EtherGeSpeedMode", this.etherL1Info[n].speed.value());
    }

    public Attribute getCommSize(int n) throws NoSuchInterface {
        return this.getAttributeFor("EtherBucket", this.etherL1Info[n].ingressQos.committedBurstSize.value());
    }

    public Attribute getExSize(int n) throws NoSuchInterface {
        return this.getAttributeFor("EtherBucket", this.etherL1Info[n].ingressQos.excOrPeakBurstSize.value());
    }

    public Attribute getNim(int n) throws NoSuchInterface {
        if (db.on()) {
            db.println("getNim " + this.etherBasicL2Info[n].niMode);
        }
        return this.getAttributeFor("NIMode", this.etherBasicL2Info[n].niMode.value());
    }

    public Boolean getEgress(int n) throws NoSuchInterface {
        return this.egressQOS[n];
    }

    public Boolean getMAC(int n) throws NoSuchInterface {
        return new Boolean(this.etherBasicL2Info[n].macLearningState);
    }

    public eMRouter getIgmpMrouter(int n) {
        return this.igmpMrouter[n];
    }

    public Attribute getAisAction(int n) {
        return this.getAttributeFor("AisActions", this.aisAction[n].value());
    }

    public Attribute getProtAction(int n) {
        return this.getAttributeFor("ProtActions", this.protAction[n].value());
    }

    public String getEtherIn(int n) throws NoSuchInterface {
        String string = Integer.toHexString(this.etherBasicL2Info[n].cEtherType & 0xFFFF).toUpperCase();
        for (int i = string.length(); i < 4; ++i) {
            string = "0" + string;
        }
        return string;
    }

    public String getEtherOut(int n) throws NoSuchInterface {
        String string = Integer.toHexString(this.etherBasicL2Info[n].sEtherType & 0xFFFF).toUpperCase();
        for (int i = string.length(); i < 4; ++i) {
            string = "0" + string;
        }
        return string;
    }

    public Attribute getAdminSpeed(int n) throws NoSuchInterface {
        if (db.on()) {
            db.println("getAdminSpeed " + this.etherL1AdminInfo[n].speed);
        }
        if (this.etherL1AdminInfo[n].speed.value() == 4) {
            return this.getAttributeFor("EtherSpeed", this.etherL1AdminInfo[n].speed.value());
        }
        return this.getAttributeFor("EtherGeSpeed", this.etherL1AdminInfo[n].speed.value());
    }

    public Attribute getAdminDuplex(int n) throws NoSuchInterface {
        if (db.on()) {
            db.println("getAdminDuplex " + this.etherL1AdminInfo[n].duplex);
        }
        return this.getAttributeFor("EtherDuplex", this.etherL1AdminInfo[n].duplex.value());
    }

    public Attribute[] getEtherModeAttrsTwoVals() {
        return this.getAttributeArray("EtherGeSpeedMode");
    }

    public Attribute[] getEtherModeAttrsFeTwoVals() {
        return this.getAttributeArray("EtherFeSpeedMode");
    }

    public Attribute[] getEtherModeAttrsOneVal() {
        return this.getAttributeArray("EtherSpeed");
    }

    public Attribute[] getBucketAttrs() {
        return this.getAttributeArray("EtherBucket");
    }

    public Attribute[] getFlowAttrs() {
        return this.getAttributeArray("EtherFlowControl");
    }

    public Attribute[] getNimAttrs() {
        return this.getAttributeArray("NIMode");
    }

    public Attribute[] getAisActionAttrs() {
        return this.getAttributeArray("AisActions");
    }

    public Attribute[] getProtActionAttrs() {
        return this.getAttributeArray("ProtActions");
    }

    public Attribute[] getIngressAttrs() {
        return this.getAttributeArray("IngressCos");
    }

    public Attribute[] getFeMediaTypeAttrs() {
        return this.getAttributeArray("EtherMediaType");
    }

    public Attribute[] getGeMediaAttrs() {
        return this.getAttributeArray("EthernetMedia");
    }

    public Attribute[] getRadFlowCntrlAttrs() {
        return this.getAttributeArray("RadFlowControl");
    }

    public Attribute[] getRadSquelchAttrs() {
        return this.getAttributeArray("RadSquelch");
    }

    private void registerWithLineModels() {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    public void dispose() {
        this.unRegisterWithLineModels();
    }
}

