/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.XPL2ChannelGroupModel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmCardDualPane;
import cerent.cms.ui.dwdm.FECPmPane;
import cerent.cms.ui.dwdm.OpticsPmHistPane;
import cerent.cms.ui.dwdm.OpticsPmStatPane;
import cerent.cms.ui.dwdm.OtnPmPane;
import cerent.cms.ui.xpl2.XPL2ChannelGroupPmPane;
import cerent.cms.ui.xpl2.XPL2EtherPortPmPane;
import cerent.util.SDebug;
import java.awt.Component;
import javax.swing.JLabel;

public class XPL2PmPane
extends NodeProvPane
implements ITabName {
    private XPL2ModuleModel eqpmtModel;
    private XPL2LineModel[] etherLineModels = null;
    private XPL2ChannelGroupModel[] channelGroupModels = null;
    private static final SDebug db = new SDebug("XPL2PmPane");

    public XPL2PmPane(String string, TabbedView tabbedView, XPL2ModuleModel xPL2ModuleModel) {
        super(string, tabbedView);
        this.eqpmtModel = xPL2ModuleModel;
        this.etherLineModels = xPL2ModuleModel.getXPL2EtherLines();
        this.channelGroupModels = xPL2ModuleModel.getChannelGroupModels();
        if (this.etherLineModels == null) {
            db.println("ERROR: Ether Line or Pos Line Models are null!");
            this.add(new JLabel("This pane is unimplemented."));
            return;
        }
        this.subTabs = new SubTabbedView(xPL2ModuleModel, tabbedView);
        this.subTabs.addTab("Ether Ports", (Component)this.getEtherPortPmTab());
        this.subTabs.addTab("Channel Groups", (Component)this.getChannelGroupsPmTab());
        this.subTabs.addTab("Optics PM", (Component)((Object)this.getOptPmTab("Optics PM")));
        this.subTabs.addTab("OTN PM", (Component)((Object)this.getG709PmTab("OTN PM")));
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    private AbstractPane getOptPmTab(String string) {
        return new AbstractSubTabbedPane(string, this.subTabs){

            @Override
            public void createSubTabs() {
                this.subTabs.addTab("Current Values", (Component)((Object)new OpticsPmStatPane("Current Values", this.subTabs, XPL2PmPane.this.eqpmtModel.getDwdmLineModels())));
                this.subTabs.addTab("Historical PM", (Component)((Object)new OpticsPmHistPane("Historical PM", this.subTabs, XPL2PmPane.this.eqpmtModel.getDwdmLineModels())));
            }
        };
    }

    private AbstractPane getG709PmTab(String string) {
        return new AbstractSubTabbedPane(string, this.subTabs){

            @Override
            public void createSubTabs() {
                this.subTabs.addTab("ITU-T G.709 PM", (Component)((Object)this.getOtnPmTab("ITU-T G.709 PM", XPL2PmPane.this.eqpmtModel.getDwdmTrkLineModels())));
                this.subTabs.addTab("FEC PM", (Component)((Object)this.getFECPmTab("FEC PM", XPL2PmPane.this.eqpmtModel.getDwdmTrkLineModels())));
            }

            private DwdmCardDualPane getOtnPmTab(String string, DwdmTrkLineModel[] dwdmTrkLineModelArray) {
                return new DwdmCardDualPane(this.subTabs, dwdmTrkLineModelArray, new OtnPmPane(string, this.subTabs, dwdmTrkLineModelArray), 4);
            }

            private DwdmCardDualPane getFECPmTab(String string, DwdmTrkLineModel[] dwdmTrkLineModelArray) {
                return new DwdmCardDualPane(this.subTabs, dwdmTrkLineModelArray, new FECPmPane(string, this.subTabs, dwdmTrkLineModelArray), 4);
            }
        };
    }

    private Pane getEtherPortPmTab() {
        return new XPL2EtherPortPmPane("Ether Ports", this.getParentView(), this.etherLineModels);
    }

    private Pane getChannelGroupsPmTab() {
        return new XPL2ChannelGroupPmPane("Channel Groups", this.getParentView(), this.channelGroupModels);
    }

    @Override
    public boolean hasSubTabs() {
        return true;
    }
}

