/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sCVlanRange;
import cerent.cms.idl.EtherL2Media.sRepSegmentRange;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.RepPortInfo;
import cerent.cms.model.RepSegmentAttribute;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Container;
import java.awt.Frame;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class XPL2REPSegmentTableModel
extends AbstractTableModel
implements Observer {
    public static final int PORT_INDEX = 0;
    public static final int PORT_TYPE_INDEX = 1;
    public static final int PREFERED_INDEX = 2;
    public static final int VLB_ENABLED_INDEX = 3;
    public static final int VLB_SVLAN_CVLAN_INDEX = 4;
    public static final int VLB_TRIGGER_DELAY_INDEX = 5;
    public static final int VLB_PORT_ID_INDEX = 6;
    public static final int VLB_PREF_PORT = 7;
    public static final int STCH_ENABLED_INDEX = 8;
    public static final int STCH_PORT_INDEX = 9;
    public static final int STCH_SEGMENT_INDEX = 10;
    private EntityCellRenderer myPortRenderer = null;
    static final String[] columnNames = new String[]{"Port", "Port Role", "Port Preferred", "VLB Enabled", "SVLAN", "VLB Preempt Delay", "VLB Port ID", "VLB Preferred Port", "STCN Enabled", "STCN Port", "STCN Segment"};
    private Frame frame;
    protected RepSegmentAttribute repSegment = null;
    protected XPL2ModuleModel equipmentModel = null;
    private boolean isDirty = false;
    private static final SDebug db = new SDebug("XPL2REPSegmentTableModel");

    public XPL2REPSegmentTableModel(Container container, XPL2ModuleModel xPL2ModuleModel) {
        this.frame = JOptionPane.getFrameForComponent(container);
        this.equipmentModel = xPL2ModuleModel;
        this.myPortRenderer = new EntityCellRenderer(false);
    }

    protected void updateModel(RepSegmentAttribute repSegmentAttribute) {
        this.repSegment = repSegmentAttribute;
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    @Override
    public int getRowCount() {
        if (this.repSegment != null) {
            return this.repSegment.getPortInfo().length;
        }
        return 0;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        block15: {
            try {
                RepPortInfo repPortInfo = this.repSegment.getPortInfo()[n];
                switch (n2) {
                    case 0: {
                        return this.getPortName(repPortInfo.portIndex);
                    }
                    case 1: {
                        return this.getRepPortType(repPortInfo.portType.value());
                    }
                    case 2: {
                        return repPortInfo.prefer;
                    }
                    case 3: {
                        return repPortInfo.vlbConfig.vlbEnabled;
                    }
                    case 4: {
                        return this.buildSvnalRangeString(repPortInfo.vlbConfig.vlanRange, repPortInfo.vlbConfig.vlanRangeCnt);
                    }
                    case 5: {
                        return String.valueOf(repPortInfo.pDelay);
                    }
                    case 6: {
                        return String.valueOf(this.getVlbPortId(repPortInfo.vlbConfig.repPortId));
                    }
                    case 7: {
                        return repPortInfo.vlbConfig.preferred;
                    }
                    case 8: {
                        return repPortInfo.stcnConfig.stcnEnabled;
                    }
                    case 9: {
                        return this.getPortName(repPortInfo.stcnConfig.index);
                    }
                    case 10: {
                        return this.buildRepSegmentRangeString(repPortInfo.stcnConfig.segRange, repPortInfo.stcnConfig.segRangeCnt);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block15;
                db.println("Error in getValueAt in XPL2QinQModeTableModel " + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    private String getVlbPortId(char[] cArray) {
        char[] cArray2 = new char[18];
        for (int i = 0; i < 18; ++i) {
            cArray2[i] = '\u0000';
        }
        String string = null;
        if (cArray.length > 0) {
            int n = 0;
            for (n = 0; n < cArray.length; ++n) {
                if (cArray[n] == '\u0000') {
                    cArray2[n] = '\u0000';
                    break;
                }
                cArray2[n] = cArray[n];
            }
            string = String.valueOf(cArray2);
            string = string.substring(0, n);
        }
        return string;
    }

    private String getPortName(int n) {
        EntityCellRenderer entityCellRenderer = new EntityCellRenderer(false);
        try {
            return entityCellRenderer.getPortString((IEntityModel)this.equipmentModel.getNodeModelDelegate().getIfModels().getInterfaceModel(n).getPortModel(), false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getRepPortType(int n) {
        return this.getAttributeFor("RepPortType", n);
    }

    private String getRepVlbState(int n) {
        return this.getAttributeFor("RepVlbState", n);
    }

    public String getAttributeFor(String string, int n) {
        INodeModel iNodeModel = this.equipmentModel.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeForVal(string, n).getKey();
    }

    public String buildSvnalRangeString(sCVlanRange[] sCVlanRangeArray, short n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            sCVlanRange sCVlanRange2 = sCVlanRangeArray[i];
            string = sCVlanRange2.first == sCVlanRange2.last ? string + sCVlanRange2.first + (n > 1 && i != n - 1 ? "," : "") : string + sCVlanRange2.first + "-" + sCVlanRange2.last + (n > 1 && i != n - 1 ? "," : "");
        }
        return string;
    }

    public String buildRepSegmentRangeString(sRepSegmentRange[] sRepSegmentRangeArray, short n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            sRepSegmentRange sRepSegmentRange2 = sRepSegmentRangeArray[i];
            string = sRepSegmentRange2.first == sRepSegmentRange2.last ? string + sRepSegmentRange2.first + (n > 1 && i != n - 1 ? "," : "") : string + sRepSegmentRange2.first + "-" + sRepSegmentRange2.last + (n > 1 && i != n - 1 ? "," : "");
        }
        return string;
    }

    protected Frame getFrame() {
        return this.equipmentModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }

    public void dispose() {
    }

    @Override
    public void update(Observable observable, Object object) {
    }
}

