/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractProvPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.XPL2StormControlTableModel;
import cerent.util.EMC;
import cerent.util.ObservableManager;
import cerent.util.gui.NumberTextField;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2StormControlProvPane
extends NodeProvPane
implements ITabName,
ActionListener,
TableModelListener {
    protected XPL2StormControlTableModel dataModel = null;
    protected XPL2ModuleModel eqpmtModel = (XPL2ModuleModel)this.getUiModel();
    protected XPL2LineModel[] lineModels = this.eqpmtModel.getXPL2EtherLines();
    private ObservableManager _obsMgr;

    public XPL2StormControlProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.dataModel = new XPL2StormControlTableModel(this.eqpmtModel, this.lineModels);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.dataModel.addTableModelListener(this);
        this.customizedProvPane();
        this.add((Component)uScrollPane);
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("calling enteringPage");
        }
        this.getObsMgr().setPassing(true);
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
        this.getObsMgr().setPassing(false);
        this.unRegisterWithModel();
    }

    @Override
    public void refreshMyLines(Object object) {
        this.lineModels = this.eqpmtModel.getXPL2EtherLines();
        this.dataModel.refreshMyLines(this.lineModels);
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        NumberTextField numberTextField = new NumberTextField(8);
        NumberTextField numberTextField2 = new NumberTextField(8);
        NumberTextField numberTextField3 = new NumberTextField(8);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        tableColumn.setCellEditor(new AbstractProvPane.NumberRangeCellEditor(numberTextField, 0, 0xFFFFFF, EMC.EID_STORM_CONTROL_OUT_OF_RANGE));
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
        tableColumn.setCellEditor(new AbstractProvPane.NumberRangeCellEditor(numberTextField2, 0, 0xFFFFFF, EMC.EID_STORM_CONTROL_OUT_OF_RANGE));
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(4));
        tableColumn.setCellEditor(new AbstractProvPane.NumberRangeCellEditor(numberTextField3, 0, 0xFFFFFF, EMC.EID_STORM_CONTROL_OUT_OF_RANGE));
    }

    @Override
    public void applyChangesToModel() throws Exception {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.dataModel.applyToModel(i);
        }
        this.resetDirty();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        this.getObsMgr().addObservable((Observable)((Object)this.eqpmtModel));
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    protected void unRegisterWithModel() {
        int n;
        super.registerWithModel();
        this.getObsMgr().removeObservable((Observable)((Object)this.eqpmtModel));
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    @Override
    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2StormControlProvPane;
    }
}

